--------------
--Admin Menu--
--------------
function ulx.adminMenuCallback(userid, id, time, text)
	if id == ULib.ID_EXIT then return end
	_ServerCommand( id .. ";gm_sv_setrules\n" )
	ULib.addTimer( 0.1, 1, ulx.cc_adminMenu, userid ) -- Redisplay it to them. Put on timer so server recognizes changes.
	ulx.logServAct( userid, "#A set \"" .. id .. "\"" )
end

function ulx.cc_adminMenu( userid, args )

	local menu = ULib.Menu:new( "ULX Admin Menu", ulx.adminMenuCallback, ulx.menu_skin )
	local access = ULib.GET_SUBCONCOMMAND( "ulx adminmenu" ).access

	if _GetConVar_Bool( "sv_cheats" ) then
		menu:addOption( "Cheats Off", "sv_cheats 0", access )
	else
		menu:addOption( "Cheats On", "sv_cheats 1", access )	
	end
		
	if _GetConVar_Bool( "gm_sv_playerdamage" ) then
		menu:addOption( "Player Damage Off", "gm_sv_playerdamage 0", access )	
	else
		menu:addOption( "Player Damage On", "gm_sv_playerdamage 1", access )
	end
	
	if _GetConVar_Bool( "gm_sv_pvpdamage" ) then
		menu:addOption( "PvP Damage Off", "gm_sv_pvpdamage 0", access )	
	else
		menu:addOption( "PvP Damage On", "gm_sv_pvpdamage 1", access )	
	end		
	
	if _GetConVar_Bool( "gm_sv_teamdamage" ) then
		menu:addOption( "Team Damage Off", "gm_sv_teamdamage 0", access )	
	else
		menu:addOption( "Team Damage On", "gm_sv_teamdamage 1", access )	
	end			
	
	if _GetConVar_Bool( "gm_sv_allowspawning" ) then
		menu:addOption( "Disallow Spawning", "gm_sv_allowspawning 0", access )	
	else
		menu:addOption( "Allow Spawning", "gm_sv_allowspawning 1", access )	
	end
	
	if _GetConVar_Bool( "gm_sv_allowmultigun" ) then
		menu:addOption( "Disallow Multigun", "gm_sv_allowmultigun 0", access )	
	else
		menu:addOption( "Allow Multigun", "gm_sv_allowmultigun 1", access )	
	end				
	
	if _GetConVar_Bool( "gm_sv_allowphysgun" ) then
		menu:addOption( "Disallow Physgun", "gm_sv_allowphysgun 0", access )	
	else
		menu:addOption( "Allow Physgun", "gm_sv_allowphysgun 1", access )	
	end	
	
	if _GetConVar_Bool( "gm_sv_allweapons" ) then
		menu:addOption( "All Weapons Off", "gm_sv_allweapons 0", access )	
	else
		menu:addOption( "All Weapons On", "gm_sv_allweapons 1", access )
	end	
	
	if _GetConVar_Bool( "gm_sv_allowignite" ) then
		menu:addOption( "Disallow Ignite", "gm_sv_allowignite 0", access )	
	else
		menu:addOption( "Allow Ignite", "gm_sv_allowignite 1", access )	
	end	
	
	if _GetConVar_Bool( "gm_sv_noclip" ) then
		menu:addOption( "Disallow Noclip", "gm_sv_noclip 0", access )	
	else
		menu:addOption( "Allow Noclip", "gm_sv_noclip 1", access )	
	end
	
	if _GetConVar_Bool( "gm_sv_allownpc" ) then
		menu:addOption( "Disallow NPC Spawning", "gm_sv_allownpc 0", access )	
	else
		menu:addOption( "Allow NPC Spawning", "gm_sv_allownpc 1", access )	
	end	
	
	if _GetConVar_Bool( "gm_sv_allowlamps" ) then
		menu:addOption( "Disallow Lamps", "gm_sv_allowlamps 0", access )	
	else
		menu:addOption( "Allow Lamps", "gm_sv_allowlamps 1", access )	
	end

	menu:showMenu( userid )
end

ulx.CONCOMMAND( "adminmenu", ulx.cc_adminMenu, "- Shows the ULX admin menu", ACCESS_CVAR, "!adminmenu", false )

---------------
--Client Menu--
---------------
local user_choice 	=	{}
local ID_SLAP		=	1
local ID_SLAY		=	2
local ID_SSLAY		=	3
local ID_FREEZE		=	4
local ID_UNFREEZE	=	5
local ID_GOD		=	6
local ID_UNGOD		=	7
local ID_IGNITE		=	8
local ID_KICK		=	9
local ID_KICKBAN	=	10
local ID_TEAM_RED	=	11
local ID_TEAM_GREEN	=	12
local ID_TEAM_BLUE	=	13
local ID_TEAM_YELLOW	=	14
local ID_GIMP		=	15
local ID_UNGIMP		=	16
local ID_BLIND		=	17
local ID_UNBLIND	=	18

local function clientMenuFinal( userid, choice, seconds )
	local target = user_choice[ userid ]
	if not target or not _PlayerInfo( target, "connected" ) then -- ERROR!
		return
	end

	if choice == ULib.ID_EXIT then
		return
	elseif choice == ID_SLAP then
		ULib.callCmd( userid, "ulx slap " .. target )
	elseif choice == ID_SLAY then
		ULib.callCmd( userid, "ulx slay " .. target )
	elseif choice == ID_SSLAY then
		ULib.callCmd( userid, "ulx sslay " .. target )
	elseif choice == ID_GOD then
		ULib.callCmd( userid, "ulx god " .. target )
	elseif choice == ID_UNGOD then
		ULib.callCmd( userid, "ulx ungod " .. target )
	elseif choice == ID_FREEZE then
		ULib.callCmd( userid, "ulx freeze " .. target )
	elseif choice == ID_UNFREEZE then
		ULib.callCmd( userid, "ulx unfreeze " .. target )
	elseif choice == ID_IGNITE then
		ULib.callCmd( userid, "ulx ignite " .. target )
	elseif choice == ID_KICK then
		ULib.callCmd( userid, "ulx kick " .. target )
	elseif choice == ID_KICKBAN then
		ULib.callCmd( userid, "ulx kickban " .. target .. " 0" )
	elseif choice == ID_TEAM_RED then
		ULib.callCmd( userid, "ulx team " .. target .. " red" )
	elseif choice == ID_TEAM_GREEN then
		ULib.callCmd( userid, "ulx team " .. target .. " green" )
	elseif choice == ID_TEAM_BLUE then
		ULib.callCmd( userid, "ulx team " .. target .. " blue" )
	elseif choice == ID_TEAM_YELLOW then
		ULib.callCmd( userid, "ulx team " .. target .. " yellow" )
	elseif choice == ID_GIMP then
		ULib.callCmd( userid, "ulx gimp " .. target )
	elseif choice == ID_UNGIMP then
		ULib.callCmd( userid, "ulx ungimp " .. target )
	elseif choice == ID_BLIND then
		ULib.callCmd( userid, "ulx blind " .. target )
	elseif choice == ID_UNBLIND then
		ULib.callCmd( userid, "ulx unblind " .. target )
	end

end

local function clientMenuCallback( userid, target, seconds )
	if target == ULib.ID_EXIT then return end
	
	user_choice[ userid ] = target
	local menu = ULib.Menu:new( "ULX Command", clientMenuFinal, ulx.menu_skin )
	menu:addOption( "Slap Player", ID_SLAP, ULib.GET_SUBCONCOMMAND( "ulx slap" ).access )
	menu:addOption( "Slay Player", ID_SLAY, ULib.GET_SUBCONCOMMAND( "ulx slay" ).access )
	menu:addOption( "SSlay Player", ID_SSLAY, ULib.GET_SUBCONCOMMAND( "ulx sslay" ).access )
	menu:addOption( "Kick Player", ID_KICK, ULib.GET_SUBCONCOMMAND( "ulx kick" ).access )
	menu:addOption( "Kickban Player", ID_KICKBAN, ULib.GET_SUBCONCOMMAND( "ulx kickban" ).access )
	menu:addOption( "Give Godmode", ID_GOD, ULib.GET_SUBCONCOMMAND( "ulx god" ).access )
	menu:addOption( "Remove Godmode", ID_UNGOD, ULib.GET_SUBCONCOMMAND( "ulx ungod" ).access)
	menu:addOption( "Freeze Player", ID_FREEZE, ULib.GET_SUBCONCOMMAND( "ulx freeze" ).access )
	menu:addOption( "Unfreeze Player", ID_UNFREEZE, ULib.GET_SUBCONCOMMAND( "ulx unfreeze" ).access )
	menu:addOption( "Ignite Player", ID_IGNITE, ULib.GET_SUBCONCOMMAND( "ulx ignite" ).access )
	menu:addOption( "Force Team Red", ID_TEAM_RED, ULib.GET_SUBCONCOMMAND( "ulx team" ).access )
	menu:addOption( "Force Team Blue", ID_TEAM_BLUE, ULib.GET_SUBCONCOMMAND( "ulx team" ).access )
	menu:addOption( "Force Team Green", ID_TEAM_GREEN, ULib.GET_SUBCONCOMMAND( "ulx team" ).access )
	menu:addOption( "Force Team Yellow", ID_TEAM_YELLOW, ULib.GET_SUBCONCOMMAND( "ulx team" ).access )
	menu:addOption( "Gimp", ID_GIMP, ULib.GET_SUBCONCOMMAND( "ulx gimp" ).access )
	menu:addOption( "Ungimp", ID_UNGIMP, ULib.GET_SUBCONCOMMAND( "ulx ungimp" ).access )
	menu:addOption( "Blind", ID_UNGIMP, ULib.GET_SUBCONCOMMAND( "ulx blind" ).access )
	menu:addOption( "Unblind", ID_UNGIMP, ULib.GET_SUBCONCOMMAND( "ulx unblind" ).access )
	menu:showMenu( userid )
end

function ulx.cc_clientMenu( userid, args )
	local menu = ULib.Menu:new( "Choose a Player", clientMenuCallback, ulx.menu_skin )
	menu:addPlayerOptions()
	menu:showMenu( userid )
end

ulx.CONCOMMAND( "clientmenu", ulx.cc_clientMenu, "- Shows the client admin menu", ACCESS_SLAY, "!clientmenu", false )

-------------
--Maps Menu--
-------------

ulx.maps = ULib.filesInDir( "maps" )
local maps = ulx.maps -- Make this easier for us.
c = 1
while c <= table.getn( maps ) do -- We need a while loop so it keeps evaluating the condition, even when we remove.
	if string.sub( maps[ c ], -4 ) == ".bsp" then
		maps[ c ] = string.sub( maps[ c ], 1, -5 )
		c = c + 1
	else
		table.remove( maps, c )
	end
end
c = nil -- Free memory

table.sort( ulx.maps )

function ulx.sendMapMenu( userid )
	if not ulx.ucl.query( userid, ACCESS_MAP ) then
		return
	end

	for _, map in ipairs( maps ) do
		_spawnmenu.AddItem( userid, "Changelevel", "+" .. map, "ulx map " .. map )
	end
end

ulx.ucl:addAccessCallback( ulx.sendMapMenu )


-------------
--Misc Menu--
-------------
function ulx.sendMiscMenu( userid )
	if ulx.ucl.query( userid, ULib.GET_SUBCONCOMMAND( "ulx clean" ).access ) then
		_spawnmenu.AddItem( userid, "Misc ULX", "@Cleanups", "" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+Clean Ragdolls", "ulx clean ragdolls" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+Clean Flames", "ulx clean flames" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+Clean Props", "ulx clean props" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+Clean Sprites", "ulx clean sprites" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+Clean Vehicles", "ulx clean vehicles" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+Clean NPCs", "ulx clean npcs" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+Clean All", "ulx clean all" )
	end

	if ulx.ucl.query( userid, ULib.GET_SUBCONCOMMAND( "ulx exec" ).access ) then
		_spawnmenu.AddItem( userid, "Misc ULX", "@Configs", "" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+Build mode", "ulx exec build.cfg" )
		_spawnmenu.AddItem( userid, "Misc ULX", "+DM mode", "ulx exec deathmatch.cfg" )
	end
end
ulx.ucl:addAccessCallback( ulx.sendMiscMenu )


---------------
--Limits Menu--
---------------
local ID_SERVERLIMITS = 1
local ID_CLIENTLIMITS = 2

function limitsCallback(userid, id, time, text)
	if id == ULib.ID_EXIT then return end

	local title = string.gsub( id[ 1 ], "gm_sv_", "" ) -- Take this off so it doesn't go off the menu.
	local submit = function ()
		_ServerCommand( id[1] .. " " .. _GetConVar_Float( id[1] ) + id[2] .. "; gm_sv_setrules\n" )
		ulx.logServAct( userid, "#A set \"" .. id[1] .. " " .. _GetConVar_Float( id[1] ) + id[2] "\"" )
	end
	local menu = ULib.Menu:new( title .. " " .. _GetConVar_Float( id[1] ) + id[2], limitsCallback, ulx.menu_skin )
	menu:addOption( "- 10", { id[1], id[2] - 10 } )
	menu:addOption( "- 1", { id[1], id[2] - 1 } )
	menu:addOption( "+ 1", { id[1], id[2] + 1 } )
	menu:addOption( "+ 10", { id[1], id[2] + 10 } )
	menu:addOption( "Accept", _, _, submit )
	menu:showMenu( userid )
end

function limitMenuCallback(userid, id, time, text)
	if id == ULib.ID_EXIT then return end

	local menu
	local prefix
	if id == ID_CLIENTLIMITS  then
		menu = ULib.Menu:new( "Client Limits", limitsCallback, ulx.menu_skin )
		prefix = "client"
	elseif id == ID_SERVERLIMITS  then
		menu = ULib.Menu:new( "Server Limits", limitsCallback, ulx.menu_skin )
		prefix = "server"
	else
		return
	end

	menu:addOption( "Balloons (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_balloons" ) .. ")", { "gm_sv_" .. prefix .. "limit_balloons", 0 } )
	menu:addOption( "Effects (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_effects" ) .. ")", { "gm_sv_" .. prefix .. "limit_effects", 0 } )
	menu:addOption( "Emitters (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_emitters" ) .. ")", { "gm_sv_" .. prefix .. "limit_emitters", 0 } )
	menu:addOption( "Props (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_props" ) .. ")", { "gm_sv_" .. prefix .. "limit_props", 0 } )
	menu:addOption( "RagDolls (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_ragdolls" ) .. ")", { "gm_sv_" .. prefix .. "limit_ragdolls", 0 } )
	menu:addOption( "Sprites (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_sprites" ) .. ")", { "gm_sv_" .. prefix .. "limit_sprites", 0 } )
	menu:addOption( "Thrusters (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_thrusters" ) .. ")", { "gm_sv_" .. prefix .. "limit_thrusters", 0 } )
	menu:addOption( "Wheels (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_wheels" ) .. ")", { "gm_sv_" .. prefix .. "limit_wheels", 0 } )
	menu:addOption( "NPCs (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_npcs" ) .. ")", { "gm_sv_" .. prefix .. "limit_npcs", 0 } )
	menu:addOption( "Vehicles (" .. _GetConVar_String( "gm_sv_" .. prefix .. "limit_vehicles" ) .. ")", { "gm_sv_" .. prefix .. "limit_vehicles", 0 } )

	menu:showMenu( userid )
end

function ulx.cc_limitsMenu(userid)
	local menu = ULib.Menu:new( "Limits Menu", limitMenuCallback, ulx.menu_skin )
	menu:addOption( "Client Limits", ID_CLIENTLIMITS  )
	menu:addOption( "Server Limits", ID_SERVERLIMITS  )

	menu:showMenu( userid )
end
ulx.CONCOMMAND( "limitsmenu", ulx.cc_limitsMenu, "A menu for adjusting client/server limits.", ACCESS_CVAR, "!limitsmenu" )


-------------
--Main Menu--
-------------
local ID_CLIENTMENU	=	1
local ID_ADMINMENU	=	2
local ID_LIMITSMENU	=	3

local function mainMenuCallback( userid, choice, seconds )
	if choice == ULib.ID_EXIT then
		return
	elseif choice == ID_CLIENTMENU then
		ulx.cc_clientMenu( userid )
	elseif choice == ID_ADMINMENU then
		ulx.cc_adminMenu( userid )
	elseif choice == ID_LIMITSMENU then
		ulx.cc_limitsMenu( userid )
	end
end

function ulx.cc_menu( userid, args )
	local mainMenu = ULib.Menu:new( "ULX Main Menu", mainMenuCallback, ulx.menu_skin )
	mainMenu:addOption( "Client Menu", ID_CLIENTMENU, ULib.GET_SUBCONCOMMAND( "ulx clientmenu" ).access )
	mainMenu:addOption( "Admin Menu", ID_ADMINMENU, ULib.GET_SUBCONCOMMAND( "ulx adminmenu" ).access )
	mainMenu:addOption( "Limits Menu", ID_LIMITSMENU, ULib.GET_SUBCONCOMMAND( "ulx limitsmenu" ).access )

	mainMenu:showMenu( userid )
end
ulx.CONCOMMAND( "menu", ulx.cc_menu, "- Shows the ULX main menu", ACCESS_ALL, "!menu" )