local textKey = 452
local rectKey = 451
local timer
local hide = {} -- Who to hide it from

ulx.timed = {}
ulx.timed.help = {}

function ulx.timed.cc_ulx_timed( userid, args )
	if ULib.trim( args ) ~= "" then
		ULib.console( userid, "Invalid command entered." )
	end

       	ULib.console( userid, "Timed Command Help:" )
       	ULib.console( userid, "All these commands show a warning message on users' screens. Time is in seconds." )
       	for k, v in pairs( ulx.timed.help ) do
		local t = ULib.GET_SUBCONCOMMAND( "ulx timed " .. v.cmd )
		if ulx.ucl:query( userid, t.access ) then
			if v.say_cmd then
				ULib.console( userid, " o " .. v.cmd .. " " .. v.help .. " (say:" .. v.say_cmd .. ")" )
			else
				ULib.console( userid, " o " .. v.cmd .. " " .. v.help )
			end
		end
	end
end
ULib.BEGIN_SUBCONCOMMAND( "ulx timed", ulx.timed.cc_ulx_timed, _, ACCESS_MAP, ulx.ucl )
table.insert( ulx.help, { cmd="timed", help="- Offers timed functions." } ) -- Put ourselves in ulx help.

function ulx.timed.CONCOMMAND( command, fn_call, help, access, say_cmd, hide_say )
	if not ULib.checkParams( { command, fn_call }, { "string", "function" } ) then return nil, ULib.ERR_ARGS end
	if say_cmd and ULib.trim( say_cmd ) == "" then say_cmd = nil end

	if say_cmd and type( say_cmd ) == "string" then
		ULib.addSayCommand( say_cmd, fn_call, help, hide_say, access, ulx.ucl )
	end

	table.insert( ulx.timed.help, { cmd=command, help=help, say_cmd=say_cmd } )
	return ULib.ADD_SUBCONCOMMAND( "ulx timed", command, fn_call, help, access, ulx.ucl )
end

function ulx.cc_hide( userid, args, argv, argc )
	hide[ userid ] = true
	_GModRect_Hide( userid, rectKey )
	_GModText_Hide( userid, textKey )
end
ulx.CONCOMMAND( "hide", ulx.cc_hide, "- Hides a timed action warning.", ACCESS_ALL, "!hide" )

local function update( message, finish, callback )
	if _CurTime() > finish then
		callback()
		ULib.haltTimer( timer )
		_GModRect_Hide( 0, rectKey )
		_GModText_Hide( 0, textKey )
		timer = nil
		return
	end

	local timestamp = ULib.getTimeStamp( finish - _CurTime(), true )

	local str = message .. "\n                " .. timestamp .. "\n   Say \"!hide\" to hide this"

	for i=1, _MaxPlayers() do
		if not hide[ i ] and _PlayerInfo( i, "connected" ) then
			ULib.sendText( i, textKey, 0.41, 0.215, str, 2, 255, 255, 255, 255, "Default", 0, 0, 0 )
		end
	end
end

function ulx.timed.cc_cancel( userid, args, argv, argc )
	if timer then
		ULib.haltTimer( timer )
		timer = nil
		_GModRect_Hide( 0, rectKey )
		_GModText_Hide( 0, textKey )
		local hide = {}

		ULib.tsay( 0, "Timer has been halted!" )
	end
	return
end
ulx.timed.CONCOMMAND( "cancel", ulx.timed.cc_cancel, "- Stops any active timed function.", ACCESS_RCON )

function ulx.timed.cc_shutdown( userid, args, argv, argc )
	if timer then
		ULib.tsay( userid, "There is already a timer active! You must stop that one first." )
		return
	end

	if not argv[ 1 ] or not tonumber( argv[ 1 ] ) then
		ULib.tsay( userid, "Please specify number of seconds until shutdown." )
	end

	local time = tonumber( argv[ 1 ] )
	finish = _CurTime() + time
	timer = ULib.addTimer( 1, 0, update, "Time until server shutdown:", _CurTime() + tonumber( argv[ 1 ] ), function() _ServerCommand( "quit\n" ) end  )

	ULib.tsay( userid, "Timed shutdown has been started. Use \"ulx timed cancel\" to stop it." )
	ULib.tsay( 0, "ATTENTION: A TIMED SERVER SHUTDOWN HAS BEEN ACTIVATED! Please take screenshots or save your work while you have time." )
	ULib.sendRect( userid, rectKey, 0.4, 0.2, 0.2, 0.09, 9999, 255, 80, 80, 220, "ULib/menu", 0, 0, 0 )
end
ulx.timed.CONCOMMAND( "shutdown", ulx.timed.cc_shutdown, "<time> - Shuts down the server in specified seconds.", ACCESS_RCON )

function ulx.timed.cc_cleanup( userid, args, argv, argc )
	if timer then
		ULib.tsay( userid, "There is already a timer active! You must stop that one first." )
		return
	end

	if not argv[ 1 ] or not tonumber( argv[ 1 ] ) then
		ULib.tsay( userid, "Please specify number of seconds until cleanup." )
	end

	local time = tonumber( argv[ 1 ] )
	finish = _CurTime() + time
	timer = ULib.addTimer( 1, 0, update, "Time until server cleanup:", _CurTime() + tonumber( argv[ 1 ] ), function() ulx.cc_cleanAll( 0 ) end  )

	ULib.tsay( userid, "Timed cleanup has been started. Use \"ulx timed cancel\" to stop it." )
	ULib.tsay( 0, "ATTENTION: A TIMED SERVER CLEANUP HAS BEEN ACTIVATED! Please take screenshots or save your work while you have time." )
	ULib.sendRect( userid, rectKey, 0.4, 0.2, 0.2, 0.09, 9999, 255, 80, 80, 220, "ULib/menu", 0, 0, 0 )
end
ulx.timed.CONCOMMAND( "cleanup", ulx.timed.cc_cleanup, "<time> - Cleans up the server in specified seconds (deletes prop, ragdolls, etc).", ACCESS_RCON )

function ulx.timed.cc_changelevel( userid, args, argv, argc )
	if timer then
		ULib.tsay( userid, "There is already a timer active! You must stop that one first." )
		return
	end

	if not argv[ 1 ] or not tonumber( argv[ 1 ] ) then
		ULib.tsay( userid, "Please specify number of seconds until cleanup." )
	end
	
	local map = argv[ 2 ]
	if string.sub( map, -4 ) == ".bsp" then
		map = string.sub( map, 1, -5 ) -- Take off the .bsp
	end

	if not _file.Exists( "maps/" .. map .. ".bsp" ) then
		ULib.tsay( userid, map .. " is not a valid map!" )
		return
	end

	local time = tonumber( argv[ 1 ] )
	finish = _CurTime() + time
	timer = ULib.addTimer( 1, 0, update, "Time until server changelevel:", _CurTime() + tonumber( argv[ 1 ] ), function() _ServerCommand( "changelevel " .. map .. "\n" ) end  )

	ULib.tsay( userid, "Timed changelevel has been started. Use \"ulx timed cancel\" to stop it." )
	ULib.tsay( 0, "ATTENTION: A TIMED SERVER CHANGELEVEL (" .. map .. ") HAS BEEN ACTIVATED!" )
	ULib.tsay( 0, "Please take screenshots or save your work while you have time." )
	ULib.sendRect( userid, rectKey, 0.4, 0.2, 0.21, 0.09, 9999, 255, 80, 80, 220, "ULib/menu", 0, 0, 0 )
end
ulx.timed.CONCOMMAND( "changelevel", ulx.timed.cc_changelevel, "<time> <map> - Changes levels in specified seconds.", ACCESS_MAP )

local function newPlayer( name, userid )
	if timer then -- They need the rect.
		hide[ userid ] = false
		ULib.sendRect( userid, rectKey, 0.4, 0.2, 0.21, 0.09, 9999, 255, 80, 80, 220, "ULib/menu", 0, 0, 0 )
	end
end
HookEvent( "eventPlayerActive", newPlayer )