if ULib.pluginEnabled() then -- If they have the module required

local blocked = {
"unbindall",
"unbind",
--"bind",  --Disable these if you wish. Cexec makes sure blocked commands can't be passed in a bind.
--"bindtoggle",
"quit",
"exit",
"quti",
"disconnect",
"_restart",
"buildcubemaps", -- This basically makes them have to redownload whatever map they're on.
"map",
"lua",
"lua_openscript",
"fov",
"_fov",
"r_aspectratio",
"alias",
}

function ulx.cc_cexec( userid, args, argv, argc )
	if argc < 2 then
		ULib.tsay( userid, ulx.LOW_ARGS )
		return
	end

	local targets, err = ULib.getUsers( argv[ 1 ], _, true, ulx.ucl, userid ) -- Enable keywords
	if not targets then
		ULib.tsay( userid, err )
		return
	end

	local command_args = ULib.trim( ULib.stripQuotes( ULib.trim( string.gsub( args, "^%S+%s+(.*)$", "%1" ) ) ) ) -- Want to be extra careful.
	local command_argv = ULib.splitArgs( command_args )

	if ULib.isInTable( blocked, string.lower( command_argv[ 1 ] ) ) then
		ULib.tsay( userid, "This cexec command is blocked." )
		return
	end

	-- This will give us the arguments for the client's command.
	local client_args = ULib.trim( ULib.stripQuotes( ULib.trim( string.gsub( command_args, "^%S+%s+(.*)$", "%1" ) ) ) ) -- Want to be extra careful.
	local client_argv = ULib.splitArgs( client_args )

	if string.find( client_args, ";" ) then -- Let's split it up.
		local commands = ULib.explode( command_args, ";" )
		for _, command in ipairs( commands ) do
			ulx.cc_cexec( userid, argv[ 1 ] .. " " .. command, { argv[ 1 ] }, 2 ) -- We only use argv[ 1 ] so don't bother with splitArgs.
		end
		return -- Done processing, children should get it all.
	end

	if command_argv[ 1 ] == "bind" then -- Make sure they're not passing a blocked command in bind.
		if ULib.isInTable( blocked, string.lower( ULib.stripQuotes( client_argv[ 2 ] ) ) ) then
			ULib.tsay( userid, "This cexec command is blocked." )
			return
		end
	end

	for _, v in ipairs( targets ) do
		ulx.logUserAct(userid, v, "#A executed \"" .. command_args .. "\" on #T")
		_ServerCommand( "ulib_plugin_cexec " .. v .. " " .. command_args .. "\n" )
	end
end
ulx.CONCOMMAND( "cexec", ulx.cc_cexec, "<user(s)> <command> - Execute a command on a client like you were at their console.", ACCESS_PLAYER, "!cexec", true )


function ulx.cc_thetime( userid, args, argv, argc )
	local h, m = ULib.sToHMS( ULib.getTime() )
	local time
	if h >= 12 then -- PM
		h = math.mod( h, 12 )
		if h == 0 then h = 12 end -- For 12 PM
		time = h .. ":" .. string.format( "%02i", m ) .. " PM"
	else
		if h == 0 then h = 12 end -- For 12 AM
		time = h .. ":" .. string.format( "%02i", m ) .. " AM"
	end
	ULib.tsay( 0, "The time is now " .. time )
end
ulx.CONCOMMAND( "thetime", ulx.cc_thetime, "- Display the time.", ACCESS_ALL, "!thetime" )

end