--[[

	#############################################
	
		VMF CopyGun - Sphere Selector
		
	#############################################
	
]]--
_OpenScript( "includes/defines.lua" );
_OpenScript( "includes/vector3.lua" );
_OpenScript( "includes/misc.lua" );
_OpenScript( "includes/backcompat.lua" );
-- These variables are passed by the engine
-- Don't re-define them in your SWEP.
MyIndex			=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time
last_reload = 0;
-- Called when the weapon is created.
	function onInit( )
		_SWEPSetSound(MyIndex, "single_shot", "Airboat.FireGunRevDown");
	end
-- Called when player picks up weapon
	function onPickup( playerid )
	end
-- Called when player drops weapon
	function onDrop( playerid )
		_RunString("VMFCG.selection.SphereSprite("..Owner..",false)");
		_EntRemove(MyIndex);
	end
-- Weapon is about to be destroyed.
	function onRemove( )
		_RunString("VMFCG.selection.ColorizeAll("..Owner..",false)");
		_RunString("VMFCG.selection.SphereSprite("..Owner..",false)");
	end
-- Called every frame
	function onThink( )
	end
-- When the player presses left mouse button
	function onPrimaryAttack( )	
		_RunString("VMFCG.selection.SphereSelect("..Owner..")");
	end
-- When the player presses right mouse button
	function onSecondaryAttack( )
		_EntEmitSound(MyIndex,"weapons/stunstick/alyx_stunner2.wav");
		_RunString("VMFCG.selection.SelectEntitiesInSphere("..Owner..")");
	end
-- When Weapon is swapped to
	function Deploy( )
		_RunString("VMFCG.selection.SphereSprite("..Owner..",true)");
	end
-- When weapon swapped away from
	function Holster( )
		_RunString("VMFCG.selection.SphereSprite("..Owner..",false)");
	end
-- When player presses reload. Returning false means DON'T RELOAD. Although this will hitch on the client.
	function onReload( )
		if(last_reload + 0.7 <= _CurTime()) then
			last_reload = _CurTime();
			_RunString("VMFCG.selection.SphereSprite("..Owner..",false)");
			_RunString("VMFCG.selection.users["..Owner.."].session.pos1 = nil");
			_RunString("VMFCG.selection.users["..Owner.."].session.pos2 = nil");
			_RunString("VMFCG.selection.users["..Owner.."].session.stage = nil");
			_EntEmitSound(MyIndex,"vehicles/atv_ammo_open.wav");
		end
	end
-- Primary Attack Settings
	function getDamage() return 10 end
	function getPrimaryShotDelay()	return 0.2	end
	function getPrimaryIsAutomatic() return true end
	function getBulletSpread() return vector3( 0, 0, 0 ) end
	function getViewKick() return vector3( 0, 0, 0.0) end
	function getViewKickRandom() return vector3( 0, 0, 0 ) end
	function getNumShotsPrimary() return 0 end
	function getPrimaryAmmoType() return "" end
	function getMaxClipPrimary() return 1337 end
	function getDefClipPrimary() return 1337 end
	function getTracerFreqPrimary() return 0 end
	
-- Secondary attack Settings

	function getDamageSecondary() return 0 end
	function getSecondaryShotDelay() return 0.1 end
	function getSecondaryIsAutomatic() return false end
	function getBulletSpreadSecondary() return vector3( 0, 0, 0 ) end
	function getViewKickSecondary() return vector3( 0, 0, 0) end
	function getViewKickRandomSecondary() return vector3( 0, 0, 0 ) end
	function getNumShotsSecondary() return 0 end
	function getSecondaryAmmoType() return "" end
	function getMaxClipSecondary() return -1 end
	function getDefClipSecondary() return -1 end
	function getTracerFreqSecondary() return 0 end

-- Weapon Configuration
	
	function getViewModel( ) return "models/weapons/v_pistol.mdl" end
	function getWorldModel( ) return "models/weapons/w_pistol.mdl" end
	function getClassName() return "weapon_vmfcg_sphereselect" end
	function getHUDMaterial( ) return "gmod/SWEP/default" end
	function getDeathIcon( ) return "swep_default" end
	function getWeaponSwapHands() return false end
	function getWeaponFOV() return 55 end
	function getWeaponSlot() return 5 end
	function getWeaponSlotPos() return 51 end
	function getFiresUnderwater() return true end
	function getReloadsSingly() return false end
	function getAnimPrefix() return "pistol" end
	function getPrintName() return "~[VMFCG Sphere Massselect]~" end

	function getPrimaryScriptOverride() return 1 end
	function getSecondaryScriptOverride() return 3 end
	