--[[

	#################################################
	
		VMF CopyGun - Database Handling
		
	#################################################
	
]]--

VMFCG.database = {};
VMFCG.database.ExistantFiles = {};

VMFCG.database.patterns = dbloader:New(VMFCG.config.save_folder.."/database/patterns.db"); -- Stores all patterns
VMFCG.database.patterns:Load();
VMFCG.database.users = dbloader:New(VMFCG.config.save_folder.."/database/users.db"); -- Stores the users, who created the patterns
VMFCG.database.users:Load();
VMFCG.database.public = dbloader:New(VMFCG.config.save_folder.."/database/public.db"); -- Saves the deletion list
VMFCG.database.public:Load();
VMFCG.database.delete = dbloader:New(VMFCG.config.save_folder.."/database/deleted.db"); -- Saves the deletion list
VMFCG.database.delete:Load();
--[[
-- It seems, i will never finish/add the folder support. Most people even wont know how to use it anyway, because they are MingeFags
VMFCG.database.folders = dbloader:New(VMFCG.config.save_folder.."/database/folders.db"); -- Saves the patterns in subfolders
VMFCG.database.folders:Load();
--]]
VMFCG.database.absolute = dbloader:New(VMFCG.config.save_folder.."/database/absolute.db"); -- Handles, whether a file should be spawned absolutely or not
VMFCG.database.absolute:Load();

-- Set default database to the VMFCG Database (only patterns and users)
VMFCG.database.default = {"patterns","users"};
for _,database in VMFCG.database.default do
	local default = dbloader:New("lua/VMFCopyGun/data/default_database/"..database..".db");
	default:Load();
	local content = default:GetTable();
	for k,v in content do
		VMFCG.database[database]:Set(k,v);
	end
	VMFCG.database[database]:Save();
end

-- #############################################
-- ################### Optimisation ##################
-- #############################################

-- ############## Checks, if a file exists or not - reduces overhead and massive usage of _file.Exists() AND prevents crashes @aVoN
function VMFCG.database.FileExists(file)
	if(VMFCG.database.ExistantFiles[file] == nil) then
		if(not _file.Exists(VMFCG.config.save_folder.."/patterns/"..file..".vmf")) then
			VMFCG.database.ExistantFiles[file] = false;
			return false;
		else
			VMFCG.database.ExistantFiles[file] = true;
			return true;
		end
	end
	return VMFCG.database.ExistantFiles[file];
end

-- ############## Removes old entrys from the database @aVoN
function VMFCG.database.OptimiseDatabase()
	local optimize = {"patterns","delete","public","absolute"}
	for _,database in optimize do
		VMFCG.database[database]:Load()
		local content = VMFCG.copy(VMFCG.database[database]:GetTable())
		for k,v in content do
			if(not VMFCG.database.FileExists(k)) then
				VMFCG.database[database]:Unset(k);
				VMFCG.debug("VMFCG.database.OptimiseDatabase","Removed entry "..k.." from "..database.."-database");
			end
		end
		VMFCG.database[database]:Save();
	end
	VMFCG.debug("VMFCG.database.OptimiseDatabase","Optimised Database" );
end

-- #############################################
-- ################### Init #######################
-- #############################################

if(_CurTime() < 120) then
	-- Only optimize on startup, but not on script reload
	VMFCG.AddTimerOnce("VMFCG.database.OptimiseDatabase",2,1,VMFCG.database.OptimiseDatabase);
end
