--[[

	#############################################
	
		VMF CopyGun - Defines some constants
		
	#############################################
	
]]--
VMFCG.version = 1.2; -- The VMFCopyGun version
VMFCG.defines = {};
VMFCG.defines.materials = {}; -- Stores materialnames (gets called by VMFCG.core.getMaterialNames())
VMFCG.defines.RopeMaterial = {}; -- Stores Ropetypes
VMFCG.defines.BalloonColor = {}; -- Ballooncolors
VMFCG.defines.vehicles = {}; -- All vehicle scripts
VMFCG.defines.fixup = {}; -- Stores all special keys which need a fixup

-- Found rope materials in http://gmod.garry.tv/files/no_source_for_you_laugh_out_loud/gtil.cpp - I just searched google for "phys_spring springaxis" and found this "no_source_for_you_laugh_out_loud" folder. Sadly, the found URL was offline, but the google cache still existed. After searching google again for "no_source_for_you_laugh_out_loud", i found the current URL.


-- #############################################
-- ############### Rope Materials #####################
-- #############################################


VMFCG.defines.RopeMaterial[0] = "cable/rope.vmt";
VMFCG.defines.RopeMaterial[1] = "cable/cable.vmt";
VMFCG.defines.RopeMaterial[2] = "sprites/bluelight1.vmt";
VMFCG.defines.RopeMaterial[3] = "sprites/hydraspinalcord.vmt";
VMFCG.defines.RopeMaterial[4] = "sprites/physbeam.vmt";
VMFCG.defines.RopeMaterial[5] = "effects/com_shield002a.vmt";


-- #############################################
-- ############### Balloon colors #####################
-- #############################################


VMFCG.defines.BalloonColor[1] = "255 255 255";
VMFCG.defines.BalloonColor[2] = "8 255 255";
VMFCG.defines.BalloonColor[3] = "255 4 255";
VMFCG.defines.BalloonColor[4] = "7 255 5";
VMFCG.defines.BalloonColor[5] = "255 6 5";
VMFCG.defines.BalloonColor[6] = "255 255 4";
VMFCG.defines.BalloonColor[7] = "6 4 255";


--- #############################################
-- ############### Vehicle scripts #####################
-- #############################################

-- Load the vehiclescripts from the ini-file
VMFCG.defines.vehicles.scripts = {};

local vehicle_scripts = VMFCG.INIParser:new("lua/VMFCopyGun/config/defines/vehiclescripts.ini");
for _,v in vehicle_scripts["vehicle"] do
	VMFCG.defines.vehicles.scripts[v.model] = v.vehiclescript;
end

--- #############################################
-- ############### Vector Fixup for e.g the save engine #########
-- #############################################

VMFCG.defines.fixup.vectors = {"origin","attachpoint","hingeaxis","slideaxis","springaxis","position2","point0","point1"};

--- #############################################
-- ############### Targetname Fixup for e.g. SaveEngine ########
-- #############################################

VMFCG.defines.fixup.targetnames = {"attach1","attach2","NextKey","_attachentity","_killhierarchy","parentname","targetname","LaserTarget","target","LightningStart","LightningEnd","SourceEntityName","filtername","PointCamera","damagefilter","airboat_gun_model","control_volume"};

--- #############################################
-- ############### Access levels ######################
-- #############################################

VMFCG.defines.ALLOW_SPAWNING = "a"; -- Allow copy/spawning of props?
VMFCG.defines.ALLOW_PREVIEW = "b"; -- Allow preview?
VMFCG.defines.ALLOW_SAVE = "c"; -- Allow saving of contraptions?
VMFCG.defines.ALLOW_XSAVE = "d"; -- Allow xStack like saving of whole map contraptions?
VMFCG.defines.ALLOW_LOAD_OWN = "e"; -- Allow loading of own contraptions?
VMFCG.defines.ALLOW_LOAD_ALL = "f"; -- Allow loading of all contraptions?
VMFCG.defines.ALLOW_SELECT = "g"; -- Allow usage of the VMFCG Selecttool?
VMFCG.defines.ALLOW_SPHERESELECT = "h"; -- Allow usage of the VMFCG sphereselecttool?
VMFCG.defines.ALLOW_QUADSELECT = "i"; -- Allow usage of the VMFCG quadselecttool?
VMFCG.defines.ALLOW_SMARTSELECT = "j" -- Allow usage of the VMFCG Smart Selecttool?
VMFCG.defines.ALLOW_MARK_PUBLIC_OWN = "k"; -- Can the user (un)mark his own patterns public?
VMFCG.defines.ALLOW_MARK_PUBLIC_ALL = "l"; -- Can the user (un)mark all patterns public?
VMFCG.defines.ALLOW_DELETE_OWN = "m"; -- Allow deleting of own savefiles (allows the person too, to restore his own deleted files)?
VMFCG.defines.ALLOW_DELETE_ALL = "n"; -- Allow deleting of all save files (allows the person too, to restore any deleted filed)?
VMFCG.defines.ALLOW_CLEAR_DELETION_LIST = "o"; -- Allow deletionlist clearing (permant deletion of saves)?
VMFCG.defines.ALLOW_QMENU = "p"; -- Allow this player to see the VMFCopyGun Q menu?
VMFCG.defines.ALLOW_SCRIPT_RELOAD = "q"; -- Allow reloading of the script?
VMFCG.defines.ALLOW_SCRIPT_KILL_RELOAD = "r"; -- Allow kill-reloading of the script?
VMFCG.defines.ALLOW_SELECTING_OF_ALL_PROPS = "s"; --Can select any props. (When not set, this person can only select his own props, as long as PropProtector is installed)
VMFCG.defines.ALLOW_MARK_ABSOLUTE_OWN = "t"; -- Allows the person to set his own patterns absolute or relative?
VMFCG.defines.ALLOW_MARK_ABSOLUTE_ALL = "u"; -- Allows the person to set all patterns absolute or relative?
VMFCG.defines.ALLOW_KEEP_VMFLOADER_MENU_OPEN = "v"; -- Keeps the VMFLoader menu open when a contraption of it got spawned
VMFCG.defines.ALLOW_VMFREMOVER = "w" -- Allows the user to mass-remove a full VMFContraption

VMFCG.defines.RESTRICTION_PREVIEW_AMMOUNT = "maxpreviewammount"; -- How much entitys per preview allowed?
VMFCG.defines.RESTRICTION_SAVE_AMMOUNT = "maxsaveammount"; -- How much entitys allowed for a save?
VMFCG.defines.RESTRICTION_MIN_SAVE_AMMOUNT = "minsaveammount"; -- Whats the minimum of savable props?
VMFCG.defines.RESTRICTION_SPAWNTIMEOUT = "spawntimeout"; -- How much time, until the user is re-allowed to spawn a contraption?