--[[

	#############################################
	
		VMF CopyGun - Handles the HUD for the SWEPS and textoutputs
		
	#############################################
	
]]--

VMFCG.Hud = {};
VMFCG.Hud.slot_start = 6000;

-- ############## Hud constructor (object) @aVoN
function VMFCG.Hud:new(userid)
	local obj = {}
	setmetatable(obj,self);
	self.__index = self;
	obj.userid = userid;
	obj.rect_send = false;
	obj.x	= 0.01;
	obj.y = 0.33;
	obj.width = 0.25;
	obj.height = 0.16;
	obj.time = 9999;
	obj.fadein =0.25;
	obj.fadeout = 0.25;
	obj.topic = "";
	obj.lines = {};
	obj.old_lines = {};
	return obj;
end

-- ############## Creates the Rectangle (void) @aVoN
function VMFCG.Hud:DrawBox()
	if(not self.send) then
		_Hud.Rect("xm_mat/xMenu/xPanelS",self.x,self.y,self.width,self.height,255,255,255,255,self.time,self.fadein,self.fadeout,0,self.userid,VMFCG.Hud.slot_start);
		self.send = true;
	end
end

-- ############## Hides the Rectangle (void) @aVoN
function VMFCG.Hud:HideBox()
	self.send = false;
	_GModRect_Hide(self.userid,VMFCG.Hud.slot_start,0.1,self.fadeout);
end

-- ############## Sets the text to the rectangle (void) @aVoN
function VMFCG.Hud:Topic(topic)
	self.topic = topic;
	if(self.send) then
		self:Show();
	end
end

-- ############## Sets the text to the rectangle (void) @aVoN
function VMFCG.Hud:Text(text)
	self.lines = VMFCG.explode(text,"\n");
	if(self.send) then
		self:Show();
	end
end

-- ############## Shows the rectangle (void) @aVoN
function VMFCG.Hud:Show()
	if(not self.send) then
		-- First time draw part
		if(self.topic ~= "") then
			_Hud.Text("ChatFont",self.x+0.01,self.y+0.005,255,80,0,255,self.time,self.fadein,self.fadeout,self.topic,0,self.userid,VMFCG.Hud.slot_start)
		end
		for k,v in self.lines do
			_Hud.Text("ChatFont",self.x+0.015,self.y+0.005+k*0.022,255,255,230,255,self.time,self.fadein,self.fadeout,v,0,self.userid,VMFCG.Hud.slot_start+k);
		end
	else
		-- Update part
		if(self.old_topic ~= self.topic) then
			if(self.topic ~= "") then
				_Hud.Text("ChatFont",self.x+0.01,self.y+0.005,255,80,0,255,self.time,0,self.fadeout,self.topic,0,self.userid,VMFCG.Hud.slot_start)
			end
		end
		for k,v in self.lines do
			if(v ~= self.old_lines[k]) then
				_Hud.Text("ChatFont",self.x+0.015,self.y+0.005+k*0.022,255,255,255,255,self.time,0,self.fadeout,v,0,self.userid,VMFCG.Hud.slot_start+k);
			end
		end
		if(table.getn(self.old_lines) > table.getn(self.lines)) then
			-- Delete old lines, when there were more than before
			for k=(table.getn(self.lines)+1),table.getn(self.old_lines) do
				_GModText_Hide(self.userid,VMFCG.Hud.slot_start+k,0);
			end
		end
	end
	self:DrawBox();
	self.old_topic = tostring(self.topic);
	self.old_lines = VMFCG.copy(self.lines);
end

-- ############## Hides the rectangle (void) @aVoN
function VMFCG.Hud:Hide()
	if(self.topic ~= "") then
		_GModText_Hide(self.userid,VMFCG.Hud.slot_start,self.fadeout);
	end
	for k,v in self.lines do
		_GModText_Hide(self.userid,VMFCG.Hud.slot_start+k,self.fadeout);
	end
	self.send = false;
	self:HideBox();
end

-- ############## Shows a centermessage directly on a players screen (void) @aVoN
function VMFCG.Hud.Message(userid,text,hold)
	local hold = hold or 4;
	_Hud.Rect("xm_mat/xMenu/xPanelS",0.1,0.52,0.8,0.14,255,255,255,255,hold+0.25,0,0.1,0,userid,VMFCG.Hud.slot_start + 100 + userid);
	_Hud.Text("CloseCaption_Bold",0.13,0.571,255,255,255,255,hold,0,0.25,text,0,userid,VMFCG.Hud.slot_start + 200 + userid);
end
