--[[

	#############################################
	
		VMF CopyGun - Lib functions
		
	#############################################
	
]]--

-- #############################################
-- ############### Hook/Think/Timer once functions ##########
-- #############################################

VMFCG.debug_data = VMFCG.debug_data or {}; -- Stores debug data in a table, to retrieve them even with debugmode = false
VMFCG.think_funcs = VMFCG.think_funcs or {}; -- Saves all think functions by the VMFCG
VMFCG.timers_once = VMFCG.timers_once or {}; -- Same, but for timers
VMFCG.hooks = VMFCG.hooks or {};
-- Functions by H-=NooB=- http://forums.facepunchstudios.com/showthread.php?t=152903 - Added/Modified by aVoN

-- ############## Hooks (void)   @H-=NooB=-
function VMFCG.HookOnce(event,callback,name)
    VMFCG.hooks[event] = VMFCG.hooks[event] or {}
	if(VMFCG.hooks[event][name]) then
		if(g_EvenHooks[VMFCG.hooks[event][name]]) then
	        UnHookEvent(VMFCG.hooks[event][name]); 
			VMFCG.debug("VMFCG.HookOnce","Hook (".. event ..") Removed "..name);
		end
	end
    VMFCG.hooks[event][name] = HookEvent(event,callback);
	VMFCG.debug("VMFCG.HookOnce","Hook (".. event ..") Added "..name);
end
 
-- ############## Thinks (void)   @H-=NooB=-
function VMFCG.AddThinkFunctionOnce(id,func)
    if(VMFCG.think_funcs[id]) then
		if(gLuaThinkFunctions[VMFCG.think_funcs[id]] ~= nil) then
			gLuaThinkFunctions[VMFCG.think_funcs[id]] = nil;
			VMFCG.debug("VMFCG.AddThinkFunctionOnce","Think Removed "..id);
		end
	end
	local next_index = table.getn(gLuaThinkFunctions)+1;
    VMFCG.think_funcs[id] = next_index;
	gLuaThinkFunctions[next_index] = func;
	VMFCG.debug("VMFCG.AddThinkFunctionOnce","Think Added "..id);
end
 
-- ############## And for timers (void)  @H-=NooB=-
function VMFCG.AddTimerOnce(id,delay,rep,func,...)
    if(VMFCG.timers_once[id]) then
		if(Timer[VMFCG.timers_once[id]]) then -- Only do this, when it's a repeating timer
	        HaltTimer( VMFCG.timers_once[id] );
			VMFCG.debug("VMFCG.AddTimerOnce","Timer Removed "..id);
		end
	end
    VMFCG.timers_once[id] = AddTimer( delay , rep , func , unpack(arg) );
	VMFCG.debug("VMFCG.AddTimerOnce","Timer Added "..id);
end 

-- ############## Remove a timer ( void)  @aVoN
function VMFCG.HaltTimerOnce(id)
    if(VMFCG.timers_once[id] ~= nil) then
		if(Timer[VMFCG.timers_once[id]] ~= nil) then -- Only do this, when it's a repeating timer
	        HaltTimer( VMFCG.timers_once[id] );
			VMFCG.debug("VMFCG.AddTimerOnce","Timer Removed "..id);
		end
	end
end 

-- #############################################
-- ############### Debug function ####################
-- #############################################


-- ############## Debug (void) @aVoN
function VMFCG.debug(func,action)
	func = string.gsub(func,"%([%s]+%)",""); -- Remove brackets, h2 noobs maybe added again :D
	local debug_data = "[DEBUG] ("..func..") : "..action.."\n";
	if(VMFCG.config.debug_depth ~= nil and VMFCG.config.debug_depth ~= -1) then
		if(table.getn(VMFCG.debug_data) >= VMFCG.config.debug_depth and VMFCG.config.debug_depth ~= 0) then
			local tmp = {};
			for i=2,table.getn(VMFCG.debug_data) do -- Remove first entry...
				table.insert(tmp,VMFCG.debug_data[i]);
			end
			VMFCG.debug_data = tmp;
		end
		table.insert(VMFCG.debug_data,debug_data); --... and add the latest debuginformation to the table
	end
	if(VMFCG.config.debug or VMFCG.config.debug) then
		_Msg(debug_data); -- Only display debug informations in debugmode
	end
end

-- ############## Show debugdatas now (void) @aVoN
function VMFCG.show_debug(userid,arg)
	for _,v in VMFCG.debug_data do
		_PrintMessage(userid,HUD_PRINTCONSOLE, v)
	end
end


-- ############## Shows the position of entities for debugging (void) @aVoN

function VMFCG.debug_position()
	if(VMFCG.config.debug_position) then
		for k,v in VMFCG.Entities do
			if(_EntExists(k)) then
				local start = _EntGetPos(k);
				local ang = _EntGetAng(k);
				local end_pos = {}
				end_pos[1] = vecAdd(vecMul(_EntGetForwardVector(k),100),start);
				end_pos[2] = vecAdd(vecMul(_EntGetRightVector(k),100),start);
				end_pos[3] = vecAdd(vecMul(_EntGetUpVector(k),100),start);
				for i=1,3 do
					_EffectInit();
					_EffectSetEnt(0);
					_EffectSetStart(start);
					_EffectSetOrigin(end_pos[i]);
					_EffectSetScale(5);
					_EffectSetMagnitude(0.13);
					_EffectDispatch("FadingLineTeam");
				end
				local axis1 = VMFCG.Entities[k]:GetKeyValue("hingeaxis");
				local axis2 = VMFCG.Entities[k]:GetKeyValue("slideaxis");
				local use_this_axis = "";
				if(axis1 ~= "") then
					use_this_axis = axis1;
				end
				if(axis2 ~= "") then
					use_this_axis = axis2;
				end
				if(use_this_axis ~= "") then
					local t = VMFCG.explode(use_this_axis," ");
					t = vector3(t[1],t[2],t[3]);
					_EffectInit();
					_EffectSetEnt(1);
					_EffectSetStart(start);
					_EffectSetOrigin(vecAdd(start,vecMul(vecSub(t,start),75)));
					_EffectSetScale(10);
					_EffectSetMagnitude(0.13);
					_EffectDispatch("FadingLineTeam");
				end
			end
		end
	end
end


-- #############################################
-- ############### Math functions #####################
-- #############################################


-- ############## Vector rotation by angle ( vector3)  @aVoN
-- Don't use it because of the Gimbal Lock on bigger angles. I tried to manage to use Quaternions for ration of a vector, but i figured out, how to mange it without roating (hingeaxis/ang) - But I haven't removed the code - maybe someone need's it or maybe I for soem further operations :D
function VMFCG.vecRotate(v,rot)
	--[[
		Fact: v*M = v' => Rotation of a vector with a rotation matrix
		Roation on X axis
		| 1 		0		0		|		|	X	|		| 	X						|
		| 0		cos(a)	-sin(a)	|	*	|	Y	|	=	|	Y*cos(a) -Z*sin(a)		|
		| 0		sin(a)	cos(a)	|		|	Z	|		|	Y*sin(a) +Z*cos(a)		|

		Roation on Y axis
		| cos(b) 	0	sin(b)	|		|	X	|		| 	X*cos(b)+Z*sin(b)		|
		| 0			1	0		|	*	|	Y	|	=	|	Y						|
		| -sin(b)	0	cos(b)	|		|	Z	|		|	-X*sin(b)+Z*cos(b)		|

		Roation on Z axis
		| cos(c)	-sin(c)	0	|		|	X	|		| 	X*cos(c) -Y*sin(c)		|
		| sin(c)		cos(c)	0	|	*	|	Y	|	=	|	X*sin(c)+Y*cos(c)		|
		| 0			0		1	|		|	Z	|		|	Z						|

		Enough facts right now - Lets do it now
	--]]
	
	--Ordinates
	local X = v.x;
	local Y = v.y;
	local Z = v.z;
	
	--Rotation angels
	local a = math.rad(rot.x);
	local b = math.rad(rot.y);
	local c = math.rad(rot.z);
	-- Lets rotate aroun the X axis first
	X = X; -- No changes ;)
	Y = Y*math.cos(a) - Z*math.sin(a);
	Z = Y*math.sin(a) + Z*math.cos(a);
	-- And now around y.
	X = X*math.cos(b) + Z*math.sin(b);
	Y = Y; -- Huh, i have seen this before!
	Z = (-1)*X*math.sin(b) + Z*math.cos(b);
	-- Finally, around z
	X = X*math.cos(c) - Y*math.sin(c);
	Y = X*math.sin(c) + Y*math.cos(c);
	Z = Z; -- I'm doing this only, so you can see, what i have done at all.
	return vector3(X,Y,Z); -- Heureka, our rotated vector!
end


-- #############################################
-- ############### Data functions #####################
-- #############################################


-- ############## Explode function ( table )  @aVoN
function VMFCG.explode(str,seperator,repeats)
	if(str == "") then
		return {};
	end
	if(type(str) == "string") then
		local seperator = seperator or " ";
		local ret={};
		local lim=-1;
		local sep_len = string.len(seperator);
		local token=0;
		local char=0;
		local repeats = repeats or 0;
		while(true) do
			local pos=string.find(str,seperator,char+1,true);
			if (pos) then
				table.insert(ret,string.sub(str,char,pos-1));
				char=pos+sep_len;
				token=token+1;
			else
				table.insert(ret,string.sub(str,char));
				token=token+1;
				break;
			end
			if(token >= repeats and repeats ~= 0) then
				table.insert(ret,string.sub(str,char));
				break;
			end
		end
		return ret;
	else
		return str;
	end
end

-- ############## Implode function ( boolean )  @aVoN
function VMFCG.tobool(s)
	if(type(s) == "string") then
		s = string.lower(s);
	end
	if(s == "true" or s == "on" or s == true or tonumber(s) == 1) then
		return true;
	end
	if(s == "false" or s == "off" or s == false or tonumber(s) == 0) then
		return false;
	end
	return nil;
end

-- ############## Implode function ( table )  @aVoN
function VMFCG.implode(tbl,seperator)
	if(type(tbl) == "table") then
		seperator = seperator or " ";
		local str = "";
		for _,v in tbl do
			str = str .. seperator..v;
		end
		return string.sub(str,string.len(seperator)+1);
	end
end

-- ############## Removes white spaces from the beginning and the end of a string (string) @ aVoN
function VMFCG.trim(s)
	if(type(s) == "string") then
		s = string.gsub(s,"^[%s]+","");
		s = string.gsub(s,"[%s]+$","");
	end
	return s;
end

-- ############## Trims a table's values and keys (table) @ aVoN
function VMFCG.trim_table(t)
	local new_t = {};
	for k,v in t do
		new_t[VMFCG.trim(k)] = VMFCG.trim(v);
	end
	return new_t;
end

-- ############## Lowers a tables entrys ( table )  @aVoN
function VMFCG.lower_table(t)
	local new_t = {};
	for k,v in t do
		new_t[string.lower(k)] = string.lower(v);
	end
	return new_t;
end

-- ############## Merges two or more table's values to one new table (table is indexed by numbers => original keys get unset!) ( table )  @aVoN
function VMFCG.merge(...)
	local tables = {unpack(arg)};
	local nt = {};
	for _,t in tables do
		for _,v in t do
			table.insert(nt,v);
		end
	end
	return nt;
end

-- ############## Removes double values from a table ( table )  @aVoN
function VMFCG.unique(t)
	local nt = {};
	for k,v in t do
		nt[v] = k;
	end
	local ret = {};
	for k,v in nt do
		ret[v] = k;
	end
	return ret;
end

-- ############## Returns a table with number-keys from 1 to n ( table )  @aVoN
function VMFCG.values(t)
	local new = {};
	for _,v in t do
		table.insert(new,v);
	end
	return new;
end

-- ############## Copys a table recursivly to make it unique (otherwise, when you copyed table2 = table1, functions modify e.g. table2 (0253DA20) which is now the same as table1 and table1 gets modified either) ( table )  @aVoN
function VMFCG.copy(t)
	local new = {};
	for k,v in t do
		if(type(v) == "table") then
			new[k] = VMFCG.copy(v);
		else
			new[k] = v;
		end
	end
	return new;
end

-- ############## Counts the ammount of an tables values (integer) @aVoN
function VMFCG.count(t)
	local counter = 0;
	for _,v in t do
		counter = counter + 1;
	end
	return counter;
end

-- ############## Prints a any datatype recuirsivly ( any )  @aVoN
function print_r(arg,n)
	n = n or 0; -- Nil?
	local add_spaces = "";
	for k=1,n do
		add_spaces = add_spaces.."  ";
	end
	local arg_type = type(arg);
	if(arg_type == "table") then
		_Msg("(table) "..string.gsub(tostring(arg),"table: ","").." { \n");
		for k,v in arg do
			_Msg("  "..add_spaces.."("..type(k)..") \""..tostring(k).."\" => ");
			print_r(v,n+1);
		end
		_Msg(add_spaces.."}\n");
	elseif(arg_type == "function") then
		_Msg("(function) "..string.gsub(tostring(arg),"function: ","").."\n");
	else
		_Msg("("..arg_type..") \""..tostring(arg).."\"\n");
	end
end


-- #############################################
-- ############### Additional HUD functions ###############
-- #############################################


-- ############## Draws a quad ( void)  @aVoN
function VMFCG.Quad(id,userid,material,p1,p2,p3,p4,showtime,fade_in,fade_out)
	local fade_in = fade_in or 0;
	local fade_out = fade_out or 0;
	_GModQuad_Start(material);
	_GModQuad_SetVector(0,p1);
	_GModQuad_SetVector(1,p2);
	_GModQuad_SetVector(2,p3);
	_GModQuad_SetVector(3,p4);
	_GModQuad_SetTimings(0,fade_in,showtime,fade_out);
	_GModQuad_Send(userid,id);
end

-- ############## Sends an animated quad ( void)  @aVoN
function VMFCG.QuadAnimate(id,userid,material,p1,p2,p3,p4,showtime,fade_in,fade_out,len,ease)
	local fade_in = fade_in or 0;
	local fade_out = fade_out or 0;
	_GModQuad_Start(material);
	_GModQuad_SetVector(0,p1);
	_GModQuad_SetVector(1,p2);
	_GModQuad_SetVector(2,p3);
	_GModQuad_SetVector(3,p4);
	_GModQuad_SetTimings(0,fade_in,showtime,fade_out);
	_GModQuad_SendAnimate(userid,id,len,ease);
end

-- ############## Draws a QuadBox (void )  @aVoN
function VMFCG.QuadBox(id,userid,material,pos,width,length,height,showtime,fade_in,fade_out)
	local hwidth = width/2;
	local hheight = height/2;
	local hlength = length/2;
	local points = {};
	points[1] = {};
	points[2] = {};
	points[3] = {};
	-- Points for a sidewall (on y/z)
	points[1][1]=vecAdd(pos,vector3(0,-1*hwidth,hheight));
	points[1][2]=vecAdd(pos,vector3(0, hwidth,hheight));
	points[1][3]=vecAdd(pos,vector3(0, hwidth,-1*hheight));
	points[1][4]=vecAdd(pos,vector3(0,-1*hwidth,0-hheight));
	-- Points for a sidewall (on x/z)
	points[2][1]=vecAdd(pos,vector3(-1*hlength,0,hheight));
	points[2][2]=vecAdd(pos,vector3(hlength,0,hheight));
	points[2][3]=vecAdd(pos,vector3(hlength,0,-1*hheight));
	points[2][4]=vecAdd(pos,vector3(-1*hlength,0,-1*hheight));
	-- Points for a flat wall (on x/y)
	points[3][1]=vecAdd(pos,vector3(-1*hlength,hwidth,0));
	points[3][2]=vecAdd(pos,vector3(hlength,hwidth,0));
	points[3][3]=vecAdd(pos,vector3(hlength,-1*hwidth,0));
	points[3][4]=vecAdd(pos,vector3(-1*hlength,-1*hwidth,0));
	
	local quad = {};
	
	-- We need these for's, or Lua will set on a quad[1] = poits[1] the table quad[1] to be exactly the table points[1] instead of only assigning the values (which would fuck up!)
	quad[1] = {};
	quad[2] = {};
	for k,v in points[1] do
		quad[1][k] = v;
		quad[2][k] = v;
	end
	quad[3] = {};
	quad[4] = {};
	for k,v in points[2] do
		quad[3][k] = v;
		quad[4][k] = v;
	end
	quad[5] = {};
	quad[6] = {};
	for k,v in points[3] do
		quad[5][k] = v;
		quad[6][k] = v;
	end
	
	-- ##############	For the top and front (x/z)
	for i=1,4 do
		quad[1][i] = vecAdd(quad[1][i],vector3(hlength,0,hheight));
	end
	for i=1,4 do
		quad[2][i] = vecAdd(quad[2][i],vector3(-1*hlength,0,hheight));
	end
	
	-- ##############	The left and right (y/z)
	for i=1,4 do
		quad[3][i] = vecAdd(quad[3][i],vector3(0,hwidth,hheight));
	end
	for i=1,4 do
		quad[4][i] = vecAdd(quad[4][i],vector3(0,-1*hwidth,hheight));
	end
	
	-- ##############	The top and bottom sides (x/y)
	for i=1,4 do
		quad[6][i] = vecAdd(quad[6][i],vector3(0,0,height));
	end
	-- Generate all 6 sides right now
	for i=1,6 do
		VMFCG.Quad(id+i,userid,material,quad[i][1],quad[i][2],quad[i][3],quad[i][4],showtime,fade_in,fade_out);
	end
end
