--[[

	#############################################
	
		VMF CopyGun - The awesom Menu
		
	#############################################
	
]]--

VMFCG.menu = {};
VMFCG.menu.CurrentMap = string.lower(_GetCurrentMap()); -- Neccessary for absolute check
-- ############## Makes the listvars etc available @aVoN
for k=1,_MaxPlayers() do
	VMFCG.menu[k] = {};
	VMFCG.menu[k].GotQMenu = false;
	VMFCG.menu[k].UpdateMenu = true;
	VMFCG.menu[k].LastVMFLoaderSpawn = _CurTime();
	VMFCG.menu[k].LastAccess = {};
	VMFCG.menu[k].CopyGunUser = {} -- Saves all user menu contents
	VMFCG.menu[k].CopyGunMenu = ULib.XME:new("VMFCopyGun Patterns"); -- Saves the mainmenu with links to the usermenus
end

--- #############################################
-- ############### Database part ######################
-- #############################################

-- ############## Updates all patterns (all lowervase) (void) @aVoN
function VMFCG.menu.UpdatePatterns()
	VMFCG.debug("VMFCG.menu.UpdatePatterns","Reloading Patterns");
	VMFCG.database.patterns:Load() -- Reload the database
	VMFCG.menu.pattern_list = VMFCG.lower_table(VMFCG.copy(VMFCG.database.patterns:GetTable()));
end

-- ############## Returns the steamid of the owner of a pattern (string)@aVoN
function VMFCG.menu.GetUserByPattern(pattern)
	if(not VMFCG.menu.pattern_list) then
		VMFCG.menu.UpdatePatterns()
	end
	local pattern = string.lower(pattern);
	return VMFCG.trim(VMFCG.menu.pattern_list[pattern]);
end

-- ############## Updates all usernames by with lower steamid  but normal username (void) @aVoN
function VMFCG.menu.UpdateUsers()
	VMFCG.debug("VMFCG.menu.UpdateUsers","Reloading Users" );
	VMFCG.database.users:Load() -- Reload the database
	local new_table = VMFCG.copy(VMFCG.database.users:GetTable());
	local r = {};
	-- Only lower the steamids (table keys), but not the names
	for k,v in  new_table do
		r[string.lower(k)] = v;
	end
	VMFCG.menu.users_list =  r;
end

-- ############## Returns the Username to a in the DB stored SteamID (string) @aVoN
function VMFCG.menu.GetUserName(steamid)
	if(not steamid) then return nil end;
	if(not VMFCG.menu.users_list) then
		VMFCG.menu.UpdateUsers();
	end
	local steamid = string.lower(steamid);
	return VMFCG.trim(VMFCG.menu.users_list[steamid]);
end

-- ############## Updates all deleted patterns (void) @aVoN
function VMFCG.menu.UpdateDeleted()
	VMFCG.debug("VMFCG.menu.UpdateDeleted","Reloading Deletionlist" );
	VMFCG.database.delete:Load() -- Reload the database
	VMFCG.menu.deletion_list = VMFCG.lower_table(VMFCG.copy(VMFCG.database.delete:GetTable()));
end

-- ############## File is deleted? (boolean) @aVoN
function VMFCG.menu.IsDeleted(pattern)
	local pattern = string.lower(pattern);
	if(not VMFCG.menu.deletion_list) then
		VMFCG.menu.UpdateDeleted();
	end
	if(VMFCG.menu.deletion_list[pattern]) then
		return true;
	end
	return false;
end

-- ############## Updates foldernames (void) @aVoN
function VMFCG.menu.UpdateFolders()
	VMFCG.debug("VMFCG.menu.UpdateFolders","Reloading Subfolders" );
	VMFCG.database.folders:Load();
	VMFCG.menu.folder_list = {};
	local folders = VMFCG.copy(VMFCG.database.folders:GetTable());
	for k,v in folders do
		VMFCG.menu.folder_list[string.lower(k)] = v; -- Patternname = lower, but Foldername with all upper/lowercase names
	end
end

-- ############## Returns the foldername of a pattern (string) @aVoN
function VMFCG.menu.GetFolder(pattern)
	if(not VMFCG.menu.folder_list) then
		VMFCG.menu.UpdateFolders();
	end
	return VMFCG.trim(VMFCG.menu.folder_list[string.lower(pattern)]);
end

-- ############## Updates absolute database (void) @aVoN
function VMFCG.menu.UpdateAbsolute()
	VMFCG.menu.CurrentMap = string.lower(_GetCurrentMap());
	VMFCG.debug("VMFCG.menu.UpdateAbsolute","Reloading Absolute patterns" );
	VMFCG.database.absolute:Load();
	local absolute = VMFCG.lower_table(VMFCG.copy(VMFCG.database.absolute:GetTable()));
	-- Trim
	for k,v in absolute do
		absolute[k] = VMFCG.trim(v);
	end
	VMFCG.menu.absolute_list = absolute;
end

-- ############## Returns, if an pattern is absolute or not (boolean) @aVoN
function VMFCG.menu.IsAbsolute(pattern)
	if(not VMFCG.menu.absolute_list) then
		VMFCG.menu.UpdateAbsolute();
	end
	if(VMFCG.menu.absolute_list[string.lower(pattern)] == VMFCG.menu.CurrentMap) then
		return true;
	end
	return false;
end

-- ############## Updates all deleted patterns (void) @aVoN
function VMFCG.menu.UpdatePublic()
	VMFCG.debug("VMFCG.menu.UpdatePublic","Reloading Public files");
	VMFCG.database.public:Load() -- Reload the database
	VMFCG.menu.public_list = VMFCG.lower_table(VMFCG.copy(VMFCG.database.public:GetTable()));
end

-- ############## Is this pattern a public pattern? (boolean) @aVoN
function VMFCG.menu.IsPublic(pattern)
	if(not VMFCG.menu.public_list) then
		VMFCG.menu.UpdatePublic();
	end
	local pattern = string.lower(pattern);
	local owner = VMFCG.menu.GetUserByPattern(pattern);
	local username = VMFCG.menu.GetUserName(owner);
	if(VMFCG.menu.public_list[pattern] or not owner or not username) then
		return true;
	end
	return false;
end

--- #############################################
-- ############### Menu action callbacks #################
-- #############################################

-- ############## Reload Menu (void) @aVoN
function VMFCG.menu.ReloadMenu()
	-- Anytime, the scripts needs it to be neccessary to update the menu (when e.g. some patterns got removed/saved), it regenerates the menu
	for k=1,_MaxPlayers() do
		VMFCG.menu[k].UpdateMenu = true;
	end
	VMFCG.menu.Lists = nil;
end

-- ############## Changes the menus (void) @aVoN
function VMFCG.menu.ChangeMenu(index,arg,activator,open_main_menu)
	if(open_main_menu) then
		VMFCG.menu[activator].CopyGunMenu:Show(activator);
	else
		VMFCG.menu[activator].CopyGunMenu:Hide(activator);
		VMFCG.menu[activator].CopyGunUser[arg[1]]:Show(activator);
		VMFCG.menu[activator].CopyGunUser[arg[1]]:AddCloseEvent(VMFCG.menu.ChangeMenu,index,arg,activator,true);
	end
end

-- ############## Loads a VMF file (void) @aVoN
function VMFCG.menu.LoadFile(index,arg,activator)
	VMFCG.debug("VMFCG.menu.LoadFile","Loading file "..arg[2].." for "..activator );
	if(arg[3]) then -- Close menu and load?
		VMFCG.menu[activator].CopyGunUser[arg[1]]:Hide(activator);
		VMFCG.menu[activator].CopyGunUser[arg[1]]:HidePanel(activator);
		VMFCG.menu[activator].CopyGunMenu:Hide(activator);
	end
	-- Do loading actions. arg[2] is the VMF File name
	VMFCG.SaveLoad.LoadFile(activator,arg[2])
end

-- ############## Sets a VMF file to the deletion list (void) @aVoN
function VMFCG.menu.SetPublic(index,arg,activator)
	VMFCG.menu[activator].CopyGunUser[arg[1]]:Hide(activator);
	VMFCG.menu[activator].CopyGunUser[arg[1]]:HidePanel(activator);
	VMFCG.menu[activator].CopyGunMenu:Hide(activator);
	VMFCG.database.public:Load();
	local filename = arg[2];
	if(string.len(filename) > 15) then
		filename = string.sub(filename,1,15).."...";
	end
	if(arg[3]) then
		VMFCG.database.public:Set(string.lower(arg[2]),_PlayerInfo(activator,"name").." ".._PlayerInfo(activator,"networkid"));
		VMFCG.Hud.Message(activator,"               File '"..filename.."' set to public list!");
	else
		VMFCG.database.public:Unset(string.lower(arg[2]));
		VMFCG.Hud.Message(activator,"               File '"..filename.."' marked private!");
	end
	VMFCG.database.public:Save();
	VMFCG.menu.ReloadMenu(); -- Handle a reload
	VMFCG.menu.RebuildMenu(activator); -- Recalculate entrys...
	-- When the menu is empty, load the default menu
	if(VMFCG.menu[activator].CopyGunUser[arg[1]]) then
		VMFCG.menu[activator].CopyGunUser[arg[1]]:Show(activator);
		VMFCG.menu[activator].CopyGunUser[arg[1]]:AddCloseEvent(VMFCG.menu.ChangeMenu,index,arg,activator,true);
	else
		VMFCG.menu[activator].CopyGunMenu:Show(activator);
	end
end

-- ############## Sets a VMF file to the deletion list (void) @aVoN
function VMFCG.menu.DeleteFile(index,arg,activator)
	VMFCG.menu[activator].CopyGunUser[arg[1]]:Hide(activator);
	VMFCG.menu[activator].CopyGunUser[arg[1]]:HidePanel(activator);
	VMFCG.menu[activator].CopyGunMenu:Hide(activator);
	VMFCG.database.delete:Load() -- Reload the database
	local filename = arg[2];
	if(string.len(filename) > 15) then
		filename = string.sub(filename,1,15).."...";
	end
	if(arg[3]) then
		VMFCG.debug("VMFCG.menu.DeleteFile","File "..arg[2].." deleted by "..activator );
		-- Set to deletion list
		VMFCG.database.delete:Set(string.lower(arg[2]),_PlayerInfo(activator,"name").." "..string.upper(_PlayerInfo(activator,"networkid")));
		VMFCG.Hud.Message(activator,"               File '"..filename.."' set to deletion list!");
	else
		--Remove from deletion list
		VMFCG.debug("VMFCG.menu.DeleteFile","File "..arg[2].." restored by "..activator );
		VMFCG.database.delete:Unset(string.lower(arg[2]));
		VMFCG.Hud.Message(activator,"                      Restored file '"..filename.."'!");
	end
	VMFCG.database.delete:Save();
	VMFCG.menu.ReloadMenu(); -- Handle a reload
	VMFCG.menu.RebuildMenu(activator); -- Recalculate entrys...
	-- When the menu is empty, load the default menu
	if(VMFCG.menu[activator].CopyGunUser[arg[1]]) then
		VMFCG.menu[activator].CopyGunUser[arg[1]]:Show(activator);
		VMFCG.menu[activator].CopyGunUser[arg[1]]:AddCloseEvent(VMFCG.menu.ChangeMenu,index,arg,activator,true);
	else
		VMFCG.menu[activator].CopyGunMenu:Show(activator);
	end
end

-- ############## Clears the deletionlist (void) @aVoN
function VMFCG.menu.ClearDeletionList(index,arg,activator)
	VMFCG.debug("VMFCG.menu.ClearDeletionList","Deletionlist cleared by "..activator );
	VMFCG.menu[activator].CopyGunUser[arg[1]]:Hide(activator);
	VMFCG.menu[activator].CopyGunUser[arg[1]]:HidePanel(activator);
	VMFCG.menu[activator].CopyGunMenu:Hide(activator);
	if(arg[2]) then
		local files = _file.Find(VMFCG.config.save_folder.."/patterns/*.vmf") -- Get files
		for k,v in files do
			if(VMFCG.menu.IsDeleted(string.sub(v,0,-5))) then
				_file.Delete(VMFCG.config.save_folder.."/patterns/"..v);
			end
		end
		local deleted = VMFCG.database.delete:GetTable();
		for k,v in deleted do
			VMFCG.database.delete:Unset(k);
		end
		VMFCG.Hud.Message(activator,"            Cleared deletion list and removed patterns permanently!");
		VMFCG.database.delete:Save();
	end
	-- When the menu is empty, load the default menu
	VMFCG.menu.ReloadMenu(); -- Handle a reload
	VMFCG.menu.RebuildMenu(activator); -- Recalculate entrys...
	if(VMFCG.menu[activator].CopyGunUser[arg[1]]) then
		VMFCG.menu[activator].CopyGunUser[arg[1]]:Show(activator);
		VMFCG.menu[activator].CopyGunUser[arg[1]]:AddCloseEvent(VMFCG.menu.ChangeMenu,index,arg,activator,true);
	else
		VMFCG.menu[activator].CopyGunMenu:Show(activator);
	end
end

-- ############## Sets a VMF to get loaded absolutely or relativly (void) @aVoN
function VMFCG.menu.SetAbsolute(index,arg,activator)
	if(VMFCG.core.validVMFLoader()) then
		local entities = VMFCG.SaveLoad.LoadGetEntities(arg[2]);
		local meta_key,meta_data = VMFCG.SaveLoad.FindEntitity(entities,"vmf_global");
		if(arg[3] and not(meta_key and meta_data)) then
			VMFCG.Hud.Message(activator,"                           This file can't get marked absolute!");
			return;
		end
		local map = VMFLoader:FindKV(meta_data.keyvalues,"map");
		local origin = VMFLoader:FindKV(meta_data.keyvalues,"origin");
		if(arg[3] and not(map and origin)) then
			VMFCG.Hud.Message(activator,"                           This file can't get marked absolute!");
			return;
		end
		VMFCG.menu[activator].CopyGunUser[arg[1]]:Hide(activator);
		VMFCG.menu[activator].CopyGunUser[arg[1]]:HidePanel(activator);
		VMFCG.menu[activator].CopyGunMenu:Hide(activator);
		VMFCG.database.absolute:Load() -- Reload the database
		local filename = arg[2];
		if(string.len(filename) > 15) then
			filename = string.sub(filename,1,15).."...";
		end
		if(arg[3]) then
			VMFCG.debug("VMFCG.menu.SetAbsolute","File "..arg[2].." marked absolute by "..activator );
			VMFCG.database.absolute:Set(string.lower(arg[2]),map.value);
			VMFCG.Hud.Message(activator,"                      File '"..filename.."' will load absolutely now!");
		else
			VMFCG.debug("VMFCG.menu.SetAbsolute","File "..arg[2].." marked relativ by "..activator );
			VMFCG.database.absolute:Unset(string.lower(arg[2]));
			VMFCG.Hud.Message(activator,"                      File '"..filename.."' will load relativly now!");
		end
		VMFCG.database.absolute:Save();
		VMFCG.menu.ReloadMenu(); -- Handle a reload
		VMFCG.menu.RebuildMenu(activator); -- Recalculate entrys...
		-- When the menu is empty, load the default menu
		if(VMFCG.menu[activator].CopyGunUser[arg[1]]) then
			VMFCG.menu[activator].CopyGunUser[arg[1]]:Show(activator);
			VMFCG.menu[activator].CopyGunUser[arg[1]]:AddCloseEvent(VMFCG.menu.ChangeMenu,index,arg,activator,true);
		else
			VMFCG.menu[activator].CopyGunMenu:Show(activator);
		end
	end
end

-- ############## Loads a VMF File from VMFLoader (void) @aVoN
function VMFCG.menu.VMFLoaderLoad(index,arg,activator)
	local spawn_timout = tonumber(VMFCG.RightsManager.restrictions(activator,VMFCG.defines.RESTRICTION_SPAWNTIMEOUT)) or 0;
	local last_spawn = VMFCG.menu[activator].LastVMFLoaderSpawn or 0;
	if(last_spawn + spawn_timout <= _CurTime()) then
		local dont_close_menu = VMFCG.RightsManager.hasAccess(activator,VMFCG.defines.ALLOW_KEEP_VMFLOADER_MENU_OPEN);
		VMFCG.menu[activator].LastVMFLoaderSpawn = _CurTime(); -- Reset lastspawn time!
		VMFLoader.LoadVMF(activator,arg[1]..".vmf");
		VMFCG.debug("VMFCG.menu.VMFLoaderLoad","File "..arg[1].." (VMFLoader) loaded by "..activator );
		if(not dont_close_menu) then
			VMFCG.menu[activator].CopyGunUser["vmf_loader"]:Hide(activator);
			VMFCG.menu[activator].CopyGunUser["vmf_loader"]:HidePanel(activator);
			VMFCG.menu[activator].CopyGunMenu:Hide(activator);
		end
	else
		VMFCG.Hud.Message(userid,"                You have to wait "..tostring(spawn_timout).." seconds for spawning a new copy");
		return;
	end
end

--- #############################################
-- ############### Menu loading ######################
-- #############################################

-- ############## Returns all files and folders of VMFLoader (table) @aVoN
function VMFCG.menu.GetVMFLoaderFilesSorted()
	if(not VMFCG.core.validVMFLoader()) then return end;
	if(VMFCG.menu.VMFLoaderList) then
		return VMFCG.menu.VMFLoaderList;
	end
	local vmf_loader = {};
	if(VMFCG.core.validVMFLoader()) then
		-- ############## Get all VMFLoader menu entries
		local folders = Folder:GetFolders();
		local subfolders = {};
		-- Get subfolders
		for _,v in folders do
			local files = _file.Find(v.path.."/*");
			for _,file in files do
				if(file ~= "." and file ~= "..") then
					local subfolder = v.path.."/"..file;
					if(_file.IsDir(subfolder)) then
						local add = true;
						for _,folder in folders do
							if(folder.path == subfolder) then
								add = false;
							end
						end
						if(add) then
							table.insert(subfolders,{access=v.access or "",category=file,path=subfolder});
						end
					end
				end
			end
		end
		folders = VMFCG.merge(folders,subfolders);
		table.sort(folders,function (a,b) return string.lower(a.category) < string.lower(b.category) end); -- Sort the List
		for _,v in folders do
			local files = _file.Find(v.path.."/*.vmf");
			local parsed_folder = {};
			if(table.getn(files) > 0) then
				table.sort(files,function (a,b) return string.lower(a) < string.lower(b) end); -- Sort the files
				for k,v in files do
					files[k] = string.sub(v,1,-5); -- Remove the .vmf extension
				end
				table.insert(vmf_loader,{access=v.access or "",category=v.category,path=v.path,patterns=files});
			end
		end
	end
	VMFCG.menu.VMFLoaderList = vmf_loader;
	return vmf_loader;
end

-- ############# Set current accesss (void) @aVoN
function VMFCG.menu.SetCurrentAccess(userid)
	local a = "abcdefghijklmnopqrstuvwxyz";
	for i=1,string.len(a) do
		local current_access = VMFCG.RightsManager.hasAccess(userid,string.sub(a,i,i));
		VMFCG.menu[userid].LastAccess[i] = current_access;
	end
end

-- ############## Checks, if the access of a person changed (boolean) @aVoN
function VMFCG.menu.AccessChanged(userid)
	local a = "abcdefghijklmnopqrstuvwxyz";
	for i=1,string.len(a) do
		local current_access = VMFCG.RightsManager.hasAccess(userid,string.sub(a,i,i));
		if(VMFCG.menu[userid].LastAccess[i] ~= current_access) then
			return true;
		end
	end
	return false;
end

-- ############## Generates and sorts the files for the usage of the menu (table,table,table,table) @aVoN
function VMFCG.menu.GetFilesSorted()
	if(VMFCG.menu.Lists) then
		-- Always return a copy, or changes may affect even this global table
		return unpack(VMFCG.copy(VMFCG.menu.Lists));
	end
	-- ############## Update database
	VMFCG.menu.UpdatePatterns();
	VMFCG.menu.UpdateUsers();
	VMFCG.menu.UpdateDeleted();
	VMFCG.menu.UpdatePublic();
	VMFCG.menu.UpdateAbsolute();
	-- ############## Fetch files
	local files = _file.Find(VMFCG.config.save_folder.."/patterns/*.vmf") -- Get files
	-- ############## Sort them
	table.sort(files,function (a,b) return string.lower(a) < string.lower(b) end);
	local saves = {};
	local public = {};
	local deleted = {};
	-- ############## Allocate all saves to a steamid for sorting them later
	for _,v in files do
		local file = string.sub(v,1,-5);
		local id = VMFCG.menu.GetUserByPattern(file);
		if(VMFCG.menu.IsDeleted(file)) then
			table.insert(deleted,{name=file,steamid=id}); -- Pattern got deleted - Set to deletion list
		else
			local is_public = VMFCG.menu.IsPublic(file);
			if(is_public) then
				table.insert(public,{name=file,steamid=id}); -- File is flagged public
			end
			if(id) then
				saves[id] = saves[id] or {}; -- Insert VMF to the list
				table.insert(saves[id],{file=file,public=is_public});
			end
		end
	end
	-- ############## Generate userlists in a new table
	local user_files = {};
	for k,v in saves do
		local username = VMFCG.menu.GetUserName(k);
		if(username) then
			table.insert(user_files,{user=username,steamid=k,patterns=v});
		end
	end
	-- ############## Sort lists by usernames
	table.sort(user_files,function (a,b) return string.lower(a.user) < string.lower(b.user) end); -- Sort the List
	-- ############## Change spawnorder for special lists, handled in config.ini
	if(type(VMFCG.config.menu_preferred) == "table") then
		local preferred = {};
		for _,steamid in VMFCG.config.menu_preferred do
			for k,v in user_files do
				if(v.steamid == steamid) then
					table.insert(preferred,v);
					user_files[k] = nil;
					break;
				end
			end
		end
		if(table.getn(preferred) > 0) then
			-- And merge both tables. Table one will be always before table two. Only works with numeric table indices
			user_files = VMFCG.merge(preferred,user_files);
		end
	end
	-- ############## Save the list, so anyone can use them
	local vmf_loader = VMFCG.menu.GetVMFLoaderFilesSorted();
	VMFCG.menu.Lists = VMFCG.copy({user_files,public,deleted,vmf_loader}); -- Save as copy
	return user_files,public,deleted,vmf_loader;
end

-- ############## Generates clientmenu (void) @aVoN
function VMFCG.menu.GenerateClientMenu(userid) -- Generates the CopyGun Menu
	local steamid = string.lower(_PlayerInfo(userid,"networkid"));
	-- ############## User Right restrictions
	local can_load_own = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_LOAD_OWN);
	local can_load_all = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_LOAD_ALL);
	local can_delete_own = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_DELETE_OWN);
	local can_delete_all = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_DELETE_ALL);
	local can_public_own = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_MARK_PUBLIC_OWN);
	local can_public_all = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_MARK_PUBLIC_ALL);
	local can_clear_deletion_list = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_CLEAR_DELETION_LIST);
	local can_mark_absolute_own = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_MARK_ABSOLUTE_OWN);
	local can_mark_absolute_all = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_MARK_ABSOLUTE_ALL);
	
	VMFCG.menu.SetCurrentAccess(userid); -- Save access snapshot
	
	-- Has VMFLoader?
	local has_vmf_loader = VMFCG.core.validVMFLoader();
	local color_addon = false;
	if(rawget(ULib.XME,"OptionSetColor")) then
		color_addon = true;
	end
	local public_color = {170,255,100,255}
	local highlight_color = {100,208,255,255}
	local deletion_color = {238,94,68,255}
	
	-- ############## Get all sorted files etc
	local user_files,public,deleted,vmf_loader = VMFCG.menu.GetFilesSorted();
	
	if(table.getn(user_files) == 0 and (table.getn(vmf_loader) == 0 or not has_vmf_loader) and table.getn(deleted) == 0 and table.getn(public) ==0) then
		VMFCG.menu[userid].CopyGunMenu:NewOption("<EMPTY>",0);
		return;
	end
	local private = {};
	-- ############## Search the user_files for a private list and allocate it.
	for k,v in user_files do
		if(v.steamid == steamid) then
			v.user = _PlayerInfo(userid,"name");
			private = {VMFCG.copy(v)};
			user_files[k] = nil;
			break;
		end
	end
	-- ############## Add private list to the very beginning of patternlist
	if(table.getn(private) > 0) then
		-- Add private list
		user_files = VMFCG.merge(private,user_files);
	end
	-- #############################################
	-- ############### Public List #######################
	-- #############################################
	
	-- ############## Add public list, when it has files in it
	if(table.getn(public) > 0) then
		VMFCG.menu[userid].CopyGunUser["public_list"] = ULib.XME:new("Public List ("..table.getn(public)..")");
		for _,v in public do
			local topic = v.name;
			local absolute = VMFCG.menu.IsAbsolute(v.name);
			if(absolute) then
				topic = "[ABS] "..topic;
			end
			if(string.len(topic) > 25) then
				topic = string.sub(topic,1,22).."...";
			end
			local menu = VMFCG.menu[userid].CopyGunUser["public_list"]:NewOption(topic,0);
			if(color_addon) then
				if(absolute) then
					-- Call the option coloraddon by aVoN for the XME menu engine
					VMFCG.menu[userid].CopyGunUser["public_list"]:OptionSetColor(menu,unpack(public_color));
				end
				if(steamid == v.steamid) then
					-- Call the option coloraddon by aVoN for the XME menu engine
					VMFCG.menu[userid].CopyGunUser["public_list"]:OptionSetColor(menu,unpack(highlight_color));
				end
			end
			local panel = VMFCG.menu[userid].CopyGunUser["public_list"]:OptionAddPanel(menu); -- Load/Save Panel
			VMFCG.menu[userid].CopyGunUser["public_list"]:PanelAddOption(panel,"Load and close menu...", VMFCG.menu.LoadFile,{"public_list",v.name,true});
			VMFCG.menu[userid].CopyGunUser["public_list"]:PanelAddOption(panel,"Load...", VMFCG.menu.LoadFile,{"public_list",v.name});
			-- ############## Handle panel with marking public
			if(((can_public_own and steamid == v.steamid) or can_public_all) and v.steamid and VMFCG.menu.GetUserName(v.steamid)) then
					VMFCG.menu[userid].CopyGunUser["public_list"]:PanelAddOption(panel,"Mark private...", VMFCG.menu.SetPublic,{"public_list",v.name,false});
			end
			-- ############## Handle panel with marking absolute/relative
			if(has_vmf_loader) then
				if(can_mark_absolute_all or (can_mark_absolute_own and v.steamid == steamid)) then
					if(absolute) then
						VMFCG.menu[userid].CopyGunUser["public_list"]:PanelAddOption(panel,"Mark relative'...", VMFCG.menu.SetAbsolute,{"public_list",v.name,false});
					else
						VMFCG.menu[userid].CopyGunUser["public_list"]:PanelAddOption(panel,"Mark absolute'...", VMFCG.menu.SetAbsolute,{"public_list",v.name,true});
					end
				end
			end
			-- ############## Handle panel with Removing
			if((can_delete_own and steamid == v.steamid) or can_delete_all) then
				VMFCG.menu[userid].CopyGunUser["public_list"]:PanelAddOption(panel,"Remove...", VMFCG.menu.DeleteFile,{"public_list",v.name,true});
			end
		end
		local p_option = VMFCG.menu[userid].CopyGunMenu:NewOption("Public List ("..table.getn(public)..")",0);
		if(color_addon) then
			-- ############## Call the option coloraddon by aVoN for the XME menu engine
			VMFCG.menu[userid].CopyGunMenu:OptionSetColor(p_option,unpack(public_color));
		end
		VMFCG.menu[userid].CopyGunMenu:OptionAddCallback(p_option,VMFCG.menu.ChangeMenu,{"public_list"});
	end
	
	-- #############################################
	-- ############### Deletion List ######################
	-- #############################################
	
	if(can_delete_all or can_delete_own) then
		if(table.getn(deleted) > 0) then
			VMFCG.menu[userid].CopyGunUser["deletion_list"] = ULib.XME:new("Deletion List ("..table.getn(deleted)..")");
			if(can_clear_deletion_list) then
				local menu = VMFCG.menu[userid].CopyGunUser["deletion_list"]:NewOption("Clear deletion list",0);
				if(color_addon) then
					VMFCG.menu[userid].CopyGunUser["deletion_list"]:OptionSetColor(menu,unpack(deletion_color));
				end
				local panel = VMFCG.menu[userid].CopyGunUser["deletion_list"]:OptionAddPanel(menu);
				VMFCG.menu[userid].CopyGunUser["deletion_list"]:PanelAddOption(panel,"Yes...", VMFCG.menu.ClearDeletionList,{"deletion_list",true});
				VMFCG.menu[userid].CopyGunUser["deletion_list"]:PanelAddOption(panel,"No...", VMFCG.menu.ClearDeletionList,{"deletion_list",false});
			end
			for _,v in deleted do
				local topic = v.name;
				if(string.len(topic) > 25) then
					topic = string.sub(topic,1,22).."...";
				end
				local menu = VMFCG.menu[userid].CopyGunUser["deletion_list"]:NewOption(topic,0);
				if(color_addon) then
					if(v.steamid == steamid) then
						-- ############## Call the option coloraddon by aVoN for the XME menu engine
						VMFCG.menu[userid].CopyGunUser["deletion_list"]:OptionSetColor(menu,unpack(highlight_color));
					end
				end
				local panel = VMFCG.menu[userid].CopyGunUser["deletion_list"]:OptionAddPanel(menu); -- Load/Save Panel
				if(can_load_all or (can_load_own and v.steamid == steamid)) then
					VMFCG.menu[userid].CopyGunUser["deletion_list"]:PanelAddOption(panel,"Load and close menu...", VMFCG.menu.LoadFile,{"deletion_list",v.name,true});
					VMFCG.menu[userid].CopyGunUser["deletion_list"]:PanelAddOption(panel,"Load...", VMFCG.menu.LoadFile,{"deletion_list",v.name});
				end
				-- ############## Handle panel with Restoring
				if(can_delete_all or (can_delete_own and v.steamid == steamid)) then
					VMFCG.menu[userid].CopyGunUser["deletion_list"]:PanelAddOption(panel,"Restore file...", VMFCG.menu.DeleteFile,{"deletion_list",v.name,false});
				end
			end
			local option = VMFCG.menu[userid].CopyGunMenu:NewOption("Deletion List ("..table.getn(deleted)..")",0);
			if(color_addon) then
				-- Call the option coloraddon by aVoN for the XME menu engine
				VMFCG.menu[userid].CopyGunMenu:OptionSetColor(option,unpack(deletion_color));
			end
			VMFCG.menu[userid].CopyGunMenu:OptionAddCallback(option,VMFCG.menu.ChangeMenu,{"deletion_list"});
		end
	end
	
	-- #############################################
	-- ############### VMFLoader Contraptions ###############
	-- #############################################
	
	if(has_vmf_loader and table.getn(vmf_loader) > 0) then
		VMFCG.menu[userid].CopyGunUser["vmf_loader"] = ULib.XME:new("VMFLoader");
		for _,category in vmf_loader do
			if(category.access == "" or Admin:CheckAccess(userid,category.access)) then
				local topic = category.category;
				if(string.len(topic) > 25) then
					topic = string.sub(topic,1,22).."...";
				end
				local menu = VMFCG.menu[userid].CopyGunUser["vmf_loader"]:NewOption(topic,0);
				local panel = VMFCG.menu[userid].CopyGunUser["vmf_loader"]:OptionAddPanel(menu);
				for _,pattern in category.patterns do
					local topic = pattern;
					if(string.len(topic) > 25) then
						topic = string.sub(topic,1,22).."...";
					end
					VMFCG.menu[userid].CopyGunUser["vmf_loader"]:PanelAddOption(panel,topic,VMFCG.menu.VMFLoaderLoad,{category.path.."/"..pattern});
				end
				if(color_addon) then
					if(category.access ~= "") then
						VMFCG.menu[userid].CopyGunUser["vmf_loader"]:OptionSetColor(menu,unpack(highlight_color));
					end
				end
			end
		end
		local option = VMFCG.menu[userid].CopyGunMenu:NewOption("VMFLoader ("..table.getn(vmf_loader)..")",0);
		if(color_addon) then
			-- Call the option coloraddon by aVoN for the XME menu engine
			VMFCG.menu[userid].CopyGunMenu:OptionSetColor(option,unpack(highlight_color));
		end
		VMFCG.menu[userid].CopyGunMenu:OptionAddCallback(option,VMFCG.menu.ChangeMenu,{"vmf_loader"});
	end
	
	-- #############################################
	-- ############### Pattern Lists ######################
	-- #############################################
	for index,v in user_files do
		if(table.getn(v.patterns) > 0) then
			if(can_load_all or (can_load_own and v.steamid == steamid)) then
				-- ############## Shorten names
				local user_name = v.user;
				local user_name_topic = v.user;
				if(string.len(user_name_topic) > 17) then
					user_name_topic = string.sub(user_name_topic,1,15).."...";
				end
				if(string.len(user_name) > 25) then
					user_name = string.sub(user_name,1,22).."...";
				end
				-- ############## Add topic
				VMFCG.menu[userid].CopyGunUser[v.steamid] = ULib.XME:new(user_name_topic.."'s Patterns");
				for _,pattern in v.patterns do
					local Ispublic = pattern.public;
					local absolute = VMFCG.menu.IsAbsolute(pattern.file);
					local topic = pattern.file;
					if(Ispublic) then
						topic = "[PUB] "..topic;
					end
					if(absolute) then
						-- Add a space or not?
						local add_space = " ";
						if(Ispublic) then
							add_space = "";
						end
						topic = "[ABS]"..add_space..topic;
					end
					if(string.len(topic) > 25) then
						topic = string.sub(topic,1,22).."...";
					end
					-- ############## Generate Pattern entry
					local menu = VMFCG.menu[userid].CopyGunUser[v.steamid]:NewOption(topic,0);
					local panel = VMFCG.menu[userid].CopyGunUser[v.steamid]:OptionAddPanel(menu); -- Load/Save Panel
					VMFCG.menu[userid].CopyGunUser[v.steamid]:PanelAddOption(panel,"Load and close menu...", VMFCG.menu.LoadFile,{v.steamid,pattern.file,true});
					VMFCG.menu[userid].CopyGunUser[v.steamid]:PanelAddOption(panel,"Load...", VMFCG.menu.LoadFile,{v.steamid,pattern.file});
					if(color_addon) then
						if(absolute or Ispublic) then
							-- Call the option coloraddon by aVoN for the XME menu engine
							VMFCG.menu[userid].CopyGunUser[v.steamid]:OptionSetColor(menu,unpack(public_color));
						end
					end
					-- ############## Handle panel with Public/Private
					if(can_public_all or (can_public_own and v.steamid == steamid)) then
						if(Ispublic) then
							VMFCG.menu[userid].CopyGunUser[v.steamid]:PanelAddOption(panel,"Mark private...", VMFCG.menu.SetPublic,{v.steamid,pattern.file,false});
						else
							VMFCG.menu[userid].CopyGunUser[v.steamid]:PanelAddOption(panel,"Mark public...", VMFCG.menu.SetPublic,{v.steamid,pattern.file,true});
						end
					end
					-- ############## Handle panel with Absolute/Relative
					if(has_vmf_loader) then
						if(can_mark_absolute_all or (can_mark_absolute_own and v.steamid == steamid)) then
							if(absolute) then
								VMFCG.menu[userid].CopyGunUser[v.steamid]:PanelAddOption(panel,"Mark relative...", VMFCG.menu.SetAbsolute,{v.steamid,pattern.file,false});
							else
								VMFCG.menu[userid].CopyGunUser[v.steamid]:PanelAddOption(panel,"Mark absolute...", VMFCG.menu.SetAbsolute,{v.steamid,pattern.file,true});
							end
						end
					end
					-- ############## Handle panel with Removing
					if(can_delete_all or (can_delete_own and v.steamid == steamid)) then
						VMFCG.menu[userid].CopyGunUser[v.steamid]:PanelAddOption(panel,"Remove...", VMFCG.menu.DeleteFile,{v.steamid,pattern.file,true});
					end
				end
				-- ############## Add the option
				local option = VMFCG.menu[userid].CopyGunMenu:NewOption(user_name.." ("..table.getn(v.patterns)..")",0);
				-- ############## Colorize it
				if(color_addon) then
					local highlight = 0;
					if(type(VMFCG.config.menu_preferred) == "table") then
						highlight = table.getn(VMFCG.config.menu_preferred);
					end
					if(table.getn(private) > 0) then
						highlight = highlight+1;
					end
					if(index <= highlight) then
						VMFCG.menu[userid].CopyGunMenu:OptionSetColor(option,unpack(highlight_color));
					end
				end
				VMFCG.menu[userid].CopyGunMenu:OptionAddCallback(option,VMFCG.menu.ChangeMenu,{v.steamid});
			end
		end
	end
	VMFCG.debug("VMFCG.menu.GenerateClientMenu","Creating Client Menu" );
end

-- ############## Needs to get overwritten right now, or we get the XME scroll bug - need to ask h2noob for fixing this (void) @aVoN
function VMFCG.menu.RebuildMenu(userid)
	-- Because Ulib always overwrites it.. damn fuck!
	if(not ULib) then
		_OpenScript("VMFCopyGun/extensions/xm_base.lua");
	end
	if(ULib) then
		if(not ULib.XME) then
			_OpenScript("VMFCopyGun/extensions/xm_base.lua");
		end
	end
	if(VMFCG.menu[userid].UpdateMenu or VMFCG.menu.AccessChanged(userid)) then
		VMFCG.menu[userid] = nil;
		VMFCG.menu[userid] = {};
		VMFCG.menu[userid].LastAccess = {};
		VMFCG.menu[userid].CopyGunUser = {} -- Needs to be global
		VMFCG.menu[userid].CopyGunMenu = ULib.XME:new("VMFCopyGun Patterns"); -- Global too!
		VMFCG.menu.GenerateClientMenu(userid); -- Generate
	end
end

-- ############## Sends the menu (void) @aVoN
function VMFCG.menu.Send(userid,arg)
	VMFCG.menu.RebuildMenu(userid);
	if(arg == "all") then
		VMFCG.menu[userid].CopyGunMenu:Show(userid); -- Send complete menu
		return;
	end
	if(arg == "vmf_loader") then
		if(VMFCG.menu[userid].CopyGunUser["vmf_loader"]) then
			VMFCG.menu[userid].CopyGunUser["vmf_loader"]:AddCloseEvent(function() end); -- Clear any previous closevents
			VMFCG.menu[userid].CopyGunUser["vmf_loader"]:Show(userid); -- Send personal menu
		end
		return;
	end
	local steamid = string.lower(_PlayerInfo(userid,"networkid"));
	if(VMFCG.menu[userid].CopyGunUser[steamid]) then
		VMFCG.menu[userid].CopyGunUser[steamid]:AddCloseEvent(function() end); -- Clear any previous closevents
		VMFCG.menu[userid].CopyGunUser[steamid]:Show(userid); -- Send personal menu
	end
end

-- ############## Generates the QMenu in the spawnlist (void) @aVoN
function VMFCG.menu.eventPlayerSpawn(userid)
	if(not VMFCG.menu[userid].GotQMenu) then
		VMFCG.menu[userid].GotQMenu = true;
		if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_QMENU)) then
			local lines = {};
			_spawnmenu.RemoveCategory(userid,VMFCG.config.menu_topic); -- Remove old category if existant
			table.insert(lines,{"@VMF CopyGun"});
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SELECT)) then
				table.insert(lines,{"+Selector","vmfcg_swep 1"});
			end
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SPHERESELECT)) then
				table.insert(lines,{"+Sphere Selector","vmfcg_swep 2"});
			end
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_QUADSELECT)) then
				table.insert(lines,{"+Quad Selector","vmfcg_swep 3"});
			end
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SMARTSELECT)) then
				table.insert(lines,{"+Smart Selector","vmfcg_swep 4"});
			end
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_VMFREMOVER)) then
				table.insert(lines,{"+VMFRemover","vmfcg_swep 5"});
			end
			if(
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SELECT) or 
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SPHERESELECT) or 
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_QUADSELECT) or 
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SMARTSELECT) or
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_VMFREMOVER)
			) then
				table.insert(lines,{"@"});
				table.insert(lines,{"+All Selectors","vmfcg_swep 6"});
			end
			table.insert(lines,{"@ "});
			table.insert(lines,{"+Patterns","vmfcg_menu all"});
			table.insert(lines,{"+My Patterns","vmfcg_menu"});
			table.insert(lines,{"+VMFLoader","vmfcg_menu vmf_loader"});
			table.insert(lines,{"@  "});
			table.insert(lines,{"@All commands below are for"});
			table.insert(lines,{"@console. For using them in"});
			table.insert(lines,{"@chat, add a '!' infront of them"});
			table.insert(lines,{"@   "});
			table.insert(lines,{"@Commands:"});
			if(
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SELECT) or 
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SPHERESELECT) or 
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_QUADSELECT) or 
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SMARTSELECT) or
				VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_VMFREMOVER)
			) then
				table.insert(lines,{"@ vmfcg_swep <1-6>"});
				table.insert(lines,{"@    Spawns the Select Tools"});
			end
			table.insert(lines,{"@ vmfcg_menu"});
			table.insert(lines,{"@    Opens Pattern Menu"});
			table.insert(lines,{"@ vmfcg_vmfmenu"});
			table.insert(lines,{"@    Opens the VMFLoader menu"});
			table.insert(lines,{"@ vmfcg_mymenu"});
			table.insert(lines,{"@    Opens private Pattern Menu"});
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_LOAD_OWN) or VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_LOAD_ALL)) then
				table.insert(lines,{"@ vmfcg_load <name>"});
				table.insert(lines,{"@    Loads a Pattern"});
			end
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SAVE)) then
				table.insert(lines,{"@ vmfcg_save <name>"});
				table.insert(lines,{"@    Saves a Pattern"});
				if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_MARK_ABSOLUTE_OWN) or VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_MARK_ABSOLUTE_ALL)) then
					table.insert(lines,{"@ vmfcg_asave <name>"});
					table.insert(lines,{"@    Saves a Pattern absolutely"});
				end
			end
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_XSAVE) and VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SAVE)) then
				table.insert(lines,{"@ vmfcg_xsave <name>"});
				table.insert(lines,{"@    Saves all in the map"});
			end
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_DELETE_OWN) or VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_DELETE_ALL)) then
				table.insert(lines,{"@ vmfcg_delete <name>"});
				table.insert(lines,{"@    Deletes a pattern"});
				table.insert(lines,{"@ vmfcg_restore <name>"});
				table.insert(lines,{"@    Restores a pattern"});
			end
			table.insert(lines,{"@ vmfcg_rotate <0-360>"});
			table.insert(lines,{"@    Rotates a Pattern"});
			table.insert(lines,{"@ vmfcg_height <number>"});
			table.insert(lines,{"@    Changes spawnheight"});
			table.insert(lines,{"@There are short aliases for chat"});
			table.insert(lines,{"@commands: !load,!save,!menu"});
			table.insert(lines,{"@!mymenu,!rotate,!height!,delete"});
			table.insert(lines,{"@!xsave,!asave,!vmfmenu,!restore"});
			table.insert(lines,{"@    "});
			table.insert(lines,{"@VMFCopyGun v"..VMFCG.version});
			table.insert(lines,{"@(c) 2006 by aVoN"});
			for _,v in lines do
				_spawnmenu.AddItem(userid,VMFCG.config.menu_topic,v[1],v[2]);
			end
		end
	end
	if(VMFCG.config.replace_original_vmfloader_menu) then
		_spawnmenu.RemoveCategory(userid,VMFCG.config.vmfloader_menu_topic); -- Remove old category if existant
		_spawnmenu.AddItem(userid,VMFCG.config.vmfloader_menu_topic,"@VMFLoader","");
		_spawnmenu.AddItem(userid,VMFCG.config.vmfloader_menu_topic,"+VMFLoader","vmfcg_menu vmf_loader");
	end
end

-- ############## Disables the VMFLoader standard menu (void) @aVoN
function VMFCG.menu.DisableOriginalVMFLoaderMenu()
	if(VMFCG.config.replace_original_vmfloader_menu) then
		if(VMFLoader) then
			VMFLoader.UseSpawnMenu = false;
		end
	end
end

-- #############################################
-- ###############CONCOMMANDS ###################
-- #############################################

VMFCG.Commands.Add("vmfcg_menu",VMFCG.menu.Send,"!vmfcg_mymenu","!mymenu");
VMFCG.Commands.Add("vmfcg_menu_all",function(i) VMFCG.menu.Send(i,"all") end,"!vmfcg_menu","!menu");
VMFCG.Commands.Add("vmfcg_vmfmenu",function(i) VMFCG.menu.Send(i,"vmf_loader") end,"!vmfcg_vmfmenu","!vmfmenu");

-- #############################################
-- ############### Init ###########################
-- #############################################

VMFCG.menu.DisableOriginalVMFLoaderMenu();
if(_CurTime() < 120) then
	VMFCG.menu.GetVMFLoaderFilesSorted(); -- Load the patterns on serverstart
end
VMFCG.AddTimerOnce("VMFCG.menu.DisableOriginalVMFLoaderMenu",1,1,VMFCG.menu.DisableOriginalVMFLoaderMenu);

VMFCG.HookOnce("eventPlayerSpawn",VMFCG.menu.eventPlayerSpawn,"VMFCG.menu.eventPlayerSpawn");
VMFCG.HookOnce("eventPlayerInitialSpawn",function(i) VMFCG.menu[i].GotQMenu = false; VMFCG.menu[i].UpdateMenu = true; end,"VMFCG.menu.eventPlayerInitialSpawn");