--[[

	#############################################
	
		VMF CopyGun - Rights Management
		
	#############################################
	
]]--

VMFCG.RightsManager = {};
VMFCG.RightsManager.accessfunction = {};
VMFCG.RightsManager.groups = VMFCG.INIParser:new("lua/VMFCopyGun/config/groups.ini");
VMFCG.RightsManager.users = VMFCG.INIParser:new("lua/VMFCopyGun/config/users.ini");

-- ############## Checks players for the neccessary access (boolean) @aVoN
function VMFCG.RightsManager.hasAccess(userid,access)
	-- Always return true on singleplayer games or for a serverhoster
	if(_MaxPlayers() == 1 or (not _IsDedicatedServer() and userid == 1)) then
		VMFCG.debug("VMFCG.RightsManager.hasAccess","User "..userid.." got single-player access" );
		return true;
	end
	local steamid = string.lower(_PlayerInfo(userid,"networkid"));
	local flag = "";
	for _,v in VMFCG.RightsManager.users["user"] do
		if(string.lower(v.steamid) == steamid) then
			if(v.access) then
				if(string.find(v.access,access)) then
					VMFCG.debug("VMFCG.RightsManager.hasAccess","User "..userid.." got access by user-access");
					return true;
				end
			end
			flag = v.flag;
			break;
		end
	end
	VMFCG.RightsManager.accessfunction[userid] = false;
	for _,v in VMFCG.RightsManager.groups["group"] do
		if(string.find(v.access,access)) then -- This group has the needed access
			if(v.accessfunction) then -- An access function is declared
				local accessfunction = string.gsub(v.accessfunction,"userid",userid); -- Add the current userid to this accessfunction
				_RunString("VMFCG.RightsManager.accessfunction["..userid.."] = "..accessfunction); -- Run it and the returnvalue to VMFCG.RightsManager.accessfunction[userid]
				if(VMFCG.RightsManager.accessfunction[userid]) then -- User got access from this function - So give him access!
					VMFCG.debug("VMFCG.RightsManager.hasAccess","User "..userid.." got access by accessfunction("..v.accessfunction..")");
					return true;
				end
				VMFCG.RightsManager.accessfunction[userid] = nil;
			end
			if(flag == v.flag) then
				VMFCG.debug("VMFCG.RightsManager.hasAccess","User "..userid.." got access by group-flag ("..v.flag..") for group '"..v.name.."'" );
				return true;
			end
			if(not v.flag) then
				VMFCG.debug("VMFCG.RightsManager.hasAccess","User "..userid.." got general-access for group '"..v.name.."'" );
				-- "not v.flag" means, its the general group with no flags = general access!
				return true;
			end
		end
	end
	return false; -- We haven't found the user - So don't give him access!
end

-- ############## Checks, if a player has any restrictions like spawntimeout etc (string) @aVoN
function VMFCG.RightsManager.restrictions(userid,restriction)
	if(_MaxPlayers() == 1 or (not _IsDedicatedServer() and userid == 1)) then
		VMFCG.debug("VMFCG.RightsManager.restrictions","User "..userid.." got no restrictions because of single-player game" );
		return nil;
	end
	local steamid = string.lower(_PlayerInfo(userid,"networkid"));
	local flag = "";
	for _,v in VMFCG.RightsManager.users["user"] do
		if(string.lower(v.steamid) == steamid) then
			if(v[restriction]) then
				VMFCG.debug("VMFCG.RightsManager.restrictions","Restricted '"..restriction.."' for user "..userid.." because user-restriction");
				return v[restriction];
			end
			flag = v.flag;
			break;
		end
	end
	local general_restriction;
	for _,v in VMFCG.RightsManager.groups["group"] do
		if(v.flag == flag) then
			VMFCG.debug("VMFCG.RightsManager.restrictions","Restricted '"..restriction.."' for user "..userid.." because of group "..v.name );
			return v[restriction];
		end
		if(v.accessfunction) then -- An access function is declared
			local accessfunction = string.gsub(v.accessfunction,"userid",userid); -- Add the current userid to this accessfunction
			_RunString("VMFCG.RightsManager.accessfunction["..userid.."] = "..accessfunction); -- Run it and the returnvalue to VMFCG.RightsManager.accessfunction[userid]
			if(VMFCG.RightsManager.accessfunction[userid]) then -- User got access from this function - So give him access!
				VMFCG.debug("VMFCG.RightsManager.restrictions","Restricted '"..restriction.."' for user "..userid.." because of group "..v.name );
				return v[restriction];
			end
			VMFCG.RightsManager.accessfunction[userid] = nil;
		end
		-- When there exist a group without a flag and without an accessfunction, it's the default group!
		if(not v.flag and not v.accessfunction) then
			general_restriction = v[restriction];
		end
	end
	if(general_restriction) then
		VMFCG.debug("VMFCG.RightsManager.restrictions","Restricted '"..restriction.."' for user "..userid.." because of general-access" );
		return general_restriction;
	end
	return nil;
end
