--[[

	#################################################
	
		VMF CopyGun - SaveLoad
		
	#################################################
	
]]--

VMFCG.SaveLoad = VMFCG.SaveLoad or {};
VMFCG.SaveLoad.users = VMFCG.SaveLoad.users or {};
VMFCG.SaveLoad.cache = VMFCG.SaveLoad.cache or {};

for i=1,_MaxPlayers() do
	VMFCG.SaveLoad.users[i] = VMFCG.SaveLoad.users[i] or {};
	VMFCG.SaveLoad.users[i].selection_ammount = VMFCG.SaveLoad.users[i].selection_ammount or 0;
	VMFCG.SaveLoad.users[i].last_spawn = VMFCG.SaveLoad.users[i].last_spawn or 0;
	VMFCG.SaveLoad.users[i].preview = VMFCG.SaveLoad.users[i].preview;
	VMFCG.SaveLoad.users[i].absolute = VMFCG.SaveLoad.users[i].absolute or false;
	if(VMFCG.SaveLoad.users[i].preview == nil) then
		VMFCG.SaveLoad.users[i].preview = true;
	end
	VMFCG.SaveLoad.users[i].spawn_height = VMFCG.SaveLoad.users[i].spawn_height or 0;
	VMFCG.SaveLoad.users[i].spawn_angle = VMFCG.SaveLoad.users[i].spawn_angle or 0;
	VMFCG.SaveLoad.users[i].preview_entities = VMFCG.SaveLoad.users[i].preview_entities or {};
	VMFCG.SaveLoad.users[i].preview_object = VMFCG.SaveLoad.users[i].preview_object or VMFCG.saver:new({});
	VMFCG.SaveLoad.users[i].current_file = VMFCG.SaveLoad.users[i].current_file or "";
end


-- #############################################
-- ############### Savefolder existance check #############
-- #############################################


-- ############## Folder existance check (void) @aVoN
function VMFCG.SaveLoad.SaveFolderExistanceCheck()
	local folder = VMFCG.config.save_folder;
	if(not _file.Exists(folder)) then
		_file.CreateDir(folder);
		VMFCG.debug("VMFCG.SaveLoad.SaveFolderExistanceCheck","Creating save folder because of non-existance "..folder);
	end
	if(not _file.Exists(folder.."/patterns")) then
		_file.CreateDir(folder.."/patterns");
		VMFCG.debug("VMFCG.SaveLoad.SaveFolderExistanceCheck","Creating patterns folder because of non-existance "..folder.."/patterns");
	end
	if(not _file.Exists(folder.."/database")) then
		_file.CreateDir(folder.."/database");
		VMFCG.debug("VMFCG.SaveLoad.SaveFolderExistanceCheck","Creating database folder because of non-existance "..folder.."/database");
	end
	if(not _file.Exists(folder.."/spawncache")) then
		_file.CreateDir(folder.."/spawncache");
		VMFCG.debug("VMFCG.SaveLoad.SaveFolderExistanceCheck","Creating spawncache folder because of non-existance "..folder.."/spawncache");
	end
end


-- #############################################
-- ############### Preview and spawning #################
-- #############################################

function VMFCG.SaveLoad.CreateSaveObject(userid)
	-- ############## Generate entity save object
	local selected = VMFCG.selection.users[userid].entities; -- Selected Entities
	local dependeny = VMFCG.Entities.dependency(selected); -- Dependend entities to the selected ones
	local entities = VMFCG.unique(VMFCG.merge(selected,dependeny)); -- List of all needed entities
	-- Allowed to save/select?
	for k,v in entities do
		if(not VMFCG.Entities.Allowed(v)) then
			entities[k] = nil;
		end
	end
	local SaveOb = VMFCG.saver:newById(entities);
	preview_entities = SaveOb:VMFLoaderPreviewEntities(userid);
	VMFCG.SaveLoad.users[userid].preview_entities = VMFCG.copy(preview_entities);
	VMFCG.SaveLoad.users[userid].preview_object = SaveOb;
	return SaveOb;
end

-- ############## Loads preview (void) @aVoN
function VMFCG.SaveLoad.SpawnPreview(userid,show)
	if(userid == 0) then return end;
	if(VMFCG.core.validVMFLoader()) then
		-- ############## Handle spawnangle and height
		if(show) then
			-- ############## And set the spawnangle/height again
			VMFLoader.Players[userid].spawn_height = VMFCG.SaveLoad.users[userid].spawn_height;
			VMFLoader.Players[userid].spawn_angle = VMFCG.SaveLoad.users[userid].spawn_angle;
		else
			-- ############## Reset VMFLoaders spawnangle and height
			VMFLoader.Players[userid].spawn_height = 0;
			VMFLoader.Players[userid].spawn_angle = 0;
		end
		if(VMFLoader.Players[userid].in_preview or VMFCG.SaveLoad.users[userid].absolute) then
			-- ############## Remove old preview
			VMFLoader.Players[userid].in_preview = false;
			if(rawget(VMFLoader,"CleanupPreview")) then
				-- VMFLoader 0.14 and (hopefully) above
				VMFLoader:CleanupPreview(userid);
			else
				-- VMFLoader 0.13
				_EntRemove(VMFLoader.Players[userid].preview_entity); -- Clear the preview
			end
			VMFLoader.Players[userid].preview_entity = nil;
		end
		if(show) then
			local cur_selection = VMFCG.selection.Ammount(userid);
			local last_selection = VMFCG.SaveLoad.users[userid].selection_ammount;
			local cur_swep = _EntGetType(_PlayerGetActiveWeapon(userid));
			-- ############## Only update the preview, when he selected a different ammount of props or he selected anything
			if(cur_selection ~= last_selection) then
				VMFCG.SaveLoad.CreateSaveObject(userid);
				VMFCG.SaveLoad.users[userid].absolute = false;
			end
			local preview_entities = VMFCG.copy(VMFCG.SaveLoad.users[userid].preview_entities);
			VMFCG.SaveLoad.users[userid].selection_ammount = cur_selection; -- Update the selection_ammount with current selection ammount
			if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_PREVIEW) and VMFCG.SaveLoad.users[userid].preview) then
				if(table.getn(preview_entities) ~= 0 and (cur_swep == "weapon_vmfcg_select" or cur_swep == "weapon_swep")) then
					VMFCG.debug("VMFCG.SaveLoad.SpawnPreview","Generating preview for "..userid.." with "..table.getn(preview_entities).." Entities");
					-- ############## Restrict ammount of selections
					local max_preview_ammount = tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_PREVIEW_AMMOUNT));
					if(max_preview_ammount) then
						if(max_preview_ammount > 0) then
							local counter = 0;
							local new_preview = {};
							for k,v in preview_entities do
								counter = counter + 1;
								table.insert(new_preview,v);
								if(counter == max_preview_ammount) then
									break;
								end
							end
							preview_entities = new_preview;
						end
					end
					-- ############## Delete special key/values
					local kill_keyvalues = {"_killhierarchy","parentname"};
					for k,v in preview_entities do
						local has_model = false;
						local classname_key = 0;
						for kk,vv in v.keyvalues do
							-- Remove the killhierarchy pseudo-key/value, so ropes etc wont get removed from the preview!
							for _,kill in kill_keyvalues do
								if(vv.key == kill) then
									preview_entities[k].keyvalues[kk] = nil;
								end
							end
							if(vv.key == "model" and vv.value ~= "") then
								if(string.find(vv.value,".mdl$")) then -- Only real models
									has_model = true;
								end
							end
							if(vv.key == "classname") then
								--if(string.find(vv.value,"prop_") or string.find(vv.value,"npc_")) then -- Some special stuff, or loading suxx :D (preview won't disappear)
									classname_key = kk;
								--end
							end
						end
						if(has_model and classname_key ~= 0) then
							-- Only change the classname, when a model exists!
							preview_entities[k].keyvalues[classname_key].value = "prop_dynamic_override";
						end
					end
					-- ##############Tempoary deactivate the VMFLoader spawntool
					local spawn_tool = VMFLoader.UseSpawnTool;
					VMFLoader.UseSpawnTool = false;
					VMFLoader:LoadPreview( userid, "VMFCopyGun", preview_entities);
					if(VMFCG.SaveLoad.users[userid].absolute) then
						VMFLoader.Players[userid].in_preview = false; -- Deactivate the movement of the preview when it shall spawn absolutely
					else
						VMFLoader.Players[userid].in_preview = true; -- Activate VMFLoader preview
					end
					VMFLoader.UseSpawnTool = spawn_tool;
				end
			end
		else
			if(VMFCG.selection.Ammount(userid) == 0) then
				VMFCG.SaveLoad.users[userid].selection_ammount = 0;
			end
		end
	end
	if(show) then
		_player.SetContextMenu( userid, "vmfcg" );
	end
end

-- ############## Spawns selected props (void) @aVoN
function VMFCG.SaveLoad.SpawnSelection(userid)
	if(userid == 0) then return end;
	if(VMFCG.core.validVMFLoader()) then
		if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SPAWNING)) then
			if(not VMFLoader.Players[userid].preview_entity and VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_PREVIEW)) then
				VMFCG.SaveLoad.SpawnPreview(userid,true);
			end
			local spawn_timout = tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_SPAWNTIMEOUT));
			if(VMFCG.SaveLoad.users[userid].last_spawn <= _CurTime()) then
				if(spawn_timout) then
					VMFCG.SaveLoad.users[userid].last_spawn = _CurTime() + spawn_timout;
				end
				local entities = VMFCG.copy(VMFCG.SaveLoad.users[userid].preview_entities);
				if(VMFCG.selection.Ammount(userid) > 0 or table.getn(entities) > 0) then
					VMFLoader.SpawnCounter = VMFLoader.SpawnCounter + 1; -- Increase spawncounter
				    -- Run name filter - But take the much faster one of the VMFCopyGun - The VMFLoader ones is very slow!
					local file = VMFCG.SaveLoad.users[userid].current_file
					if(file and file ~= "" and VMFCG.selection.Ammount(userid) == 0) then
						Addon:CallEvent( userid, Addon.EVENT_LOAD_FILE, VMFCG.config.save_folder.."/patterns/"..file..".vmf" ) -- VMFLoader addon call!
					end
					VMFCG.saver:NameFilter(entities);
					--VMFLoader:RunNameFilter( entities );
					-- Load preview.
					VMFLoader:LoadEntityList( userid, entities, VMFCG.SaveLoad.users[userid].absolute, {});
					if(VMFCG.SaveLoad.users[userid].absolute) then
						VMFLoader.Players[userid].in_preview = true;
						VMFCG.SaveLoad.SpawnPreview(userid,false);
						VMFCG.SaveLoad.users[userid].preview_entities = {};
					end
					VMFCG.SaveLoad.users[userid].absolute = false;
					VMFCG.debug("VMFCG.SaveLoad.SpawnSelection","Spawning "..table.getn(entities).." Entities for "..userid);
				end
			else
				VMFCG.Hud.Message(userid,"                You have to wait "..tostring(spawn_timout).." seconds for spawning a new copy");
			end
		else
			VMFCG.Hud.Message(userid,"                          You are not allowed to spawn anything!");
		end
	end
end


-- ############## Toggles preview 1/0 (void) @aVoN
function VMFCG.SaveLoad.TogglePreview(userid,cmd)
	local bool = VMFCG.tobool(cmd);
	if(bool == nil) then
		bool = not VMFCG.SaveLoad.users[userid].preview;
	end
	if(bool ~= nil) then
		if(VMFCG.SaveLoad.users[userid].preview ~= bool) then
			local status = "off";
			if(bool) then
				status = "on"
			end
			VMFCG.Hud.Message(userid,"                                             Preview turned '"..status.."'!");
			VMFCG.SaveLoad.users[userid].preview = bool;
			VMFCG.SaveLoad.SpawnPreview(userid,true);
		end
	end
end

-- ############## Rotate entities(void) @aVoN
function VMFCG.SaveLoad.Rotate(userid,cmd)
	if(VMFCG.core.validVMFLoader()) then
		local angle = tonumber(cmd);
		if(angle) then
			if(angle >= 0 and angle <= 360) then
				VMFCG.SaveLoad.users[userid].spawn_angle = angle;
				if(VMFLoader.Players[userid].in_preview) then
					VMFLoader.Players[userid].spawn_angle = angle;
				end
			end
		end
	end
end

-- ############## Changes a patterns spawnheight (void) @aVoN
function VMFCG.SaveLoad.Height(userid,cmd)
	if(VMFCG.core.validVMFLoader()) then
		local height = tonumber(cmd);
		if(height) then
			VMFCG.SaveLoad.users[userid].spawn_height = height;
			if(VMFLoader.Players[userid].in_preview) then
				VMFLoader.Players[userid].spawn_height = height;
			end
		end
	end
end

-- #############################################
-- ############### Spawncache ######################
-- #############################################

-- ############## Gets the current spawncache from a file (table) @aVoN
function VMFCG.SaveLoad.GetCache(file)
	local rawcache = _file.Read(VMFCG.config.save_folder.."/spawncache/"..file..".tmp");
	_RunString("VMFCG.SaveLoad.cache[\""..file.."\"] = "..rawcache);
	VMFCG.debug("VMFCG.SaveLoad.GetCache","Getting spawncache for file "..file);
	return VMFCG.SaveLoad.cache[file];
end

-- ############## Sets the current entity list to the file for spawncache (void) @aVoN
function VMFCG.SaveLoad.SetCache(file,entities)
	-- This function simply saves all entity information to a runable lua table to a file.
	local cache = "{";
	for _,v in entities do
		local ent = "\n{connections={";
		for _,con in v.connections do
			ent = ent.."{key=\""..con.key.."\",value=\""..con.value.."\"},";
		end
		ent = ent.."},\nkeyvalues={"
		for _,kv in v.keyvalues do
			if(kv.key == "model") then
				kv.value = string.gsub(kv.value,"\\","/"); -- Phoenix storm bugfix. Or in other words: Windows filesystem bugfix!
			end
			ent = ent.."{key=\""..kv.key.."\",value=\""..kv.value.."\"},";
		end
		ent = ent.."}\n}";
		cache = cache..ent..",";
	end
	cache = cache.."\n}";
	_file.Write(VMFCG.config.save_folder.."/spawncache/"..file..".tmp",cache);
	VMFCG.debug("VMFCG.SaveLoad.SetCache","Creating spawncache for file "..file);
end

-- ############## Sets the current entity list to the file for spawncache (void) @aVoN
function VMFCG.SaveLoad.HasCache(file)
	return _file.Exists(VMFCG.config.save_folder.."/spawncache/"..file..".tmp");
end

-- ############## Deletes old spawncache (void) @aVoN
function VMFCG.SaveLoad.ClearCache()
	local files = _file.Find(VMFCG.config.save_folder.."/spawncache/*.tmp");
	for _,file in files do
		if(VMFCG.config.clear_spawncache_on_load) then
			_file.Delete(VMFCG.config.save_folder.."/spawncache/"..file);
		else
			-- Otherwise, when not clearing spawncache on each start, optimize it, and remove dead-files
			if(not _file.Exists(VMFCG.config.save_folder.."/patterns/"..string.sub(file,1,-4).."vmf")) then
				_file.Delete(VMFCG.config.save_folder.."/spawncache/"..file);
			end
		end
	end
	if(VMFCG.config.clear_spawncache_on_load) then
		VMFCG.debug("VMFCG.SaveLoad.ClearCache","Cleared spawncache");
	else
		VMFCG.debug("VMFCG.SaveLoad.ClearCache","Optimized Spawncache");
	end
end

-- ############## Deletes old spawncache (void) @aVoN
function VMFCG.SaveLoad.DeleteCache(file)
	if(VMFCG.SaveLoad.HasCache(file)) then
		_file.Delete(VMFCG.config.save_folder.."/spawncache/"..file..".tmp");
		VMFCG.debug("VMFCG.SaveLoad.DeleteCache","Deleted cachefile for "..file);
	end
end

-- #############################################
-- ############### Position fixup #####################
-- #############################################

-- ############## Fixups the positions in an entity table for absolute loading (void) @aVoN
function VMFCG.SaveLoad:AbsolutePosition(entities,pos)
	for _,v in entities do
		for _,value in v.keyvalues do
			for _,fixup in VMFCG.defines.fixup.vectors do
				if(value.key == fixup) then
					local old_pos = VMFCG.explode(value.value," ");
					value.value = vecString(vecAdd(vector3(old_pos[1],old_pos[2],old_pos[3]),pos));
					break;
				end
			end
		end
	end
end

-- #############################################
-- ############### Save Load #######################
-- #############################################

-- ############## Finds a files, which is maybe set to deletion list and removes it. Not doing this may crash gmod, when you run a linux server and try to overwrite a file called "office.vmf" with "Office.vmf" - Don't ask me, why this happens. I just got some memory leaks and the server crashed @aVoN
function VMFCG.SaveLoad.DeleteOldFile(file)
	if(_IsLinux()) then
		if(_file.Exists(VMFCG.config.save_folder.."/patterns/"..file..".vmf")) then
			local files = _file.Find(VMFCG.config.save_folder.."/patterns/*.vmf");
			local lower_file = string.lower(file)..".vmf";
			for _,v in files do
				if(lower_file == string.lower(v)) then
					_file.Delete(VMFCG.config.save_folder.."/patterns/"..v);
					_file.Delete(VMFCG.config.save_folder.."/spawncache/"..string.sub(v,1,-4)..".tmp");
					break;
				end
			end
		end
	else
		_file.Delete(VMFCG.config.save_folder.."/patterns/"..file..".vmf");
	end
end

-- ############## Finds an entitiy in the entitylist (VMFLoader style) (number,table) @aVoN
function VMFCG.SaveLoad.FindEntitity(entities,classname)
	for k,v in entities do
		for _,kv in v.keyvalues do
			if(kv.key == "classname") then
				if(kv.value == classname) then
					return k,entities[k];
				end
				break;
			end
		end
	end
end

-- ############## Returns the entities, either parsed with VMFLoader or take from spawncache (table) @aVoN
function VMFCG.SaveLoad.LoadGetEntities(file)
	local entities = {};
	if(VMFCG.SaveLoad.HasCache(file)) then
		-- ############## Take spawncache instead of reparsing the VMFFile!
		VMFCG.debug("VMFCG.SaveLoad.LoadGetEntities","Taking spawncache for contraption");
		entities = VMFCG.SaveLoad.GetCache(file);
	else
		-- ############## Parse VMFFile and save to spawncache
		VMFCG.debug("VMFCG.SaveLoad.LoadGetEntities","Reparsingn VMFfile for contraption");
		entities,world_keys,lua_keys = VMFParser:parse(VMFCG.config.save_folder.."/patterns/"..file..".vmf");
		VMFCG.SaveLoad.SetCache(file,entities);
	end
	return entities;
end

-- ############## Saves current selection to a file (void) @aVoN
function VMFCG.SaveLoad.LoadFile(userid,file)
	if(VMFCG.core.validVMFLoader()) then
		VMFCG.SaveLoad.users[userid].absolute = false;
		VMFCG.SaveLoad.users[userid].current_file = file;
		local file_short = file;
		if(string.len(file) > 15) then
			file_short = string.sub(file,1,15).."...";
		end
		if(not _file.Exists(VMFCG.config.save_folder.."/patterns/"..file..".vmf")) then
			VMFCG.Hud.Message(userid,"                         The file '"..file_short.."' does not exist!");
			return false;
		end
		local can_load_all = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_LOAD_ALL);
		if(not can_load_all) then
			if(not VMFCG.menu.IsPublic(file)) then
				-- Not public? So check, if it's his pattern
				VMFCG.menu.UpdateUsers();
				local owner = VMFCG.menu.GetUserByPattern(file);
				local can_load_own = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_LOAD_OWN);
				if(not can_load_own) then 
					-- He even isn't allowed to load his own patterns  - Sad boy!
					VMFCG.Hud.Message(userid,"                                 You can only load public files!");
					return false;
				end
				if(string.lower(owner) ~= string.lower(_PlayerInfo(userid,"networkid"))) then
					VMFCG.Hud.Message(userid,"You can't load the file '"..file_short.."', because you are not the owner!");
					-- Can only load his own, but this isn't his own
					return false;
				end
			end
		end
		-- ############## Parse the given VMFFile with Jintos grandious VMFLoader
		Addon:CallEvent( userid, Addon.EVENT_LOAD_FILE, VMFCG.config.save_folder.."/patterns/"..file..".vmf" ) -- VMFLoader addon call!
		local entities = VMFCG.SaveLoad.LoadGetEntities(file);
		local meta_key,meta_data = VMFCG.SaveLoad.FindEntitity(entities,"vmf_global");
		if(rawget(VMFLoader,"ShowInformation")) then
			-- The used VMFLoader has the ShowInformation function - Lets use it
			VMFLoader:ShowInformation(userid,meta_data,file);
		end
		if(VMFCG.menu.IsAbsolute(file) and meta_key) then
			local spawn_timout = tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_SPAWNTIMEOUT));
			if(VMFCG.SaveLoad.users[userid].last_spawn <= _CurTime()) then
				if(spawn_timout) then
					VMFCG.SaveLoad.users[userid].last_spawn = _CurTime() + spawn_timout;
				end
				-- ############## File is absolute or for absolute loading - get the absolute position from the vmf_global entity now
				local abs_pos = VMFLoader:FindKV(meta_data.keyvalues, "origin");
				if(abs_pos) then
					-- ############## Remove metadata entity from the spawnlist
					if(meta_key) then
						entities[meta_key] = nil;
					end
					abs_pos = VMFCG.explode(abs_pos.value," ");
					if(table.getn(abs_pos) == 3) then
						abs_pos = vector3(abs_pos[1],abs_pos[2],abs_pos[3]);
						-- ############## Add the ammount of the ABS position now to the entities
						VMFCG.SaveLoad:AbsolutePosition(entities,abs_pos);
						-- ############## Load absolutely now
						local spawn_tool = VMFLoader.UseSpawnTool;
						VMFCG.selection.GiveSwep(userid,1);
						--[[
						VMFLoader.UseSpawnTool = false;
						VMFLoader:LoadPreview( userid, "VMFCopyGun", entities);
						VMFLoader.Players[userid].in_preview = false; -- Deactivate VMFLoader preview
						VMFLoader.UseSpawnTool = spawn_tool;
						--]]
						VMFCG.SaveLoad.users[userid].preview_entities = entities;
						VMFCG.SaveLoad.users[userid].absolute = true;
						VMFCG.SaveLoad.SpawnPreview(userid,true);
						-- Old absolute loading (direct loading without any preview)
						--[[
						VMFLoader.SpawnCounter = VMFLoader.SpawnCounter + 1; -- Increase spawncounter
						VMFCG.saver:NameFilter(entities);
						VMFLoader:LoadEntityList( userid, entities, true, {});
						VMFCG.Hud.Message(userid,"               Absolute loading of file '"..file_short.."' successfully!");
						--]]
						return;
					end
				end
			else
				VMFCG.Hud.Message(userid,"                You have to wait "..tostring(spawn_timout).." seconds for spawning a new copy");
				return;
			end
		end
		-- ############## Remove metadaa entity from the spawnlist
		if(meta_key) then
			entities[meta_key] = nil;
		end
		-- ############## Select the weapon for relative spawning
		VMFCG.selection.GiveSwep(userid,1)
		VMFCG.selection.DeselectAll(userid); -- First, deselect all entities, he got selected before
		-- ############## Load now
		VMFCG.SaveLoad.users[userid].preview_entities = entities;
		-- ############## Reset spawnheight and angle for VMFLoader
		VMFLoader.Players[userid].spawn_angle = 0;
		VMFLoader.Players[userid].spawn_height = 0;
		VMFCG.SaveLoad.users[userid].spawn_height = 0;
		VMFCG.SaveLoad.users[userid].spawn_angle = 0;
		VMFCG.SaveLoad.SpawnPreview(userid,true);
		VMFCG.Hud.Message(userid,"                         Loading of file '"..file_short.."' successfully!");
	end
end

-- ############## Saves current selection to a file (void) @aVoN
function VMFCG.SaveLoad.Save(userid,filename,mode)
	local filename = string.gsub(filename,"[%s&/?`\\{}#:|*<>]+","_"); -- Remove malicious chars etc
	local file_short = filename;
	if(string.len(filename) > 15) then
		file_short = string.sub(filename,1,15).."...";
	end
	VMFCG.debug("VMFCG.SaveLoad.XSaveFile","Saved entitys to VMF file ("..filename..")");
	local deleted = VMFCG.menu.IsDeleted(filename);
	if((not _file.Exists(VMFCG.config.save_folder.."/patterns/"..filename..".vmf") or deleted) and filename ~= "") then
		if(deleted) then
			-- Finally delete this file
			VMFCG.database.delete:Unset(string.lower(filename));
			VMFCG.database.delete:Save();
			VMFCG.SaveLoad.DeleteOldFile(filename);
		end
		-- ############## Fetch Entity Object
		-- ############## Normal selection saving
		local SaveOb = VMFCG.SaveLoad.users[userid].preview_object;
		if(mode == 1) then
			-- ############## xStack like saving
			local entities_to_xsave = VMFCG.merge(_EntitiesFindByClass("prop_*"),_EntitiesFindByClass("npc_*"),_EntitiesFindByClass("weapon_*"),_EntitiesFindByClass("item_*"));
			for k,v in entities_to_xsave do
				if(not VMFCG.selection.Allowed(userid,v)) then
					entities_to_xsave[k] = nil;
				end
			end
			local dependency = VMFCG.Entities.dependency(entities_to_xsave);
			SaveOb = VMFCG.saver:newById(VMFCG.merge(entities_to_xsave,dependency));
		end
		local entity_ammount = SaveOb:EntityCount();
		if(entity_ammount == 0) then
			VMFCG.Hud.Message(userid,"                                             Nothing to save!");
			return false;
		end
		local min_save_ammount = tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_MIN_SAVE_AMMOUNT));
		if(min_save_ammount) then
			if(min_save_ammount > entity_ammount) then
				VMFCG.Hud.Message(userid,"         You need to select at least '"..min_save_ammount.."' props to save them!");
				return false;
			end
		end
		-- ############## Update Database
		VMFCG.database.users:Set(string.lower(_PlayerInfo(userid,"networkid")),_PlayerInfo(userid,"name"));
		VMFCG.database.users:Save();
		VMFCG.database.patterns:Set(filename,string.lower(_PlayerInfo(userid,"networkid")));
		VMFCG.database.patterns:Save();
		if(mode == 1 or mode == 2) then
			-- Set to get spawned absolutely
			VMFCG.database.absolute:Set(filename,_GetCurrentMap());
			VMFCG.database.absolute:Save();
			VMFCG.menu.UpdateAbsolute()
		end
		-- ############## Save VMF
		if(not _file.Exists(VMFCG.config.save_folder.."/patterns/"..filename..".vmf")) then
			VMFCG.menu.ReloadMenu(); -- Rebuild menus (when neccessary)
		end
		SaveOb:GenerateVMF(filename,userid);
		-- ############## Delete Spawncache and update Hud
		VMFCG.SaveLoad.DeleteCache(filename);
		VMFCG.Hud.Message(userid,"                        File '"..file_short.."' successfully saved");
	else
		VMFCG.Hud.Message(userid,"                           File '"..file_short.."' already exists!");
		VMFCG.debug("VMFCG.SaveLoad.SaveUserSelection","Wasn't able to save file "..filename.." - File still exists!");
	end
end

-- ############## Saves current selection to a file (void) @aVoN
function VMFCG.SaveLoad.SaveFile(userid,cmd)
	if(not cmd) then return false end;
	if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SAVE)) then
		VMFCG.SaveLoad.Save(userid,cmd,0);
	end
end

-- ############## Saves nearly all contraptions of the map like xStack (void) @aVoN
function VMFCG.SaveLoad.XSaveFile(userid,cmd)
	if(not cmd) then return false end;
	if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SAVE) and VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_XSAVE)) then
		VMFCG.SaveLoad.Save(userid,cmd,1);
	end
end

-- ############## Saves a pattern absolutely (void) @aVoN
function VMFCG.SaveLoad.SaveFileAbsolute(userid,cmd)
	if(not cmd) then return false end;
	if(VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SAVE) and (VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_MARK_ABSOLUTE_ALL) or VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_MARK_ABSOLUTE_OWN))) then
		VMFCG.SaveLoad.Save(userid,cmd,2);
	end
end

-- ############## Deletes or restores a file (void) @aVoN
function VMFCG.SaveLoad.DeleteRestore(userid,file,restore)
	if(_file.Exists(VMFCG.config.save_folder.."/patterns/"..file..".vmf")) then
		local can_delete_own = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_DELETE_OWN);
		local can_delete_all = VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_DELETE_ALL);
		local filename = file;
		if(can_delete_all or (can_delete_own and VMFCG.menu.GetUserByPattern(pattern))) then
			if(string.len(filename) > 15) then
				filename = string.sub(filename,1,15).."...";
			end
			if(restore) then
				VMFCG.debug("VMFCG.menu.DeleteFile","File "..file.." deleted by "..userid );
				-- Set to deletion list
				VMFCG.database.delete:Set(string.lower(file),_PlayerInfo(userid,"name").." "..string.upper(_PlayerInfo(userid,"networkid")));
				VMFCG.Hud.Message(userid,"               File '"..filename.."' set to deletion list!");
			else
				--Remove from deletion list
				VMFCG.debug("VMFCG.menu.DeleteFile","File "..file.." restored by "..userid );
				VMFCG.database.delete:Unset(string.lower(file));
				VMFCG.Hud.Message(userid,"                      Restored file '"..filename.."'!");
			end
			VMFCG.database.delete:Save();
			VMFCG.menu.UpdateDeleted();
			VMFCG.menu.ReloadMenu(); -- Handle a menu reload
		end
	else
		VMFCG.Hud.Message(userid,"                      File '"..file.."' does not exist!");
	end
end

-- #############################################
-- ###############CONCOMMANDS ###################
-- #############################################

-- ######################### Saves selected entitys (void) @aVoN

VMFCG.Commands.Add("vmfcg_save",VMFCG.SaveLoad.SaveFile,"!vmfcg_save","!save"); -- Standard saving
VMFCG.Commands.Add("vmfcg_asave",VMFCG.SaveLoad.SaveFileAbsolute,"!vmfcg_asave","!asave"); -- Absolute saving
VMFCG.Commands.Add("vmfcg_xsave",VMFCG.SaveLoad.XSaveFile,"!vmfcg_xsave","!xsave"); -- xStack like saving of whole map contraptions
VMFCG.Commands.Add("vmfcg_load",VMFCG.SaveLoad.LoadFile,"!vmfcg_load","!load"); -- Loading
VMFCG.Commands.Add("vmfcg_rotate",VMFCG.SaveLoad.Rotate,"!vmfcg_rotate","!rotate"); -- Rotatng
VMFCG.Commands.Add("vmfcg_height",VMFCG.SaveLoad.Height,"!vmfcg_height","!height"); -- Changing height
VMFCG.Commands.Add("vmfcg_preview",VMFCG.SaveLoad.TogglePreview,"!vmfcg_preview","!preview"); -- Toggeling preview
VMFCG.Commands.Add("vmfcg_delete",function (i,s) VMFCG.SaveLoad.DeleteRestore(i,s,true) end,"!vmfcg_delete","!delete"); -- Deleting pattern
VMFCG.Commands.Add("vmfcg_restore",function (i,s) VMFCG.SaveLoad.DeleteRestore(i,s,false) end,"!vmfcg_restore","!restore"); -- Restoring pattern

-- #############################################
-- ############### Init ###########################
-- #############################################

VMFCG.SaveLoad.SaveFolderExistanceCheck(); -- Check for savefolder existance
if(_CurTime() <= 20) then
	-- Only delete complete cache on server startup, but not on e.g. a kill/reload of the VMFCopyGun
	VMFCG.SaveLoad.ClearCache();
end
