--[[

	#############################################
	
		VMF CopyGun - Entity Hook
		
	#############################################
	
]]--
VMFCG.SWEPHook = VMFCG.SWEPHook or {};
VMFCG.SWEPHook.SWEPS = VMFCG.SWEPHook.SWEPS or {};

-- ############## This function runs the "override" for the SWEP @ aVoN

function VMFCG.SWEPHook.setEntityFunctions(MyIndex)
	VMFCG.debug("VMFCG.SWEPHook.setEntityFunctions","Overriding Entity functions for SWEP "..MyIndex);
	_SWEPRunString(MyIndex,[[
		-- Run default inclusion scripts (when e.g. the original got deleted), to make most SWEPs working again
		_OpenScript("VMFCopyGun/extensions/includes/defines.lua");
		_OpenScript("VMFCopyGun/extensions/includes/vector3.lua");
		_OpenScript("VMFCopyGun/extensions/includes/misc.lua");
		_OpenScript("VMFCopyGun/extensions/includes/backcompat.lua");
		-- Include some special scriptes. Neccessary, when someone delted the base.lua SWEP file. Otherwise, some functions are missing
		_OpenScript( "includes/defines.lua" );
		_OpenScript( "includes/vector3.lua" );
		_OpenScript( "includes/misc.lua" );
		_OpenScript( "includes/backcompat.lua" );
		-- Hook to _EntSetKeyValue	
		function _EntSetKeyValue(id,key,value)
			_RunString("_EntSetKeyValue("..tostring(id)..",'"..tostring(key).."','"..string.gsub(tostring(value),"\\","/").."')");
		end
		-- Hook to _EntFire
		function _EntFire(id,connection,output,delay)
			_RunString("_EntFire("..tostring(id)..",'"..tostring(connection).."','"..tostring(output).."','"..tostring(delay).."')");
		end
		-- Hook to _EntSetMaterial
		function _EntSetMaterial(id,mat)
			_RunString("_EntSetMaterial("..tostring(id)..",'"..string.gsub(tostring(mat),"\\","/").."')");
		end
		-- Hook to _phys.EnableMotion
		function _phys.EnableMotion(id,motion)
			_RunString("_phys.EnableMotion("..tostring(id)..","..tostring(motion)..")");
		end
		function _PhysEnableMotion(id,motion)
			_RunString("_phys.EnableMotion("..tostring(id)..","..tostring(motion)..")");
		end
		-- Hook to _phys.ConstraintSetEnts
		function _phys.ConstraintSetEnts(id,attach1,attach2)
			_RunString("_phys.ConstraintSetEnts("..tostring(id)..","..tostring(attach1)..","..tostring(attach2)..")");
		end
		function _PhysConstraintSetEnts(id,attach1,attach2)
			_RunString("_phys.ConstraintSetEnts("..tostring(id)..","..tostring(attach1)..","..tostring(attach2)..")");
		end
		-- Hook to _phys.EnableGravity
		function _phys.EnableGravity(id,bool)
			_RunString("_phys.EnableGravity("..tostring(id)..","..tostring(bool)..")");
		end
		function _PhysEnableGravity(id,bool)
			_RunString("_phys.EnableGravity("..tostring(id)..","..tostring(bool)..")");
		end
		-- Hook to _phys.EnableCollisions
		function _phys.EnableCollisions(id,bool)
			_RunString("_phys.EnableCollisions("..tostring(id)..","..tostring(bool)..")");
		end
		function _PhysEnableCollisions(id,bool)
			_RunString("_phys.EnableCollisions("..tostring(id)..","..tostring(bool)..")");
		end
		-- Hook to _EntSpawn
		function _EntSpawn(id)
			_RunString("_EntSpawn("..tostring(id)..")");
		end
		-- Hook to _EntSetName
		function _EntSetName(id,name)
			_RunString("_EntSetName("..tostring(id)..",'"..tostring(name).."')");
		end
		-- Hook to _EntSetAng
		function _EntSetAng(id,ang)
			_RunString("_EntSetAng("..tostring(id)..",vector3("..string.gsub(vecString(ang)," ",",").."))");
		end
		-- Hook to _EntSetAngAngle
		function _EntSetAngAngle(id,ang)
			_RunString("_EntSetAngAngle("..tostring(id)..",vector3("..string.gsub(vecString(ang)," ",",").."))");
		end
		-- Hook to _EntSetModel
		function _EntSetModel(id,str)
			_RunString("_EntSetModel("..tostring(id)..",'"..str.."')");
		end
		--[[
		-- Not neccessary anymore - Only added for testing purpose due to Entity Class changes
		-- Hook to_EntSetParent
		function _EntSetParent(id,parent)
			_RunString("_EntSetParent("..tostring(id)..","..tostring(parent)..")");
		end
		--]]
	]]);
end

-- ############## Gets called, when a player gets a SWEP by using _PlayerGiveSWEP @ aVoN
function VMFCG.SWEPHook._PlayerGiveSWEP(userid,weapon)
	VMFCG.AddTimerOnce("VMFCG.SWEPHook._PlayerGiveSWEP_timer",0.1,1,VMFCG.SWEPHook._PlayerGiveSWEP_timer,userid,weapon);
end

-- ############## After a short delay, this function runs the VMFCG.SWEPHook.setEntityFunctions function on the new SWEP @ aVoN
function VMFCG.SWEPHook._PlayerGiveSWEP_timer(userid,weapon,id)
	local swep = id or _PlayerGetActiveWeapon(userid);
	if(not VMFCG.SWEPHook.SWEPS[swep]) then
		-- Make the SWEP saveable
		VMFCG.Entities[swep]:SetClass("weapon_swep");
		VMFCG.Entities[swep]:SetKeyValue("Script",weapon);
		VMFCG.Entities[swep]:SetKeyValue("model","aVoN rocks da house with the VMFCopyGun"); -- Just a dummy. Ent class fetches the correct model later.
		VMFCG.SWEPHook.setEntityFunctions(swep);
		VMFCG.SWEPHook.SWEPS[swep] = true;
	end
end

-- ############## Checks, if the swep still exists or not
function VMFCG.SWEPHook.ExistanceCheck_timer()
	for k,_ in VMFCG.SWEPHook.SWEPS do
		if(not _EntExists(k)) then
			VMFCG.SWEPHook.SWEPS[k] = nil;
			VMFCG.debug("VMFCG.SWEPHook.ExistanceCheck_timer","Removed non-existant SWEP out of index");
		end
	end
end


-- #############################################
-- ################### Init #######################
-- #############################################

VMFCG.AddTimerOnce("VMFCG.SWEPHook.ExistanceCheck_timer",0.2,0,VMFCG.SWEPHook.ExistanceCheck_timer);
VMFCG.core.overrideFunctionAdd("_PlayerGiveSWEP","VMFCG.SWEPHook._PlayerGiveSWEP");