--[[

	#############################################
	
		VMF CopyGun - Entities and it's informations
		
	#############################################
	
]]--
-- ################################# Tracelines
VMFCG.TraceLine = {}

-- ############## Only used internly - Don't call it directly @aVoN
function VMFCG.TraceLine:DoTrace()
	if(self.traced ~= true) then
		_TraceLine(self.pos,self.direction,self.length,self.ignore);
		if(self.cg) then
			_TraceSetCollisionGroup(self.cg);
		end
		self.traced = true;
		self.endpos = _TraceEndPos();
		self.fraction = _TraceFraction();
		self.hitworld = _TraceHitWorld();
		self.hit  = _TraceHit();
		self.ent = _TraceGetEnt();
		self.sfnormal = _TraceGetSurfaceNormal();
		if(_TraceDidHitSky() == 4) then
			self.hitsky = true;
		else
			self.hitsky = false;
		end
		self.hitbox = _TraceDidHitHitbox();
		self.texture = _TraceGetTexture();
		self.hitwater = _TraceDidHitWater();
		if(VMFCG.config.debug and VMFCG.config.debug_position) then
			-- The traceline itself
			_EffectInit();
			_EffectSetEnt(1);
			_EffectSetStart(self.pos);
			_EffectSetOrigin(self.endpos);
			_EffectSetScale(10);
			_EffectSetMagnitude(5);
			_EffectDispatch("FadingLineTeam");
			-- The surface Normal
			_EffectInit();
			_EffectSetEnt(1);
			_EffectSetStart(self.endpos);
			_EffectSetOrigin(vecAdd(self.endpos,vecMul(self.sfnormal,100)));
			_EffectSetScale(10);
			_EffectSetMagnitude(5);
			_EffectDispatch("FadingLineTeam");
		end
		-- Uncommented traceline debug because its massive spam
		--VMFCG.debug("VMFCG.TraceLine:DoTrace","Trace pos: (".. math.ceil(self.pos.x*10)/10 .."|"..  math.ceil(self.pos.y*10)/10 .."|"..  math.ceil(self.pos.z*10)/10 ..") dir: (".. math.ceil(self.direction.x*10)/10 .."|".. math.ceil(self.direction.y*10)/10 .."|".. math.ceil(self.direction.z*10)/10 ..") length: "..self.length.." ignore "..tostring(self.ignore));
	end
end

-- ############## Create New Traceline (object) @aVoN
function VMFCG.TraceLine:New(pos,direction,length,ignore)
	local obj = {}
	setmetatable(obj,self);
	self.__index = self;
	--[[
	-- Old style - now metatables
	-- Adding functions of TraceLine class to this object
	for k, v in VMFCG.TraceLine do 
		obj[k]=v
	end
	--]]
	obj.length = length or VMFCG.config.trace_default_length;
	obj.traced = false;
	obj.ignore = ignore;
	obj.pos = pos;
	obj.direction = direction;
	return obj;
end

-- ############## Create New Traceline based from a player @aVoN
function VMFCG.TraceLine:NewUser(userid,length)
	local pos = _PlayerGetShootPos(userid);
	local direction = _PlayerGetShootAng(userid);
	return VMFCG.TraceLine:New(pos,direction,length,userid);
end

-- ############## Get Ent Pos (vector3) @aVoN
function VMFCG.TraceLine:EndPos()
	self:DoTrace();
	return self.endpos;
end

-- ############## Return percentage of done length till hit from 0 till 1 (number) @aVoN
function VMFCG.TraceLine:Fraction()
	self:DoTrace();
	return self.fraction;
end

-- ############## Trace hit world (boolean) @aVoN
function VMFCG.TraceLine:HitWorld()
	self:DoTrace();
	return self.hitworld;
end

-- ############## Trace hit (boolean) @aVoN
function VMFCG.TraceLine:Hit()
	self:DoTrace();
	return self.hit;
end

-- ############## Trace Get Entity (number) @aVoN
function VMFCG.TraceLine:GetEnt()
	self:DoTrace();
	return self.ent;
end

-- ############## Trace get surface Normal (vector3) @aVoN
function VMFCG.TraceLine:GetSurfaceNormal()
	self:DoTrace();
	return self.sfnormal;
end

-- ############## Trace hit sky (boolean) @aVoN
function VMFCG.TraceLine:HitSky()
	self:DoTrace();
	return self.hitsky;
end

-- ############## Trace hit hitbox (boolean) @aVoN
function VMFCG.TraceLine:HitHitBox()
	self:DoTrace();
	return self.hitbox;
end

-- ############## Trace get texture (string) @aVoN
function VMFCG.TraceLine:GetTexture()
	self:DoTrace();
	return self.texture;
end

-- ############## Trace hit water (boolean) @aVoN
function VMFCG.TraceLine:HitWater()
	self:DoTrace();
	return self.hitwater;
end

-- ############## Sets the collision group for the traceline (void) @aVoN
function VMFCG.TraceLine:CollisionGroup(cg)
	self.cg = cg;
end

