--[[

	####################################
	
		xMenuEngine v.1
		By H-=NooB=-
		
	####################################

]]--

--[[ SETUP ]]--

XMENU_SKIN = "xMenu"; -- do not change unless u know what this does ;)
XM_VERSION    = "v0.5c"; -- The version of XME.

XM_RECT_BASE = 8000; -- This declares the Rect index base
XM_TEXT_BASE = 8000; -- This declares the Text index base

XMENU_DEBUG = false;

XM_AUTO_SCROLL = true;
XM_AUTO_SCROLL_DELAY = 0.26;
XM_AUTO_SCROLL_WAIT = 0.6;

--[[ CODE ]]--

if _Hud == nil then _OpenScript("LuaBOT/lb_extensions.lua"); end;

if ULib == nil then ULib={}; end;
if ULib.XME == nil then ULib.XME={}; end; -- Create xMenuObject.
if ULib.XME.curMenu == nil then ULib.XME.curMenu={}; end; -- Initial listener object.

function ULib.XME:new( mname, skin )
	skin = skin or "xMenu"
	
	--[[
	--Deactivated this bevahiour! by aVoN
	if not _file.Exists( "materials/xm_mat/".. skin ) or not _file.IsDir( "materials/xm_mat/" .. skin ) then
		return nil, "Invalid skin specified!"
	end
	if not _file.Exists( "materials/xm_mat/".. skin .. "/xMenu.vmt" ) or
	   --[[ not _file.Exists( "materials/xm_mat/".. skin .. "/xPanelL.vmt" ) or ]]-- I got a large Panel aswell.
	   not _file.Exists( "materials/xm_mat/".. skin .. "/xPanelM.vmt" ) or
	   --not _file.Exists( "lua/xm_skins/"..skin..".xSkin" ) or
	   not _file.Exists( "materials/xm_mat/".. skin .. "/xPanelS.vmt" ) then
		return nil, "You do not have all the textures required for this skin!";
	end
	--]]

	local obj = {}
	setmetatable( obj, self )
	self.__index = self

	--Global
	obj.menuname = mname
	obj.options = {}
	obj.skin = skin
	--Related
	obj.current = {}
	obj.pcurrent = {}
	obj.curPan = {}
	obj.mopen = {}
	obj.top = {}
	
	for i=1,_MaxPlayers() do
		obj.top[ i ] = 1
		obj.current[ i ] = 1
		obj.pcurrent[ i ] = 1
		obj.curPan[ i ] = nil
		obj.mopen[ i ] = false
	end
	
	return obj
	
end

function ULib.XME:SetAccessHandle(access,callback)

	if type(access) == "number" then
		if access <= 0 then
			self:DebugMsg("The access 0 says 'No Access Limit' and cannot be used as an access string."); -- OMG fix that gramar please :(
			return false;
		end; -- 0 is no such limit in here.
	end
	
	if self.access == nil then self.access={}; end; -- creating the object for the access.
	if self.access[access] ~= nil then return 2; end; -- Error 2 already exists
	
	self.access[access]={};
	self.access[access].callback = callback;
	return true;
	
end

function ULib.XME:SetGlobalAccessHandle(callback)

	if type(callback) ~= "function" then
		-- Error: A callback needs to be a function!
		self:DebugMsg("You need to supply a function as callback");
		return false;
	end
	
	self.globalAccess = callback;
	
end

function ULib.XME:NewOption(name,access)
	
	local num = table.getn(self.options); num = num + 1;
	local opt;
	opt = {opt_name=name,opt_access=access,callback=nil,panel=nil};
	self.options[num] = opt;
	
	self:DebugMsg("New Option '"..self.options[num].opt_name.."'");
	return num;
	
end

function ULib.XME:ChangeMenuOption(index,newname,newaccess)

	if self.options[index] == nil then return false; end; -- No Option on that Index
	self.options[index].opt_name = newname;
	self.options[index].opt_access = access;
	return index;
	
end

function ULib.XME:ChangeMenuOptionCallback(index,callback,args)

	if self.options[index] == nil then return false; end;
	if type(callback ) ~= "function" then return false; end;
	
	self.options[index].callback = callback;
	self.options[index].args = args;
	self.options[index].panel = nil;
	
	return index;

end

function ULib.XME:AddConCommand(command)

	if self.ccmd == nil then self.ccmd = {}; end;
	local num = table.getn(self.ccmd);
	num = num + 1;
	self.ccmd[num] = function(u,a) self:Show(u) end;
	CONCOMMAND(command,self.ccmd[num]);
	
end

function ULib.XME:OptionAddTable(otable)
   
   local temp = {};
   for i=1, table.getn(otable) do
      
	  temp[i]=self:NewOption(otable[i].name,otable[i].access);
	  
   end
   
   local out = self:OptionAddSet(temp,otable);
   return out;
   
end

function ULib.XME:OptionAddSet(set,otable)

	local temp={};
	local inTemp={};
	for i=1, table.getn(otable) do
		
		if otable[i].callback ~= nil then
			
			temp[i]=self:OptionAddCallback(set[i],otable[i].callback,otable[i].args);
			
		else
			
			temp[i]=self:OptionAddPanel(set[i]);
			inTemp[i]={};
			
			for ii=1, table.getn(otable[i].panel) do
				
				inTemp[i]=self:PanelAddOption(temp[i],otable[i].panel[ii].name,otable[i].panel[ii].callback,otable[i].panel[ii].args);
				
			end				
			
		end
		
	end
	return temp or false;
	
end

function ULib.XME:OptionAddDynamicSet(otable)

	if type(otable) ~= "table" then return false; end;
	local temp = {};
	for i=1, table.getn(otable) do
		
		temp[i]=self:OptionAddDynamic(otable[i].dynamic,otable[i].access,otable[i].callback);
		if otable[i].panel ~= nil and type(otable[i].panel) == "table" then
			temp[i]=self:OptionAddPanel(temp[i]);
			for ii=1, table.getn(otable[i].panel) do
				self:PanelAddOption(temp[i],otable[i].panel[ii].name,otable[i].panel[ii].callback,otable[i].panel[ii].args);
			end
		end
		
	end
	return temp or nil;
	
end

function ULib.XME:OptionAddDynamic(dynamic,access,object)

	local num = self:NewOption("NoName",access);
	local obj=dynamic(num);
	if type(object) == "function" then
		self.options[num].callback = object;
	else
		self.options[num].panel = {};
	end
	self.options[num].dynamic = dynamic;
	self.options[num].opt_name = obj.name;
	self.options[num].args = obj.args;
	return num;
	
end

function ULib.XME:OptionAddCallback(toid,callback,args)

	if self.options[toid] == nil then return false; end; -- No Option on that id.
	
	self.options[toid].panel=nil;
	self.options[toid].callback=callback;
	self.options[toid].args=args;
	
	self:DebugMsg("Callback added to Option::"..self.options[toid].opt_name);
	return toid;
	
end

function ULib.XME:OptionSetColor(toid,...)
	-- Color addon added by aVoN
	if self.options[toid] == nil then return false; end; -- No Option on that id.
	
	self.options[toid].color={unpack(arg)};
	
	self:DebugMsg("Added color::"..self.options[toid].opt_name);
	return toid;
end

function ULib.XME:OptionAddPanel(toid)

	if self.options[toid] == nil then return false; end; -- No Option on that id.
	
	self.options[toid].callback=nil;
	self.options[toid].panel={};
	
	self:DebugMsg("Panel added to Option::"..self.options[toid].opt_name);
	return toid;
	
end

function ULib.XME:PanelAddOption(panid,label,callback,args)

	local num = table.getn(self.options[panid].panel);
	num = num + 1;
	
	option = {popt_name=label,popt_callback=callback,args=args};
	self.options[panid].panel[num]=option;
	
	self:DebugMsg("Created option in xPanel::"..self.options[panid].opt_name);
	
	return num;
	
end

function ULib.XME:Update(num)

	if num <= 0 then return false; end;
	if type(self.options[num].dynamic) == "function" then
		local obj = self.options[num].dynamic(num);
		self.options[num].opt_name = obj.name;
		self.options[num].args = obj.args;
	end
	return true;

end

function ULib.XME:Show(userid)

	if self.mopen[userid] == true then return false; end; -- Menu already open.
	
	_Hud.Rect("xm_mat/"..XMENU_SKIN.."/xMenu",1,0.05,0.3,0.85,255,255,255,255,9999,0,0,0,userid,8000);
	_Hud.RectAnimate("xm_mat/"..XMENU_SKIN.."/xMenu",0.7,0.05,0.3,0.85,255,255,255,255,0,userid,8000,0.5,0.5);
	
	_Hud.Rect("gmod/white",0.74,0.24,0.25,0.02,255,255,255,120,9999,0,0,0.5,userid,8001);
	
	_Hud.Text("TargetID",0.74,0.115,255,80,0,255,9999,0,0,self.menuname,0.75,userid,8000);
	
	for i=1, table.getn(self.options) do
		
		local posy = 0.24 + (0.02 * (i-1));
		if self.options[i].dynamic ~= nil then self:Update(i); end;
		local strtodraw = "["..i.."] "..self.options[i].opt_name.."";
		-- Color addon added by aVoN
		local color = {0,180,255,255};
		if(type(self.options[i].color) == "table") then
			if(table.getn(self.options[i].color) == 4) then
				color = self.options[i].color;
			end
		end
		-- Color addon added by aVoN
		_Hud.Text("ChatFont",0.745,posy,color[1],color[2],color[3],color[4],9999,0,0,strtodraw,0.75,userid,8001+i);
		if i >= 25 then break; end;
		
	end
	
	_Hud.Text("BudgetLabel",0.87,0.813,255,255,255,255,9999,0,0,"Version: "..XM_VERSION,0.5,userid,10000);
	
	_PlayerLockInPlace(userid,true);
	
	self:DebugMsg("Menu opened");
	self.top[userid] = 1;
	ULib.XME.curMenu[userid] = self;
	self.mopen[userid] = true;
	return true;
	
end

function ULib.XME:AddCloseEvent(callback,...)

	if type(callback) ~= "function" then return nil, "You are stupid -.-"; end

	self.CloseCallback = callback;
	self.CloseCallbackArgs = arg;
	self:DebugMsg("Close Event Callback has been added!");
	
end

function ULib.XME:Hide(userid)

	if self.mopen[userid] == false then return false; end; -- No menu open!
	
	_Hud.RectAnimate("xm_mat/"..XMENU_SKIN.."/xMenu",1,0.05,0.3,0.85,255,255,255,255,0,userid,8000,0.5,0.5);
	_GModRect_Hide(userid,8000,0,0.5);
	_GModRect_Hide(userid,8001,0,0);
	
	_GModText_Hide(userid,8000,0,0);	
	_GModText_Hide(userid,10000,0,0);
	
	for i=1, table.getn(self.options) do
		_GModText_Hide(userid,8001+i,0,0);
	end
	
	_PlayerLockInPlace(userid,false);
	
	self:DebugMsg("Menu closed");
	ULib.XME.curMenu[userid] = nil;
	self.mopen[userid] = false;
	self.current[userid] = 1; -- Hot-Fixed by aVoN (otherwise the cursor jumped randomly to one or another position)
	if self.CloseCallback ~= nil and type(self.CloseCallback) == "function" then
		self.CloseCallback(unpack(self.CloseCallbackArgs));
	end
	
	return true;
	
end

function ULib.XME:Back(userid,MenuToOpen)

	self:Hide(userid);

	if MenuToOpen.Show ~= nil then
		MenuToOpen:Show(userid);
	end

end

function ULib.XME:Move(userid,to)
	if self.curPan[userid] == nil then
	
		local ymod = tonumber(self.current[userid]);
		local ito = ymod+(to);
		if ito <= 0 or ito > table.getn(self.options) then return; end;
		--_PrintMessage(userid,3,"ITO: "..ito);
		if ito > (self.top[userid]+24) then
			self:Scroll(userid,to);
			return
		end
		if ito < self.top[userid] then
			self:Scroll(userid,to);
			return
		end
		
		if (ymod +(to)) > ymod then
			inter = 0;
		else
			inter = (self.top[userid] -1)*-1;
		end
		
		local posy = 0.24 + (0.02 * ((ito+(inter))-1));
		_Hud.RectAnimate("gmod/white",0.74,posy,0.25,0.02,255,255,255,120,0,userid,8001,0.25,0.5);
		self.current[userid] = ito;
		
		self:DebugMsg("Pointer moved to Entry::"..self.current[userid]);
		
	else
		
		local ymod2 = tonumber(self.pcurrent[userid]);
		local to = ymod2+(to);
		if to <= 0 or to > table.getn(self.options[self.current[userid]].panel) then return; end;
		
		local posy = 0.28 + (0.02 * (to-1));
		_Hud.RectAnimate("gmod/white",0.42,posy,0.26,0.02,255,255,255,120,0,userid,8101,0.25,0.5);
		self.pcurrent[userid] = to;
		
		self:DebugMsg("Pointer moved to pEntry::"..self.pcurrent[userid]);
		
	end
	
end

function ULib.XME:Scroll(userid,to)

	local cnt = table.getn(self.options);
	local len = 0.02;
	local cur = self.current[userid];
	
	if (cur + (to)) > cur then
		-- we are scrolling down.
		local pos = 1;
		for i=(cur - 24), cur do
			local moveto = (0.24 + (0.02 * (pos-1))) - 0.02; -- move 0.02 units up.
			-- Color addon added by aVoN
			local color = {0,180,255,255};
			if(type(self.options[i].color) == "table") then
				if(table.getn(self.options[i].color) == 4) then
					color = self.options[i].color;
				end
			end
			_Hud.TextAnimate("ChatFont",0.745,moveto,color[1],color[2],color[3],color[4],0,userid,8001+i,0.25,0.5);
			if i == (cur - 24) then
				_GModText_Hide(userid,8001+i,0,0);
			end
			if i == cur then
				local color = {0,180,255,255};
				if(type(self.options[i+1].color) == "table") then
					if(table.getn(self.options[i+1].color) == 4) then
						color = self.options[i+1].color;
					end
				end
				_Hud.Text("ChatFont",0.745,(0.24 + 0.02 * 24),color[1],color[2],color[3],color[4],9999,0,0,"["..(i+1).."] "..self.options[i+1].opt_name,0.25,userid,8001+i+1);
				self.current[userid] = i + 1;
			end
			pos = pos + 1;
		end
		self.top[userid] = self.top[userid] + 1;
		--_PrintMessage(userid,3,"DOWN: TOP IS "..self.top[userid]);
	else
		local pos = 25;
		for i=(cur + 24), cur, -1 do
			local moveto = (0.24 + (0.02 * (pos-1))) + 0.02; -- move 0.02 units up.
			-- Color addon added by aVoN
			local color = {0,180,255,255};
			if(type(self.options[i].color) == "table") then
				if(table.getn(self.options[i].color) == 4) then
					color = self.options[i].color;
				end
			end
			_Hud.TextAnimate("ChatFont",0.745,moveto,color[1],color[2],color[3],color[4],0,userid,8001+i,0.25,0.5);
			if i == (cur + 24) then
				_GModText_Hide(userid,8001+i,0,0);
			end
			if i == cur then
				local color = {0,180,255,255};
				if(type(self.options[i-1].color) == "table") then
					if(table.getn(self.options[i-1].color) == 4) then
						color = self.options[i-1].color;
					end
				end
				_Hud.Text("ChatFont",0.745,0.24,color[1],color[2],color[3],color[4],9999,0,0,"["..(i-1).."] "..self.options[i-1].opt_name,0.25,userid,8001+i-1);
				self.current[userid] = i - 1;
			end
			pos = pos - 1;
		end
		self.top[userid] = self.top[userid] - 1;
		--_PrintMessage(userid,3,"UP: TOP IS "..self.top[userid]);
	end
	
end

function ULib.XME:ShowPanel(userid)

	if self.curPan[userid] ~= nil then return false; end; -- already a panel open.
	
	local size = table.getn(self.options[self.current[userid]].panel);
	if size >= 8 then PanSize = "M";high = 0.4; else PanSize = "S";high = 0.2; end; -- Auto adjust the size of the panel.
	
	if self.options[self.current[userid]].opt_access ~= nil and not self:IsAllowed(userid) then
		_Hud.Text("ChatFont",0.745,(0.24 + 0.02 * (self.current[userid] - (self.top[userid] -1) -1)),255,80,0,255,9999,0,0,"[ Access Denied ]",0,userid,8001+self.current[userid]);
		AddTimer(1,1,self.ResetValueMenu,self,userid,self.current[userid]);
		return;
	end	
	
	_Hud.Rect("xm_mat/"..XMENU_SKIN.."/xPanel"..PanSize,0.4,0.24,0.3,high,255,255,255,255,9999,0.25,0,0,userid,8100);
	_Hud.Text("ChatFont",0.42,0.25,255,80,0,255,9999,0.25,0,self.options[self.current[userid]].opt_name,0,userid,8100);
	
	_Hud.Rect("gmod/white",0.42,0.28,0.26,0.02,255,255,255,120,9999,0,0,0.25,userid,8101);
	
	for i=1, table.getn(self.options[self.current[userid]].panel) do
		
		local posy = 0.28 + (0.02 * (i-1));
		_Hud.Text("ChatFont",0.42,posy,255,255,255,255,9999,0.25,0,self.options[self.current[userid]].panel[i].popt_name,0,userid,8100+i);
		
	end
	
	self:DebugMsg("Opened panel xPanel::"..self.options[self.current[userid]].opt_name);
	
	self.pcurrent[userid] = 1;
	self.curPan[userid] = self.current[userid];

end

function ULib.XME:HidePanel(userid)

	if self.curPan[userid] == nil then return false; end; -- nothing to be closed.
	
	_GModRect_Hide(userid,8100,0.25,0);
	_GModRect_Hide(userid,8101,0.25,0);
	
	_GModText_Hide(userid,8100,0.25,0);
	
	for i=1, table.getn(self.options[self.curPan[userid]].panel) do
		_GModText_Hide(userid,8100+i,0.25,0);
	end
	
	self:DebugMsg("Closed panel xPanel::"..self.options[self.current[userid]].opt_name);
	
	self.curPan[userid] = nil;
	
end

function ULib.XME:IsAllowed(userid)

	local cur = self.current[userid];
	local acc = self.options[cur].opt_access;
	if acc == 0 then return true; end; -- 0 is no such limitation.
	
	local bool = false;
	if self.globalAccess ~= nil then
		bool = self.globalAccess( userid , acc );
		if bool == false then
			bool = self.access[acc].callback( userid, acc );
		end
	else
		bool = self.access[acc].callback(userid,acc);
	end
	
	return bool;

end

function ULib.XME:HandleEvent(eventType,index,activator)

	if eventType == "panel" then
		
		local callback  = self.options[self.current[activator]].panel[index].popt_callback;
		local arguments = self.options[self.current[activator]].panel[index].args;
		callback(index,arguments,activator);
		
		self:DebugMsg("HandleEvent called for Function::"..tostring(callback).."::"..self.options[self.current[activator]].panel[index].popt_name.." using panel method");
		
		return;
		
	end
	
	if eventType == "callback" then
	
		if self.options[index].opt_access ~= nil and not self:IsAllowed(activator) then
			_Hud.Text("ChatFont",0.745,(0.24 + 0.02 * (self.current[activator] - (self.top[activator] -1) -1)),255,80,0,255,9999,0,0,"[ Access Denied ]",0,activator,8001+self.current[activator]);
			AddTimer(1,1,self.ResetValueMenu,self,activator,self.current[activator]);
			return;
		end			
			
		local callback  = self.options[index].callback;
		local arguments = self.options[index].args;
		if callback ~= nil and arguments ~= nil then
			callback(index,arguments,activator);
		else
			self:DebugMsg("Nothing to be called for this option!");
		end
		
		self:DebugMsg("HandleEvent called for Function::"..tostring(callback).."::"..self.options[index].opt_name.." using callback method");
		
		return;
		
	end
	
	return false;

end

function ULib.XME:ResetValueMenu(userid,index)
	-- Color addon added by aVoN
	local color = {0,180,255,255};
	if(type(self.options[index].color) == "table") then
		if(table.getn(self.options[index].color) == 4) then
			color = self.options[index].color;
		end
	end
	_Hud.Text("ChatFont",0.745,(0.24 + 0.02 * (index - (self.top[userid] -1) -1)),color[1],color[2],color[3],color[4],9999,0,0,"["..index.."] "..self.options[index].opt_name,0,userid,8001+index);

end

function ULib.XME:ListenKeysIn(userid,in_key)

	if in_key == 8 then
		self:Move(userid,-1); -- Move pointer UP
	end

	if in_key == 16 then
		self:Move(userid,1); -- Move pointer DOWN
	end
	
	if in_key == 512 then
		if self.options[self.current[userid]].panel ~= nil then
			if self.curPan[userid] == nil then
				self:ShowPanel(userid); -- OpenPanel
			else
				self:HandleEvent("panel",self.pcurrent[userid],userid);
			end
		else
			self:HandleEvent("callback",self.current[userid],userid);
		end
	end
	
	if in_key == 1024 then
		if self.curPan[userid] == nil then
			self:Hide(userid);
		else
			self:HidePanel(userid);
		end
	end	

	-- if handles ~= nil then
		
		-- DoEvent(userid,in_key);
	
	-- end
	
end

function ULib.XME:DebugMsg(msg)

	if XMENU_DEBUG == true then
		_Msg("xMenu::"..self.menuname..": "..msg.."\n");
	end
	
end


--[[ TO BE FINISHED
	function xMenu:MakeDotMen()

		local str = "";
		local str = self.menuname.."::"..tostring(table.getn(self.options)).."\n";
		for i=1, table.getn(self.options) do
		
			if self.options[i].panel == nil then
				
				local Char = "C";
				local sep = "::";
				str = str..Char..sep..i..sep..self.options[i].opt_name..sep..self.options[i].opt_access.."\n";
				
			else
			
				local Char = "P";
				local sep = "::";
				str = str..Char..sep..i..sep..self.options[i].opt_name..sep..self.options[i].opt_access..sep..tostring(table.getn(self.options[i].panel)).."\n";
				
			end
			
		end
		_file.Write(self.menuname..".men",str);
		
	end
]]--
--[[ Listerner Event ]]--
	
function ListenKeys(userid,in_key)
	
	if ULib.XME.curMenu[userid] ~= nil then
		
		if XM_AUTO_SCROLL and ((_CurTime() - ULib.XME.curMenu[userid].keyIN) >= XM_AUTO_SCROLL_WAIT) then
			return; end;
		
		ULib.XME.curMenu[userid]:ListenKeysIn(userid,in_key);
		--ULib.XME.curMenu[userid]:DebugMsg("Player ["..userid.."] released key ["..in_key.."]"); -- Prodices ERROR.
		
	end
	
end

function ListenKeyPressed(userid,in_key)

	if ULib.XME.curMenu[userid] ~= nil then
		
		local now = _CurTime();
		ULib.XME.curMenu[userid].keyIN = now;
		
	end
	
end

function CheckAutoScroll(userid)

	if _PlayerIsKeyDown(userid,8) then
		ULib.XME.curMenu[userid]:ListenKeysIn(userid,8);
	end

	if _PlayerIsKeyDown(userid,16) then
		ULib.XME.curMenu[userid]:ListenKeysIn(userid,16);
	end
	
end

function ListenAutoScroll()

	for i=1, _MaxPlayers() do
		if _PlayerInfo(i,"connected") and ULib.XME.curMenu[i] ~= nil then
			if(ULib.XME.curMenu[i].keyIN) then
				if ((_CurTime() - ULib.XME.curMenu[i].keyIN) >= XM_AUTO_SCROLL_WAIT) then
					CheckAutoScroll(i);
				end
			end
		end
	end
	
end

local XM_AUTO_SCROLL_SET = false;
if XM_AUTO_SCROLL == true then
	if not XM_AUTO_SCROLL_SET then
		XM_AUTO_SCROLL_SET = true;
		AddTimer(XM_AUTO_SCROLL_DELAY,0,ListenAutoScroll);
	end
end

if KeyListener ~= nil then UnHookEvent(KeyListener); end; -- No double listening!
KeyListener = HookEvent("eventKeyReleased",ListenKeys);

if KeyInListener ~= nil then UnHookEvent(KeyInListener); end; -- No double listening!
KeyInListener = HookEvent("eventKeyPressed",ListenKeyPressed);
XMENU_BASE = true;