--[[

	#############################################
	
		VMF CopyGun - Entities and it's informations (Cache)
		
	#############################################
	
]]--
VMFCG.Entities = VMFCG.Entities or {};
VMFCG.Entities.pause_check = nil;

-- ##############  Constructor for EntityTable @aVoN

-- Dummy, which gets called on an disallowed entity for not making the script to break
VMFCG.Entities.Dummy = {};
setmetatable(VMFCG.Entities.Dummy,{__index=function() return function() end end});

setmetatable(
	VMFCG.Entities, 
	{__index = 
		function(t,n)
			if(type(n) == "number") then
				if(rawget(t,n) == nil) then
					if(VMFCG.Entities.Allowed(n) and n ~= 0) then
						local obj = VMFCG.Ent:GetById(n);
						local Etype = _EntGetType(n);
						rawset(VMFCG.Entities,n,obj);
						-- Debug section
						if(VMFCG.config.debug_position and VMFCG.config.debug) then
							if(_EntExists(n)) then
								local text_on_ent = n;
								if(string.find(Etype,"phys_") and Etype ~= "phys_magnet") then
									local has_parent = _EntGetParent(n);
									if(has_parent ~= 0) then
										text_on_ent = has_parent;
									end
								end
								_Hud.EntText("ChatFont",text_on_ent, vector3( 0, 0, 0 ),255,255,255,255,99999,0,0,Etype,0,0,(3000 + n));
							end
						end
						VMFCG.debug("VMFCG.Entities.__index","Entity (".. n ..":'"..Etype.."') Constructed");
						return obj;
					else
						return VMFCG.Entities.Dummy; -- Return the dummy
					end
				else
					return t[n];
				end
			end
		end
	}
);

-- ##############  Entity is in the VMF CopyGun Entity List? (boolean) @aVoN
function VMFCG.Entities.Exists(ent)
	if(rawget(VMFCG.Entities,ent) == nil) then
		return false;
	end
	return true;
end

-- ##############  Disallowed entitys (boolean) @aVoN
function VMFCG.Entities.Allowed(ent)
	local allow = true;
	-- Classname check
	local run = {VMFCG.config.disallowed_classnames,VMFCG.config.disallowed_models,VMFCG.config.disallowed_names};
	local run_functions = {_EntGetType,_EntGetModel,_EntGetName};
	for k,v in run do
		if(table.getn(v) ~= 0) then
			local check = run_functions[k](ent);
			if(check) then
				for _,vv in v do
					if(string.find(check,vv)) then
						allow = false;
						VMFCG.debug("VMFCG.Entities.Allowed","Got disallowed entity "..ent);
						break;
					end
				end
			end
		end
	end
	return allow;
end

-- ##############  Gets called, when an entity gets a different name, like it had before  and updates all other entitys, which refere to this one with the new name(void) @aVoN
function VMFCG.Entities.ChangeTargetName(id,new_name)
	if(VMFCG.Entities.Exists(id) and new_name ~= "") then
		local old_name = VMFCG.Entities[id]:GetKeyValue("targetname"); -- Fetch old name
		if(old_name ~= "") then
			-- So it has a targetname - Go threw all entities in the entity list and check for attachments to this entity, which may refere to it
			for k,v in VMFCG.Entities do
				if(type(k) == "number") then
					-- This entity is not the current one to check :P
					if(k ~= id) then
						-- Fetch targetname related key/values
						for _,name in VMFCG.defines.fixup.targetnames do
							local value = v:GetKeyValue(name);
							if(value ~= "") then
								-- Heureka, this k/v is set!
								if(value == old_name) then
									-- And it matches the old targetname - Do the fixup now!
									v:SetKeyValue(name,new_name);
								end
							end
						end
						local connections = v:GetConnections();
						if(table.getn(connections) > 0) then
							for k,con in connections do
								-- And replace old with new name too  in the connections ;)
								connections[k].value = string.gsub(connections[k].value,old_name,new_name);
							end
							v:SetAllConnections(connections); -- And reapply them :D
						end
					end
				end
			end
		end
	end
end

-- ##############  Returns the id of an entity. Input can be a string or integer (The entity ID OR it's name) (integer) @aVoN
function VMFCG.Entities.getEntId(e)
	if(not tonumber(e) and e ~= "") then
		local et = _EntitiesFindByName(e);
		if(table.getn(et) == 0) then
			return 0; -- No entity found
		else
			return unpack(et); -- Multiple entities
		end
	end
	return tonumber(e) or 0;
end

-- ##############  Checks for additional entitys, which are linked by connections (table) @aVoN
function VMFCG.Entities.ConnectionDependency(entities)
	local t = {};
	t[0] = true; -- The world (when something is welded to the world :D)
	for _,v in entities do
		t[tonumber(v)] = true;
	end
	local r = {};
	for _,v in entities do
		if(VMFCG.Entities.Exists(v)) then
			if(not VMFCG.Entities[v]:HasKey("model")) then -- Only add relatd entity, when it is non-selectable, which normally means, it hasnt got a model
				local connections = VMFCG.Entities[v]:GetConnections();
				for _,con in connections do
					local seperator = string.find(con.value,",");
					if(seperator) then
						local search_name = string.sub(con.value,1,seperator-1);
						if(string.sub(search_name,1,1) ~= "!") then
							local ids = {VMFCG.Entities.getEntId(VMFCG.trim(search_name))};
							if(ids[1] ~= 0) then
								for _,id in ids do
									if(not t[id]) then
										t[id] = true;
										table.insert(r,id);
									end
								end
							end
						end
					end
				end
			end
		end
	end
	return VMFCG.unique(r);
end

-- ##############  Checks for additional entitys, which are linked to the current entitys (table) @aVoN
--[[  Input: table of all currently selected entities]]
function VMFCG.Entities.dependency(entities)
	local t = {};
	t[0] = true; -- The world (when something is welded to the world :D)
	for _,v in entities do
		t[tonumber(v)] = true;
	end
	local	r = {}; -- Return table
	for k,v in VMFCG.Entities do
		if(type(k) == "number") then
			if(t[k] == nil) then -- It hasn't got added - So check this ent, if it's maybe dependet to anything else
				local done = false;
				local parent = v:GetParent(); -- Parent id
				local attach1 = VMFCG.Entities.getEntId(v:GetKeyValue("attach1")); -- Attachpoints
				local attach2 = VMFCG.Entities.getEntId(v:GetKeyValue("attach2")); -- Attachpoints
				local next_key = VMFCG.Entities.getEntId(v:GetKeyValue("NextKey")); -- For ropes
				-- ############## Normal attachments. E.g. two welded props got selected - Select weldentity!
				if((attach1 == 0 and attach2 ~= 0) or (attach1 ~= 0 and attach2 == 0) or (attach1 ~= 0 and attach2 ~= 0)) then -- Why does Lua didnt know XOR ?
					if(t[attach1] and t[attach2]) then
						VMFCG.debug("VMFCG.Entities.dependency","Got dependency (attach1/2) of "..k.." to "..attach1.." and "..attach2);
						table.insert(r,k);
						done = true;
					end
				end
				-- ############## NextKey entity. Needed Endpoint entitys for ropes
				if(not done) then
					if(t[next_key] and t[parent] and next_key ~= 0) then
						VMFCG.debug("VMFCG.Entities.dependency","Got dependency (rope NextKey) of "..k.." to "..next_key);
						table.insert(r,k);
						done = true;
					end
				end
				-- ############## Killhirarchie - Entitys, which are linked to one of the entitys in the list and get removed, when this entity is removed
				if(not done) then
					local killhierarchy = VMFCG.Entities.getEntId(v:GetKeyValue("_killhierarchy"));
					if(t[killhierarchy] and killhierarchy ~= 0) then
						VMFCG.debug("VMFCG.Entities.dependency","Got dependency (_killhierarchy) of "..k.." to "..killhierarchy);
						table.insert(r,k);
						done = true;
					end
				end
				-- ############## Connection/OutPuts for checking
				if(not done) then
					if(not v:HasKey("model")) then -- Only select connections, when they don't have a model (like info_*,trigger_* and math_ entitys)
						local connections = v:GetConnections();
						for _,v in connections do
							local found = string.find(v.value,",");
							if(found) then
								local cur_output_entity = VMFCG.Entities.getEntId(VMFCG.trim(string.sub(v.value,1,found-1)));
								if(cur_output_entity ~= 0 and t[cur_output_entity]) then
									table.insert(r,k);
									done = true;
									break;
								end
							end
						end
					end
				end
				-- ############## SourceEntity key/value checking
				if(not done) then
					local SourceEntityName = VMFCG.Entities.getEntId(v:GetKeyValue("SourceEntityName"));
					if(SourceEntityName ~= 0 and t[SourceEntityName]) then
						table.insert(r,k);
						done = true;
					end
				end
				-- ############## Parented entitys
				if(not done) then
					-- Only adds parented entitys when their NextKey is empty or the entity in NextKey exists (for ropes) or when both attached entitys are selected or both are empty too
					if(t[parent] and parent ~= 0 and (t[next_key]) and ((t[attach1] and t[attach2]) or (attach1 == 0 and attach2 == 0))) then
						VMFCG.debug("VMFCG.Entities.dependency","Got dependency (parent) of "..k.." to "..parent);
						table.insert(r,k);
					end
				end
			end
		end
	end
	-- Connection dependency
	r = VMFCG.merge(r,VMFCG.Entities.ConnectionDependency(VMFCG.unique(VMFCG.merge(entities,r))));
	if(table.getn(r) ~= 0) then
		local check = VMFCG.unique(VMFCG.merge(entities,r));
		local tmp = VMFCG.Entities.dependency(check); -- Get other dependencys recursivly
		r = VMFCG.merge(r,tmp);
	end
	-- Remove duplicates
	return VMFCG.values(VMFCG.unique(r));
end

-- ##############  Checks for entitys, which are linked (by e.g. welds) to this entity - Not the same as the dependency function above (table)  @aVoN
function VMFCG.Entities.link(entities)
	local r = {};
	local found = {};
	for _,v in entities do
		found[v] = true;
	end
	for _,ent in entities do
		for k,v in VMFCG.Entities do
			if(type(k) == "number") then
				if(not found[k]) then
					local attach1 = VMFCG.Entities.getEntId(v:GetKeyValue("attach1"));
					local attach2 = VMFCG.Entities.getEntId(v:GetKeyValue("attach2"));
					-- Add attach2 entity
					if(attach1 == ent) then
						if(attach2 ~= 0 and not found[attach2]) then
							table.insert(r,attach2);
							found[k] = true;
						end
					end
					-- Add attach2 entity
					if(attach2 == ent) then
						if(attach1 ~= 0 and not found[attach1]) then
							table.insert(r,attach1);
							found[k] = true;
						end
					end
				end
			end
		end
	end
	if(table.getn(r) > 0) then
		local recursive_r = VMFCG.Entities.link(VMFCG.unique(VMFCG.merge(r,entities)));
		r = VMFCG.unique(VMFCG.merge(r,recursive_r));
	end
	return r;
end

-- ############## Copys all keyvalues from one entity to this one [Needs the entity list in vmfcg_entities] (void)  @aVoN
function VMFCG.Entities.CopyKeyValues(ent1,ent2,...)
	if((_EntExists(ent1) or VMFCG.Entities.Exists(ent1)) and (_EntExists(ent2) or VMFCG.Entities.Exists(ent2))) then
		local kv = VMFCG.Entities[ent1]:GetAllKeyValues();
		local this_kv = VMFCG.Entities[ent2]:GetAllKeyValues();
		for k,v in arg do
			if(k ~= "n") then
				if(not this_kv[v]) then
					kv[v] = nil;
				else
					kv[v] = this_kv[v];
				end
			end
		end
		VMFCG.debug("VMFCG.Entities:CopyKeyValues","Copied key/values from "..ent1.." to "..ent2);
		VMFCG.Entities[ent2]:SetAllKeyValues(kv);
		VMFCG.Entities[ent2]:ApplyKeyValues();
	end
end

-- ##############  Non Existance Check by addtimers (void) @aVoN
function VMFCG.Entities.check_for_existance()
	if(VMFCG.Entities.pause_check ~= true) then
		for k,_ in VMFCG.Entities do
			if(type(k) == "number") then
				VMFCG.Entities.KillEnt(0,k,false);
			end
		end
	end
end

-- ##############  Remover Event (void) @aVoN
function VMFCG.Entities.KillEnt(userid,ent,override)
	if(VMFCG.Entities.Exists(ent) and ent ~= 0) then
		local kill = false;
		local reason = "";
		-- Check for real existance
		if(not _EntExists(ent) or override) then
			if(_EntExists(ent) == false) then
				-- Im checking it two times, because soemtimes, entitys get randomly deleted, even when they still exists. Maybe this helps :(
				reason = reason.."non-Existance,";
				kill = true;
			end
		end
		local killhierarchy = VMFCG.Entities[ent]:GetKeyValue("_killhierarchy");
		local killhierarchy_id = VMFCG.Entities.getEntId(killhierarchy);
		if(killhierarchy ~= "") then
			if(not _EntExists(killhierarchy_id)) then
				reason = reason.."killhierarchy,";
				kill = true;
				--return false;  -- Deactivated because of some problems right now
			end
		end
		-- Check for attach1/attach2 dependency (if the attach1/2 entities still exist or not)
		if(not kill) then
			local attach1 = VMFCG.Entities[ent]:GetKeyValue("attach1");
			local attach2 = VMFCG.Entities[ent]:GetKeyValue("attach2");
			local string_key1 = false; -- Is the key a string? If yes, even allow "0" as ent_id
			local string_key2 = false; -- Is the key a string? If yes, even allow "0" as ent_id
			if(attach1 ~= "" and attach2 ~= "") then
				if(not tonumber(attach1)) then
					string_key1 = true;
					attach1 = _EntGetByName(attach1);
				end
				if(not tonumber(attach2)) then
					string_key2 = true;
					attach2 = _EntGetByName(attach2);
				end
				attach1 = tonumber(attach1);
				attach2 = tonumber(attach2);
				if((not _EntExists(attach1) and (attach1 ~= 0 or string_key1)) or (not _EntExists(attach2) and (attach2 ~= 0 or string_key2))) then
					reason = reason.."Attachments,";
					kill = true;
				end
			end
		end
		if(kill) then
			if(VMFCG.config.debug_position) then
				_GModText_Hide(0, 3000 + ent);
			end
			VMFCG.debug("VMFCG.Entities.KillEnt","Deleted Entity "..ent.." (".. VMFCG.Entities[ent]:GetClass() ..") from index VMFCG.Entities - Reason: "..reason);
			if(_EntExists(ent) and not override) then
				_EntRemove(ent); -- And kill it again (if it still exists)
			end
			VMFCG.Entities[ent] = nil;
		end
	end
end


-- #############################################
-- ################### Init #######################
-- #############################################

VMFCG.AddTimerOnce("VMFCG.Entities.check_for_existance",1,0,VMFCG.Entities.check_for_existance);
VMFCG.HookOnce("onPlayerRemove",VMFCG.Entities.KillEnt,"VMFCG.Entities.KillEnt");