--[[

	#############################################
	
		VMF CopyGun - Ini file parser
		
	#############################################
	
]]--

VMFCG.INIParser = {};

-- ############## Loads an ini file (object) @ aVoN
function VMFCG.INIParser:new(file)
	local obj = {};
	setmetatable(obj,self);
	self.__index = function(t,n)
		local nodes = rawget(t,"nodes");
		if(nodes) then
			if(nodes[n]) then
				return nodes[n];
			end
		end
		return self[n]; -- Returns self or the nodes if directly indexed
	end
	if(_file.Exists(file)) then
		obj.file = file;
		obj.content = _file.Read(file); -- Saves raw content of the file
		obj.nodes = {}; -- Stores all nodes of the ini
	else
		VMFCG.debug("VMFCG.INIParser:new","File "..file.." does not exist!");
		return;
	end
	obj:parse();
	return obj;
end

-- ############## Strips comments from a line(string) @ aVoN
function VMFCG.INIParser:StripComment(line)
	local found_comment = string.find(line,";");
	if(found_comment) then
		line = string.sub(line,1,found_comment-1); -- Removes any non neccessayry stuff
	end
	return line;
end

-- ############## Strips quotes from a string (when an idiot added them...) (string) @ aVoN
function VMFCG.INIParser:StripQuotes(s)
	-- Replaces accidently added quotes from alphanumerical strings
	return string.gsub(s,"^[\"'](.+)[\"']$","%1");
end

-- ############## Parses the inifile to a table (table) @ aVoN
function VMFCG.INIParser:parse()
	local exploded = VMFCG.explode(self.content,"\n");
	local nodes = {};
	local cur_node = "";
	local cur_node_index = 1;
	for k,v in exploded do
		local line = VMFCG.trim(self:StripComment(v));
		if(line ~= "") then -- Only add lines with contents (no commented lines)
			if(string.sub(line,1,1) == "[") then -- Holy shit, it's a node
				local node_end = string.find(line,"%]");
				if(node_end) then
					local node = string.sub(line,2,node_end-1); -- Get single node name
					nodes[node] = nodes[node] or {};
					cur_node = node;
					cur_node_index = table.getn(nodes[node])+1;
				else
					VMFCG.debug("VMFCG.INIParser:parse","Parse error in file "..self.file.. " at line "..k.." near \""..line.."\": Expected node!");
					self = nil;
					return;
				end
			else
				if(cur_node == "") then
					VMFCG.debug("VMFCG.INIParser:parse","Parse error in file "..self.file.. " at line "..k.." near \""..line.."\": No node specified!");
					self = nil;
					return;
				else
					local data = VMFCG.explode(line,"=",1);
					if(table.getn(data) == 2) then
						local key = self:StripQuotes(VMFCG.trim(data[1]));
						local value = self:StripQuotes(VMFCG.trim(data[2]));
						nodes[cur_node][cur_node_index] = nodes[cur_node][cur_node_index] or {};
						nodes[cur_node][cur_node_index][key] = value;
					else
						VMFCG.debug("VMFCG.INIParser:parse","Parse error in file "..self.file.. " at line "..k.." near \""..line.."\": No datablock specified!");
						self = nil;
						return;
					end
				end
			end
		end
	end
	self.nodes = nodes;
	VMFCG.debug("VMFCG.INIParser:parse","File "..self.file.. " successfully parsed");
end
