--[[

	#############################################
	
		VMF CopyGun - Selection part
		
	#############################################
	
]]--

VMFCG.selection = VMFCG.selection or {};
VMFCG.selection.users = VMFCG.selection.users or {};
VMFCG.selection.disallowed_entities= {"func_","ambient_","info_","beam","_rope","phys_","env_","trigger_","math_","logic_"}; -- These entitiys are not allowed in quad/sphere select to get added by the script automaticly

for i=1,_MaxPlayers() do
	VMFCG.selection.users[i] = VMFCG.selection.users[i] or {};
	VMFCG.selection.users[i].entities = VMFCG.selection.users[i].entities or {};
	VMFCG.selection.users[i].session = VMFCG.selection.users[i].session or {};
	VMFCG.selection.users[i].colorized = VMFCG.selection.users[i].colorized or false;
	VMFCG.selection.users[i].hud = VMFCG.selection.users[i].hud or 	VMFCG.Hud:new(i);
	VMFCG.selection.users[i].last_selection = 0;
end


-- #############################################
-- ############### Generel selection functions ##############
-- #############################################


-- ############## Returns true, if an entity is made for saving or not (boolean) @aVoN
function VMFCG.selection.Allowed(userid,v)
	if(not VMFCG.Entities.Allowed(v)) then return false end; -- General disallowed entitys
	if(not VMFCG.RightsManager.hasAccess(userid,VMFCG.defines.ALLOW_SELECTING_OF_ALL_PROPS)) then
		-- PropProtector wrapper
		if(not VMFCG.PropProtector_AllowedToUseEntity(userid,v)) then
			return false;
		end
	end
	local ent_type = _EntGetType(v);
	local parent = _EntGetParent(v);
	if(parent) then
		if(IsPlayer(parent)) then return false end; -- Weapons, holded py players
	end
	if(ent_type ~= "phys_magnet") then -- Its the only phys entity, which is allowed to add
		for _,v in VMFCG.selection.disallowed_entities do
			if(string.find(ent_type,v)) then
				VMFCG.debug("VMFCG.selection.Allowed","Entity "..v.." is an disallowed entity ("..ent_type..")");
				return false;
			end
		end
	end
	if(string.find(_EntGetModel(v),"*") or (_EntGetModel(v) == "models/weapons/w_bugbait.mdl" and _EntGetType(v) == "prop_physics")) then return end; -- Brushes and unused attach bugbaits!
	return true;
end

-- ############## Returns, if an entity is selected or not (boolean) @aVoN
function VMFCG.selection.Selected(userid,ent)
	for _,v in VMFCG.selection.users[userid].entities do
		if(v == ent) then
			return true;
		end
	end
	return false;
end

-- ############## Returns the ammount of selected props of a player
function VMFCG.selection.Ammount(userid)
	return VMFCG.count(VMFCG.selection.users[userid].entities);
end

-- ############## Deselects all entites (void) @aVoN
function VMFCG.selection.DeselectAll(userid,gun)
	if(userid == 0) then return end;
	VMFCG.selection.UpdateHud(userid);
	VMFCG.selection.ColorizeAll(userid,false);
	VMFCG.selection.users[userid].entities = {}; -- Resetting table
	-- ############## Preview handling and resetting
	VMFCG.SaveLoad.users[userid].spawn_height = 0;
	VMFCG.SaveLoad.users[userid].spawn_angle = 0;
	VMFCG.SaveLoad.CreateSaveObject(userid);
	VMFCG.SaveLoad.SpawnPreview(userid,false)
	_EntEmitSound(userid,"vehicles/atv_ammo_open.wav");
	VMFCG.debug("VMFCG.selection.DeselectAll","Deselecting all ents for "..userid);
end

-- ############## (de)selects an entity (void) @aVoN
function VMFCG.selection.Select(userid)
	if(userid == 0) then return end;
	local t = VMFCG.TraceLine:NewUser(userid);
	local ent = t:GetEnt();
	if(ent ~= 0) then
		if(not VMFCG.selection.Selected(userid,ent)) then
			if(VMFCG.selection.Allowed(userid,ent)) then
				VMFCG.selection.SetHitEffect(t);
				_EntEmitSound(userid,"Airboat.FireGunRevDown");
				local max_select = tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_SAVE_AMMOUNT)) or 0;
				if(VMFCG.selection.Ammount(userid) >= max_select and max_select ~= 0) then 
					VMFCG.Hud.Message(userid,"                       You can only select "..max_select.." props for a copy");
					return false;
				end
				VMFCG.SaveLoad.SpawnPreview(userid,false); -- Disable preview for a moment
				-- And only respawn it after a certain timeout, so it won't interfere with the selection
				VMFCG.AddTimerOnce("VMFCG.SaveLoad.SpawnPreview:"..userid,1,1,VMFCG.SaveLoad.SpawnPreview,userid,true);
				table.insert(VMFCG.selection.users[userid].entities,ent);
				VMFCG.selection.users[userid].last_selection = _CurTime();
				VMFCG.selection.Colorize(ent,true);
				VMFCG.debug("VMFCG.selection.Select","Selected entity "..ent);
			end
		else
			if(VMFCG.selection.users[userid].last_selection + 0.5 <= _CurTime()) then
				VMFCG.SaveLoad.SpawnPreview(userid,false); -- Disable preview for a moment
				-- And only respawn it after a certain timeout, so it won't interfere with the selection
				VMFCG.AddTimerOnce("VMFCG.SaveLoad.SpawnPreview:"..userid,1,1,VMFCG.SaveLoad.SpawnPreview,userid,true);
				VMFCG.selection.SetHitEffect(t);
				_EntEmitSound(userid,"Airboat.FireGunRevDown");
				for k,v in VMFCG.selection.users[userid].entities do
					if(v == ent) then
						VMFCG.selection.users[userid].entities[k] = nil;
						VMFCG.selection.Colorize(ent,false);
						VMFCG.debug("VMFCG.selection.Select","Deselected entity "..ent);
						break;
					end
				end
				if(VMFCG.selection.Ammount(userid) == 0) then
					-- ############## Reset spawnangles and height!
					VMFCG.SaveLoad.CreateSaveObject(userid);
					VMFCG.SaveLoad.users[userid].spawn_height = 0;
					VMFCG.SaveLoad.users[userid].spawn_angle = 0;
				end
			end
		end
	end
	VMFCG.selection.UpdateHud(userid);
end

-- ############## Smart Selection beta (void) @ aVoN
function VMFCG.selection.SmartSelect(userid,select)
	if(userid == 0) then return end;
	local t = VMFCG.TraceLine:NewUser(userid);
	local ent = t:GetEnt();
	if(ent ~= 0) then
		VMFCG.selection.SetHitEffect(t);
		_EntEmitSound(userid,"Airboat.FireGunRevDown");
		local entities = VMFCG.merge({ent},VMFCG.Entities.link({ent})); -- Add self to the very beginning and then the rest
		if(select) then
			for _,ent in entities do
				if(VMFCG.selection.Allowed(userid,ent)) then
					if(not VMFCG.selection.Selected(userid,ent)) then
						local max_select = tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_SAVE_AMMOUNT)) or 0;
						if(VMFCG.selection.Ammount(userid) >= max_select and max_select ~= 0) then 
							VMFCG.Hud.Message(userid,"                       You can only select "..max_select.." props for a copy");
							break;
						end
						table.insert(VMFCG.selection.users[userid].entities,ent);
						VMFCG.selection.Colorize(ent,true);
						VMFCG.debug("VMFCG.selection.SmartSelect","Selected entity "..ent);
					end
				end
			end
		else
			for _,ent in entities do
				for k,v in VMFCG.selection.users[userid].entities do
					if(v == ent) then
						VMFCG.selection.users[userid].entities[k] = nil;
						VMFCG.selection.Colorize(ent,false);
						VMFCG.debug("VMFCG.selection.SmartSelect","Deselected entity "..ent);
						break;
					end
				end
				if(VMFCG.selection.Ammount(userid) == 0) then
					-- ############## Reset spawnangles and height!
					VMFCG.SaveLoad.CreateSaveObject(userid);
					VMFCG.SaveLoad.users[userid].spawn_height = 0;
					VMFCG.SaveLoad.users[userid].spawn_angle = 0;
				end
			end
		end
		VMFCG.selection.UpdateHud(userid);
	end
end

-- #############################################
-- ############### Sphere Selection ###################
-- #############################################


-- ############## Shows/Hides sphere-select sprite (void) @aVoN
function VMFCG.selection.SphereSprite(userid,show)
	if(userid == 0) then return end;
	local session = VMFCG.selection.users[userid].session;
	if(show) then
		if(session.pos1 ~= nil and session.pos2 ~= nil) then
			local newScale = math.ceil(vecLength(vecSub(session.pos1,session.pos2))/35);
			local Sprite = _EntCreate("env_sprite");
			_EntSetPos(Sprite, session.pos1);
			VMFCG.core._EntSetName(Sprite, "SphereSelect");
			VMFCG.core._EntSetKeyValue(Sprite, "spawnflags", "1");
			VMFCG.core._EntSetKeyValue(Sprite, "model", "sprites/blueglow1.vmt");
			VMFCG.core._EntSetKeyValue(Sprite, "scale", newScale);
			VMFCG.core._EntSetKeyValue(Sprite, "rendermode", "5");
			VMFCG.core._EntSetKeyValue(Sprite, "rendercolor", "162 162 255");
			_EntSpawn(Sprite);
			session.sprite = Sprite;
			VMFCG.debug("VMFCG.selection.SphereSprite","Created sphereselect sprite "..Sprite);
		end
	else
		if(session.sprite ~= nil and _EntGetName(session.sprite) == "SphereSelect") then
			_EntRemove(session.sprite);
			VMFCG.debug("VMFCG.selection.SphereSprite","Deleted sphereselect sprite "..session.sprite);
			session.sprite = nil;
		end
	end
	VMFCG.selection.users[userid].session = session;
end

-- ############## Handles sphere select tool (void) @aVoN
function VMFCG.selection.SphereSelect(userid)
	if(userid == 0) then return end;
	local t = VMFCG.TraceLine:NewUser(userid);
	local session = VMFCG.selection.users[userid].session;
	session.stage = session.stage or 0;
	VMFCG.selection.SetHitEffect(t);
	if(session.stage == 0) then
		session.pos1 = t:EndPos();
		session.stage = session.stage + 1;
		VMFCG.selection.SphereSprite(userid,false);
	else
		session.pos2 = t:EndPos();
		session.stage = 0;
		VMFCG.selection.SphereSprite(userid,true);
	end
	VMFCG.selection.users[userid].session = session;
end

-- ############## (de)selects several entities (void) @aVoN
function VMFCG.selection.SelectEntitiesInSphere(userid)
	if(userid == 0) then return end;
	local session = VMFCG.selection.users[userid].session;
	local pos = session.pos1;
	if(session.pos1 and session.pos2) then
		local radius = vecLength(vecSub(session.pos1,session.pos2));
		for _,v in _EntitiesFindInSphere(pos,radius) do
			if(VMFCG.selection.Allowed(userid,v) and not VMFCG.selection.Selected(userid,v)) then
				local max_select =  tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_SAVE_AMMOUNT)) or 0;
				if(VMFCG.selection.Ammount(userid) >= max_select and max_select ~= 0) then 
					break;
				end;
				table.insert(VMFCG.selection.users[userid].entities,v);
				VMFCG.selection.Colorize(v,true);
				VMFCG.debug("VMFCG.selection.SelectEntitiesInSphere","Selecting ents in sphere for user "..userid);
			end
		end
		VMFCG.SaveLoad.CreateSaveObject(userid); -- And update for saveload
	end
end


-- #############################################
-- ############### Quad Selection ####################
-- #############################################


-- ############## QuadSelect drawer (void) @aVoN
function VMFCG.selection.QuadDraw(userid,drawnow)
	if(VMFCG.selection.users[userid]) then
		local session = VMFCG.selection.users[userid].session;
		if(not session.pos) then
			VMFCG.HaltTimerOnce( "VMFCG.selection.QuadDraw:"..userid );
			VMFCG.selection.users[userid].session = {};
		else
			local pang = _PlayerGetShootAng(userid);
			local scale = math.abs((1-vecDotProduct(pang,session.player_ang)))*2000 + 50;
			session.old_scale = session.old_scale or 50;
			if(scale ~= session.old_scale or drawnow) then -- Only draw, when it got changed
				session.old_scale = scale;
				session.length = session.length or 50;
				session.width = session.width or 50;
				session.height = session.height or 50;
				if(session.stage == 1) then
					session.width = scale;
				end
				if(session.stage == 2) then
					session.length = scale;
				end
				if(session.stage == 3) then
					session.height = scale;
				end
				VMFCG.QuadBox(userid*10,0,"RD/barrierglow",session.pos,session.width,session.length,session.height,99999);
				VMFCG.QuadBox(userid*10+600,0,"gmod/Wireframe",session.pos,session.width,session.length,session.height,99999);
			end
		end
	end
end

-- ############## Kills the quaddrawing timer (void) @aVoN
function VMFCG.selection.QuadKill(userid)
	if(userid == 0) then return end;
	VMFCG.HaltTimerOnce( "VMFCG.selection.QuadDraw:"..userid );
	_GModQuad_Hide(0,userid*10+1);
	_GModQuad_Hide(0,userid*10+2);
	_GModQuad_Hide(0,userid*10+3);
	_GModQuad_Hide(0,userid*10+4);
	_GModQuad_Hide(0,userid*10+5);
	_GModQuad_Hide(0,userid*10+6);
	
	_GModQuad_Hide(0,userid*10+1+600);
	_GModQuad_Hide(0,userid*10+2+600);
	_GModQuad_Hide(0,userid*10+3+600);
	_GModQuad_Hide(0,userid*10+4+600);
	_GModQuad_Hide(0,userid*10+5+600);
	_GModQuad_Hide(0,userid*10+6+600);
	VMFCG.debug("VMFCG.selection.QuadKill","Killed Quad for user "..userid);
end

-- ############## QuadSelect caller (void) @aVoN
function VMFCG.selection.QuadSelect(userid)
	if(userid == 0) then return end;
	local t = VMFCG.TraceLine:NewUser(userid);
	local session = VMFCG.selection.users[userid].session;
	if(session.stage == 0 or not session.stage) then
		VMFCG.selection.SetHitEffect(t);
		session = {};
		VMFCG.AddTimerOnce( "VMFCG.selection.QuadDraw:"..userid , 0.1 , 0 , VMFCG.selection.QuadDraw , userid );
		session.pos = t:EndPos();
	end
	session.stage = session.stage or 0;
	session.player_ang = _PlayerGetShootAng(userid);
	session.stage = session.stage + 1;
	if(session.stage == 4) then
		VMFCG.HaltTimerOnce( "VMFCG.selection.QuadDraw:"..userid );
		session.stage = nil;
	end
	VMFCG.selection.users[userid].session = session;
end

-- ############## QuadSelect drawer (void) @aVoN
function VMFCG.selection.QuadSelectEntities(userid)
	-- In reality, the QuadSelect is nothing else than a sphereselect, but with some additional vector calculation.
	local session = VMFCG.selection.users[userid].session;
	if(session.pos) then
		session.length = session.length or 50;
		session.width = session.width or 50;
		session.height = session.height or 50;
		local quad_sizes = vector3(session.length/2+10,session.width/2+10,session.height+10);
		local radius = vecAdd(session.pos,quad_sizes);
		for _,v in _EntitiesFindInSphere(session.pos,vecLength(quad_sizes)) do
			if(VMFCG.selection.Allowed(userid,v) and not VMFCG.selection.Selected(userid,v)) then
				local ePos = _EntGetPos(v);
				if(ePos.x <= session.pos.x+quad_sizes.x and ePos.x >= session.pos.x-quad_sizes.x and ePos.y <= session.pos.y+quad_sizes.y and ePos.y >= session.pos.y-quad_sizes.y and ePos.z <= session.pos.z+quad_sizes.z and ePos.z >= session.pos.z-quad_sizes.z) then
					local max_select =  tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_SAVE_AMMOUNT)) or 0;
					if(VMFCG.selection.Ammount(userid) >= max_select and max_select ~= 0) then 
						break;
					end;
					table.insert(VMFCG.selection.users[userid].entities,v);
					VMFCG.selection.Colorize(v,true);
					VMFCG.debug("VMFCG.selection.QuadSelectEntities","Selecting Entity "..v.." in Quad for "..userid);
				end
			end
		end
		if(VMFCG.config.debug_position and VMFCG.config.debug) then
			_EffectInit();
			_EffectSetEnt(0);
			_EffectSetStart(session.pos);
			_EffectSetOrigin(radius);
			_EffectSetScale(5);
			_EffectSetMagnitude(4);
			_EffectDispatch("FadingLineTeam");
		end
	end
	VMFCG.SaveLoad.CreateSaveObject(userid); -- And update for saveload
end


-- #############################################
-- ############### Effects and Color ###################
-- #############################################


-- ############## Shows hiteffect (Gmod10 like) (void) @aVoN
function VMFCG.selection.SetHitEffect(traceline)
	-- Standard effect
	_EffectInit()
	_EffectSetEnt(userid)
	_EffectSetOrigin(traceline:EndPos())
	_EffectSetScale(1)
	_EffectSetMagnitude(5)
	_EffectSetNormal(traceline:GetSurfaceNormal())
	_EffectDispatch("AR2Impact")
	
	-- Gmod10 Effect lookalike - Idea by Jinto, texture by Jinto, QuadCode by Jinto, VectorPart by me (aVoN), because he used another way with an entity and _EntGetForwardvector() etc
	local normal = traceline:GetSurfaceNormal();
	local endpos = traceline:EndPos();
	
	-- Two perpendicular vectors to the surface nornam vector
	local check_point = vecNormalize(vecCrossProduct(normal,vector3(1,1,1)));
	local check_point2 = vecNormalize(vecCrossProduct(normal,vecCrossProduct(normal,vector3(1,1,1))));
	
	local random = math.random(0,1337);
	
	--Start Quad
	VMFCG.Quad(120+random,0,"toolgun_impacteffect",
		vecAdd( vecAdd( endpos, vecMul( check_point, 4 ) ), vecMul( check_point2, 4 ) ),
		vecAdd( vecAdd( endpos, vecMul( check_point, 4 ) ), vecMul( check_point2, -4 ) ),
		vecAdd( vecAdd( endpos, vecMul( check_point, -4 ) ), vecMul( check_point2, -4 ) ),
		vecAdd( vecAdd( endpos, vecMul( check_point, -4 ) ), vecMul( check_point2, 4 ) ),
	0.2,0,0);
	-- End Quad with animation
	VMFCG.QuadAnimate(120+random,0,"toolgun_impacteffect",
		vecAdd( vecAdd( endpos, vecMul( check_point, 16 ) ), vecMul( check_point2, 16 ) ),
		vecAdd( vecAdd( endpos, vecMul( check_point, 16 ) ), vecMul( check_point2, -16 ) ),
		vecAdd( vecAdd( endpos, vecMul( check_point, -16 ) ), vecMul( check_point2, -16 ) ),
		vecAdd( vecAdd( endpos, vecMul( check_point, -16 ) ), vecMul( check_point2, 16 ) ),
	0.2,0,0,0.1,0.1);
	
	-- The Beam
	-- Get the muzzleposition
	local shootpos = _PlayerGetShootPos(traceline.ignore);
	local shootang = _PlayerGetShootAng(traceline.ignorer);
	local vright = _EntGetRightVector(traceline.ignore);

	shootpos = vecAdd( shootpos, vector3(0,0,-20));
	local muzzlepos =  vecAdd( shootpos, vecMul( vright, vector3(15,15,0)))

	local beamStart = _EntCreate( "info_target" );
	_EntSetPos( beamStart, muzzlepos );
	_EntSetName( beamStart, "beamStart"..traceline.ignore );
	_EntSpawn(beamStart);
	
	local beamEnd = _EntCreate( "info_target" );
   _EntSetPos( beamEnd, _TraceEndPos() );
   _EntSetName( beamEnd, "beamEnd"..traceline.ignore );
   _EntSpawn(beamEnd);
   
	local Beam = _EntCreate( "env_beam" );
   _EntPrecacheModel("sprites/physbeam.spr");
   _EntSetKeyValue( Beam, "texture", "sprites/physcannon_bluelight1b.vtf" );
   _EntSetKeyValue( Beam, "renderamt", 255 );
   _EntSetKeyValue( Beam, "rendercolor", "255 255 255" );
   _EntSetKeyValue( Beam, "life", 0.2 );
   _EntSetKeyValue( Beam, "damage", 0 );
   _EntSetKeyValue( Beam, "LightningStart", "beamStart"..traceline.ignore );
   _EntSetKeyValue( Beam, "LightningEnd", "beamEnd"..traceline.ignore );
   _EntSetKeyValue( Beam, "spawnflags", 1 );
   _EntSetKeyValue( Beam, "TouchType", 0 );
   _EntSetKeyValue( Beam, "framestart", 0 );
   _EntSetKeyValue( Beam, "framerate", 0 );
   _EntSetKeyValue( Beam, "NoiseAmplitude", 0.5 );
   _EntSetKeyValue( Beam, "TextureScroll", 35 );
   _EntSetKeyValue( Beam, "BoltWidth", 1 );
   _EntSetKeyValue( Beam, "Radius", 256 );
   _EntSetKeyValue( Beam, "StrikeTime", 1 );
   
   _EntSpawn(Beam);
   
   _EntFire(Beam, "turnon", "", "");
   _EntFire(Beam, "kill", "", 0.2);
   _EntFire(beamStart, "kill", "", 0.2);
   _EntFire(beamEnd, "kill", "", 0.2);
	
	
end

-- ############## Colorize/decolorize an entity (void) @aVoN
function VMFCG.selection.Colorize(ent,colorize)
	if(colorize) then
		VMFCG.core._EntSetMaterial(ent,"models/debug/debugwhite");
		VMFCG.core._EntSetKeyValue(ent,"renderamt","255");
		VMFCG.core._EntSetKeyValue(ent,"rendercolor","162 162 255");
		VMFCG.core._EntSetKeyValue(ent,"renderfx",0);
		VMFCG.debug("VMFCG.selection.Colorize","Colorizing ent "..ent);
	else
		if(VMFCG.Entities.Exists(ent)) then
			local fixup_keyvalues = {"rendercolor","_material","renderamt","renderfx"};
			local fixup_keyvalues_default = {"255 255 255","",255,0};
			for k,v in fixup_keyvalues do
				local old_var = VMFCG.Entities[ent]:GetKeyValue(v);
				if(old_var ~= "") then
					if(v ~= "_material") then
						VMFCG.core._EntSetKeyValue(ent,v,old_var);
					else
						VMFCG.core._EntSetMaterial(ent,old_var);
					end
				else
					if(v ~= "_material") then
						VMFCG.core._EntSetKeyValue(ent,v,fixup_keyvalues_default[k]);
					else
						VMFCG.core._EntSetMaterial(ent,fixup_keyvalues_default[k]);
					end
				end
			end
		else
			VMFCG.core._EntSetMaterial(ent,"");
			VMFCG.core._EntSetKeyValue(ent,"rendercolor","255 255 255");
		end
		VMFCG.debug("VMFCG.selection.Colorize","Uncolorizing ent "..ent);
	end
end

-- ############## Colorize/decolorize all selected entitys (void) @aVoN
function VMFCG.selection.ColorizeAll(userid,colorize)
	if(userid == 0) then return end;
	for _,v in VMFCG.selection.users[userid].entities do
		VMFCG.selection.Colorize(v,colorize);
	end
end

-- #############################################
-- ############### Interactive functions #################
-- #############################################


-- ############## Removes non existand Entities out of the list of selected Props (void) @aVoN
function VMFCG.selection.RemoveNonExistantEntities()
	for k,v in VMFCG.selection.users do
		for kk,vv in v.entities do
			if(not _EntExists(vv)) then
				VMFCG.selection.users[k].entities[kk] = nil;
				VMFCG.SaveLoad.users[k].selection_ammount = VMFCG.selection.Ammount(k);
				VMFCG.debug("VMFCG.selection.RemoveNonExistantEntities","Removed nonexistant entity "..vv.." out of "..k.."'s index");
			end
		end
	end
end

-- ############## Colorize props (void) @aVoN
function VMFCG.selection.ColorizeProps()
	for i=1,_MaxPlayers() do
		if(_PlayerInfo(i,"connected")) then
			local swep = _EntGetType(_PlayerGetActiveWeapon(i));
			local colorize = false;
			if(swep) then
				if(string.find(swep,"vmfcg") and _PlayerInfo(i,"alive") and swep ~= "weapon_vmfcg_remover") then
					colorize = true;
				end
			end
			if(colorize) then
				VMFCG.selection.UpdateHud(i);
			end
			if(colorize and not VMFCG.selection.users[i].colorized) then
				VMFCG.selection.users[i].colorized = colorize;
				VMFCG.selection.ColorizeAll(i,true);
			end
			if(not colorize and VMFCG.selection.users[i].colorized) then
				VMFCG.selection.users[i].colorized = colorize;
				VMFCG.selection.users[i].hud:Hide();
				VMFCG.selection.ColorizeAll(i,false);
			end
		end
	end
end

-- ############## Shows the hud on a players left screen (void) @aVoN
function VMFCG.selection.UpdateHud(userid)
	-- Needed, when called by VMFCG.selection.ColorizeProps Timer,
	local gun = _EntGetType(_PlayerGetActiveWeapon(userid));
	
	-- General part.
	local lines = {};
	if(table.getn(VMFCG.SaveLoad.users[userid].preview_entities) > 0 and VMFCG.selection.Ammount(userid) == 0) then
		-- Loaded a file
		table.insert(lines,"Prop Ammount: "..table.getn(VMFCG.SaveLoad.users[userid].preview_entities));
	else
		-- Selected a prop
		local max_props = tonumber(VMFCG.RightsManager.restrictions(userid,VMFCG.defines.RESTRICTION_SAVE_AMMOUNT));
		if(max_props) then
			max_props = " / "..max_props;
		else
			max_props = "";
		end
		table.insert(lines,"Selected Props: "..VMFCG.selection.Ammount(userid)..max_props);
	end
	
	-- ############## For normal and smart selector - Only difference is the topic ;)
	if(gun == "weapon_vmfcg_select" or gun == "weapon_vmfcg_smartselect") then
		table.insert(lines,"Preview: "..tostring(VMFCG.SaveLoad.users[userid].preview));
		table.insert(lines,"Rotation Angle: "..tostring(VMFCG.SaveLoad.users[userid].spawn_angle));
		table.insert(lines,"Spawn Height: "..tostring(VMFCG.SaveLoad.users[userid].spawn_height));
		if(table.getn(VMFCG.SaveLoad.users[userid].preview_entities) > 0 and VMFCG.selection.Ammount(userid) == 0) then
			if(VMFCG.SaveLoad.users[userid].current_file ~= "" and VMFCG.SaveLoad.users[userid].current_file) then
				local dots = "";
				if(string.len(VMFCG.SaveLoad.users[userid].current_file) >= 23) then
					dots = "...";
				end
				table.insert(lines,"File: "..string.sub(VMFCG.SaveLoad.users[userid].current_file,0,23)..dots);
			end
		end
		if(gun == "weapon_vmfcg_select") then
			VMFCG.selection.users[userid].hud:Topic("VMFCopyGun Select Tool");
		else
			VMFCG.selection.users[userid].hud:Topic("VMFCopyGun SmartSelect Tool");
		end
		VMFCG.selection.users[userid].hud:Text(VMFCG.implode(lines,"\n"));
		VMFCG.selection.users[userid].hud:Show();
	end
	
	-- ############## For sphere selector
	if(gun == "weapon_vmfcg_sphereselect") then
		local radius = 0;
		local point = vector3(0,0,0);
		local session = VMFCG.selection.users[userid].session;
		if(session.stage == 0) then
			if(session.pos1 and session.pos2) then
				point = session.pos1;
				radius = math.floor(10*vecLength(vecSub(session.pos1,session.pos2)))/10;
			end
		end
		table.insert(lines,"Point: "..vecString(point));
		table.insert(lines,"Radius: "..radius);
		if(table.getn(VMFCG.SaveLoad.users[userid].preview_entities) > 0 and VMFCG.selection.Ammount(userid) == 0) then
			if(VMFCG.SaveLoad.users[userid].current_file ~= "" and VMFCG.SaveLoad.users[userid].current_file) then
				local dots = "";
				if(string.len(VMFCG.SaveLoad.users[userid].current_file) >= 23) then
					dots = "...";
				end
				table.insert(lines,"File: "..string.sub(VMFCG.SaveLoad.users[userid].current_file,0,23)..dots);
			end
		end
		VMFCG.selection.users[userid].hud:Topic("VMFCopyGun SphereSelect Tool");
		VMFCG.selection.users[userid].hud:Text(VMFCG.implode(lines,"\n"));
		VMFCG.selection.users[userid].hud:Show();
	end
	
	-- ############## For Quad Selector
	if(gun == "weapon_vmfcg_quadselect") then
		local width = 0;
		local length = 0;
		local height = 0;
		local session = VMFCG.selection.users[userid].session;
		if(session.length) then
			length = math.floor(10*session.length)/10;
		end
		if(session.length) then
			length = math.floor(10*session.length)/10;
		end
		if(session.width) then
			width = math.floor(10*session.width)/10;
		end
		if(session.height) then
			height = math.floor(10*session.height)/10;
		end
		table.insert(lines,"Width: "..width);
		table.insert(lines,"Length: "..length);
		table.insert(lines,"Height: "..height);
		if(table.getn(VMFCG.SaveLoad.users[userid].preview_entities) > 0 and VMFCG.selection.Ammount(userid) == 0) then
			if(VMFCG.SaveLoad.users[userid].current_file ~= "" and VMFCG.SaveLoad.users[userid].current_file) then
				local dots = "";
				if(string.len(VMFCG.SaveLoad.users[userid].current_file) >= 23) then
					dots = "...";
				end
				table.insert(lines,"File: "..string.sub(VMFCG.SaveLoad.users[userid].current_file,0,23)..dots);
			end
		end
		VMFCG.selection.users[userid].hud:Topic("VMFCopyGun QuadSelect Tool");
		VMFCG.selection.users[userid].hud:Text(VMFCG.implode(lines,"\n"));
		VMFCG.selection.users[userid].hud:Show();
	end
end

-- ############## Gives the specific SWEP to a player (void) @aVoN
function VMFCG.selection.GiveSwep(userid,arg)
	local arg = tonumber(arg);
	if(not arg) then return end;
	local sweps = {
		{file="select",name="",access=VMFCG.defines.ALLOW_SELECT},
		{file="sphereselect",name="Sphere Select",access=VMFCG.defines.ALLOW_SPHERESELECT},
		{file="quadselect",name="Quad Select",access=VMFCG.defines.ALLOW_QUADSELECT},
		{file="smartselect",name="Smart Select",access=VMFCG.defines.ALLOW_SMARTSELECT},
		{file="vmfremover",name="VMFRemover ",access=VMFCG.defines.ALLOW_VMFREMOVER}
	}
	if(sweps[arg]) then
		if(VMFCG.RightsManager.hasAccess(userid,sweps[arg].access)) then
			if(not _PlayerHasWeapon(userid,"weapon_vmfcg_"..sweps[arg].file)) then
				_PlayerGiveSWEP(userid, "VMFCopyGun/sweps/vmfcg_"..sweps[arg].file..".lua");
				VMFCG.debug("VMFCG.selection.GiveSwep","Gave "..sweps[arg].name.."Tool to player "..userid);
				if(arg == 1) then
					-- Only for select tool : spawn preview!
					VMFCG.SaveLoad.SpawnPreview(userid,true);
				end
			else
				_PlayerSelectWeapon(userid, "weapon_vmfcg_"..sweps[arg].file);
			end
		else
			VMFCG.Hud.Message(userid,"                          You are not allowed to use the "..sweps[arg].name.."Tool!");
		end
	end
	if(arg == 6) then
		VMFCG.selection.GiveSwep(userid,5);
		VMFCG.selection.GiveSwep(userid,4);
		VMFCG.selection.GiveSwep(userid,3);
		VMFCG.selection.GiveSwep(userid,2);
		VMFCG.selection.GiveSwep(userid,1);
		VMFCG.debug("VMFCG.selection.GiveSwep","Gave all selecttools to player "..userid);
	end
end

-- #############################################
-- ################### Init #######################
-- #############################################

VMFCG.AddTimerOnce("VMFCG.selection.RemoveNonExistantEntities",0.5,0,VMFCG.selection.RemoveNonExistantEntities);
VMFCG.AddTimerOnce("VMFCG.selection.ColorizeProps",0.2,0,VMFCG.selection.ColorizeProps);


-- #############################################
-- ###############CONCOMMAND ####################
-- #############################################

VMFCG.Commands.Add("vmfcg_swep",VMFCG.selection.GiveSwep,"!vmfcg_swep");