--[[

	#############################################
	
		VMF CopyGun - enhanced Think/Timers/Events with unbreaker engine
		
	#############################################
	
]]--
if(VMFCG.config.use_think_unbreaker) then
	-- ############## Same as the real timer, but does unbreak broken timers too (void) @GMod9 defaul, modified by aVoN
	-- First, remove old, original timerfunction from the thinklist
	if(DoTimers) then
		for k,v in gLuaThinkFunctions do
			if(v == DoTimers) then
				gLuaThinkFunctions[k] = nil;
			end
		end
	end
	-- Now add the modificated version
	function DoTimers ()
		for key,value in Timer do
			if (Timer[key]) then
				if(Timer[key].delay) then
					if((Timer[key].time + Timer[key].delay ) < _CurTime()) then
						if(Timer[key]) then Timer[key].time = _CurTime(); end
						_RunString("Timer["..key.."].func(unpack(Timer["..key.."].arg))");
						if(Timer[key].reps > 1) then
							Timer[key].reps = Timer[key].reps-1;
						elseif (Timer[key].reps == 1) then
							Timer[key] = nil;
						end
					end
				end
			end
		end
	end
	
	-- ############## Like the normal thinkfunction caller, but removes malicious/not working thinkfunctions, when they break (void) @GMod9 defaul, modified by aVoN
	function DoLuaThinkFunctions ()
		for k, v in gLuaThinkFunctions do
			if(gLuaThinkFunctions[k]) then
				_RunString("gLuaThinkFunctions["..k.."]()");
			end
		end
		DoTimers(); -- Directly called in here - not hooked/added by AddThinkFunction, or it may get autoremoved, when a timer breaks
	end
	
	-- ############## Hooks now get called by a slightly modified version of the DoEventHook(), so bad Hooked functions won't break others anymore (void) @GMod9 defaul, modified by aVoN
	function DoEventHook( name,...)
		if(ShowEvents) then
			Msg("Lua Event: [" .. arg.n  .."]  " .. name .. "( ");
			for i=1, arg.n do
				Msg( tostring( arg[i] ) );
				if (i < arg.n) then Msg( ", " );end
			end 
			Msg(" )\n");
		end
		for k, v in g_EvenHooks do
			if(g_EvenHooks[k] and g_EvenHooks[k].name == name) then
				g_EvenHooks[k].arg = arg; -- Store arguments for further usage in the runstring below
				_RunString("g_EvenHooks["..k.."].func(unpack(g_EvenHooks["..k.."].arg))");
			end
		end
	end
end
