--[[

	#############################################
	
		VMF CopyGun - Toolgun event fetcher (Core functions)
		
	#############################################
	
]]--
VMFCG.tools = {}
VMFCG.tools.fetch_hook_id = nil; -- Saves hookid of the fetcher
VMFCG.tools.toolmodes = {} -- Saves the toolgun functions
VMFCG.tools.users = {}
for k=1,_MaxPlayers() do
	VMFCG.tools.users[k] = {}
	VMFCG.tools.users[k].last_shot_time = 0; -- When has the player shot the last time? (or better performed this action) - If the timeout is reached, and he is still pressing the key, the think function does the eventKeyPressed action on each frame (performance optimization)
	VMFCG.tools.users[k].shot = false; -- Handles, if the player has shot or not
	VMFCG.tools.users[k].mode = -1; -- Current Toolgun mode
	VMFCG.tools.users[k].session = {} -- Event data, which are saved for each toolgun mode
end


-- #############################################
-- ############### Generel Toolgun functions ##############
-- #############################################


-- ############## Gets user, if he hase tool in his hand (boolean) @aVoN
function VMFCG.tools.isTool ( userid )
	local weapon = string.lower(_EntGetType(_PlayerGetActiveWeapon(userid)));
	if(weapon == "weapon_tool") then
		return true;
	end
	return false;
end

-- ############## Get a toolmode for a specific user (number) @aVoN
function VMFCG.tools.ToolMode ( userid )
	local mode = tonumber(_GetClientConVar_String(userid,"gm_toolmode"));
	--VMFCG.debug("VMFCG.tools.ToolMode","user "..userid.." in toolmode "..mode);
	return mode;
end

-- ############## Resets a session of a user (void) @aVoN
function VMFCG.tools.ResetSession ( userid,mode,override )
	if(VMFCG.tools.users[userid].mode ~= -1 or override) then
		VMFCG.tools.users[userid].mode = mode;
		VMFCG.tools.users[userid].session = {};
		VMFCG.debug("VMFCG.tools.ResetSession","resetting toolmode to "..mode.." for user "..userid);
	end
end

-- ############## Handles the events with the toolgun (void) @aVoN
function VMFCG.tools.FetchAction ( userid, key )
	if(VMFCG.tools.isTool ( userid )) then
		if(VMFCG.PropProtector_AllowedToShoot(userid)) then -- Warpper for PropProtector
			local mode = VMFCG.tools.ToolMode ( userid );
			if(VMFCG.tools.toolmodes[mode] ~= nil) then
				if(VMFCG.tools.users[userid].mode ~= mode) then
					VMFCG.tools.ResetSession(userid,mode,true)
				end
				VMFCG.tools.toolmodes[mode](userid,key); -- Call the event
			end
		end
	else
		VMFCG.tools.ResetSession(userid,-1); -- Start new session
	end
end

-- ############## Player shot? (void) @aVoN
function VMFCG.tools.eventKeyPressed (userid, key)
	if(key == IN_ATTACK or key == IN_ATTACK2) then
		VMFCG.tools.users[userid].shot = true;
		VMFCG.tools.users[userid].last_shot_time = _CurTime();
		VMFCG.tools.FetchAction(userid,key);
	end
end

-- ############## Player released key? (void) @aVoN
function VMFCG.tools.eventKeyReleased (userid, key)
	if(key == IN_ATTACK or key == IN_ATTACK2) then
		VMFCG.tools.users[userid].shot = false;
	end
end

-- ############## Checks whether the player has or hasn't changed his weapon or not (void) @aVoN
function VMFCG.tools.CheckToolgunThink() 
	for k=1,_MaxPlayers() do
		if(VMFCG.tools.users[k].shot and _PlayerInfo(k,"connected")) then
			local last_mode = VMFCG.tools.users[k].mode;
			local current_mode = VMFCG.tools.ToolMode(k);
			local is_tool = VMFCG.tools.isTool(k);
			if((not _PlayerInfo(k,"alive") or not is_tool or last_mode ~= current_mode or VMFCG.tools.toolmodes[current_mode] == nil) and last_mode  ~= -1) then
				-- Player isn't alive, or hasn't the toolgun in his hands or changed the toolgunmode
				VMFCG.tools.ResetSession(k,-1); -- Start new session
			else
				if(is_tool) then
					local last_shot = VMFCG.tools.users[k].last_shot_time;
					if(VMFCG.tools.toolmodes[current_mode] ~= nil and last_mode ~= -1) then
						local key = 0;
						if(_PlayerIsKeyDown(k,IN_ATTACK)) then
							key = IN_ATTACK;
						end
						if(_PlayerIsKeyDown(k,IN_ATTACK2)) then
							key = IN_ATTACK2;
						end
						if(key ~= 0) then
							if(last_shot + VMFCG.config.think_event_timout <= _CurTime()) then -- After the timout of 0.15, the think functions does the checks for the toolgun, instead of the event. Happen only, when a player presses attack in toolgun all the time (for e.g. colorizing severalprops)
								VMFCG.debug("VMFCG.tools.CheckToolgunThink","Player still shoots - Thinkfunction recognization");
								VMFCG.tools.FetchAction ( k, key )
							end
						end
					end
				end
			end
		end
	end
end

-- ############## Validity check (boolean) @aVoN
function VMFCG.tools.isValid(traceline,session,multiworld)
	local ent = traceline:GetEnt();
	local l_ent = session.last_ent;
	--VMFCG.debug("VMFCG.tools.isValid","Hit: "..tostring(traceline:Hit()).." - IsPlayer: "..tostring(IsPlayer(ent)).." - last ent: "..tostring(l_ent).." cur ent: "..tostring(ent).." "..tostring(traceline:HitWorld()).." "..tostring(traceline:HitSky()));
	if(traceline:Hit() and not IsPlayer(ent) and (l_ent ~= ent or ((traceline:HitWorld() or traceline:HitSky()) and multiworld))) then
		return true;
	end
	return false;
end

-- ############## Finds special entitys by a filter (table) @aVoN
function VMFCG.tools.FindEntity(filter)
	local avoid = {};
	if(filter.avoid) then
		for _,v in filter.avoid do
			avoid[v] = true;
		end
	end
	if(filter.radius and filter.origin) then
		-- Find by Sphere
		for _,v in _EntitiesFindInSphere(filter.origin,filter.radius*VMFCG.config.accuracy) do
			if(not avoid[v] and (not filter.checkadded or not VMFCG.Entities.Exists(v)) and (not filter.class or _EntGetType(v) == filter.class) and (not filter.model or _EntGetModel(v) == filter.model) and (not filter.parent or _EntGetParent(v) == filter.parent)) then
				return v;
			end
		end
		return 0;
	elseif(filter.class) then
		-- Find an entity by class (with distance check enabled - default min distance = 0.1)
		for _,v in _EntitiesFindByClass(filter.class) do
			if(not avoid[v] and (not filter.checkadded or not VMFCG.Entities.Exists(v)) and (not filter.model or _EntGetModel(v) == filter.model) and (not filter.parent or _EntGetParent(v) == filter.parent) and (not filter.origin or vecLength(vecSub(_EntGetPos(v),filter.origin)) <= (filter.distance or 0.1))) then
				return v;
			end
		end
		return 0;
	end
	return 0;
end

-- ############## Basic Session - Handles all Toolgunactions which work with 2-click @aVoN
function VMFCG.tools.BasicSession ( userid, key, callback,shots,allowmulti)
	local shots = shots or 1;
	local t = VMFCG.TraceLine:NewUser(userid);
	local session = VMFCG.tools.users[userid].session;
	local last_shot = VMFCG.tools.users[userid].last_shot_time; -- For the think_event check
	local ent = t:GetEnt();
	-- When the first prop gets removed, reset the session...
	if(not _EntExists(session.ent1) and session.ent1 ~= 0 and session.ent1 ~= nil) then
		local tool_mode = VMFCG.tools.ToolMode(userid);
		VMFCG.tools.ResetSession ( userid,tool_mode,true );
		session = VMFCG.tools.users[userid].session;
	end
	session.shot = session.shot or 0;
	if(key == IN_ATTACK2) then -- Abort session
		VMFCG.tools.ResetSession(userid,-1); -- Start new session
		VMFCG.debug("VMFCG.tools.BasicSession","Session Aborted");
		return;
	end
	if(VMFCG.tools.isValid(t,session,true) or (session.shot == shots and session.ent1 ~= ent and last_shot +VMFCG.config.think_event_timout <= _CurTime()) or allowmulti) then -- Handle Session
		session["ent"..session.shot+1] = ent;
		session["ent_pos"..session.shot+1] = _EntGetPos(ent);
		session["pos"..session.shot+1] = t:EndPos();
		session["surface_normal"..session.shot+1] = t:GetSurfaceNormal();
		session.last_ent = ent;
		if(session.shot == shots) then -- Event 2 (end of session)
			local toolgun_mode = VMFCG.tools.ToolMode ( userid );
			VMFCG.AddTimerOnce("VMFCG.tools.BasicSession:"..userid..":("..toolgun_mode.."):"..tostring(t),0.1,1,callback,userid,session); -- Send sessiondata to a callback but wait 0.1 sec first
			VMFCG.debug("VMFCG.tools.BasicSession","Session End");
		else
			VMFCG.debug("VMFCG.tools.BasicSession","Session Stage "..session.shot);
			session.shot = session.shot + 1; -- Increasing shotcounter
		end
		VMFCG.tools.users[userid].session = session; -- Update session
	end
end

-- #############################################
-- ############### Action Callers #####################
-- #############################################

-- ############## Rope @aVoN
function VMFCG.tools.rope ( userid, key )
	local session = VMFCG.tools.users[userid].session;
	session.type = "Rope";
	VMFCG.tools.users[userid].session = session;
	VMFCG.tools.BasicSession(userid,key,VMFCG.tools.rope_elastic_callback);
	VMFCG.debug("VMFCG.tools.rope","Rope");
end

-- ############## Elastic @aVoN
function VMFCG.tools.elastic ( userid, key )
	local session = VMFCG.tools.users[userid].session;
	session.type = "Elastic";
	VMFCG.tools.users[userid].session = session;
	VMFCG.tools.BasicSession(userid,key,VMFCG.tools.rope_elastic_callback);
	VMFCG.debug("VMFCG.tools.rope","Elastic");
end

-- ############## Rope/Elastic callback @aVoN
function VMFCG.tools.rope_elastic_callback ( userid, session )
	local search_pos1 = session.pos1;
	if(session.ent1 ~= 0) then
		search_pos1 = vecAdd(vecSub(session.pos1,session.ent_pos1),_EntGetPos(session.ent1));
	end
	local search_pos2 = session.pos2;
	if(session.ent2 ~= 0) then
		search_pos2 = vecAdd(vecSub(session.pos2,session.ent_pos2),_EntGetPos(session.ent2));
	end
	-- ############## I know, this part is a bit useless - But i wanna save rope/stuff etc like garry creates them in gmod
	local rope_attach1 = 0;
	local rope_attach2 = 0;
	-- Bugbait No1 is NOT essentiell, but when you don't add it to the VMFCG EntityCache, saved contraptions with ropes fuck up (thanks to Jinto for mentioning the behaviour)
	if(session.ent1 ~= 0) then -- Traced entity was 0 (world) - No bugbaits
		-- ############## Search for the Bugbait No.1
		rope_attach1 = VMFCG.tools.FindEntity(
		{
			model = "models/weapons/w_bugbait.mdl",
			origin = search_pos1,
			radius = 80,
			checkadded = true,
			parent=session.ent1,
		})
	end
	if(session.ent2 ~= 0) then
		-- ############## Search for the Bugbait No.2 (rope endpoint)
		rope_attach2 = VMFCG.tools.FindEntity(
		{
			model = "models/weapons/w_bugbait.mdl",
			avoid = {rope_attach1},
			origin = search_pos2,
			radius = 80,
			checkadded = true,
			parent=session.ent2,
		})
	else
		-- ############## No bugbait found - So garry used an invisible sprite - Search this instead
		rope_attach2 = VMFCG.tools.FindEntity(
		{
			class = "env_sprite",
			origin = search_pos2,
			radius = 80,
			checkadded = true,
		})
	end
	-- ############## New search pos calculation
	if(rope_attach1 ~= 0) then
		search_pos1 = _EntGetPos(rope_attach1); -- Update searchpos with the bugbaits position
	end
	-- The bugbait positions are only needed for the positions, where the script needs to add the keyframe_rope and move_rope
	local search_entity = "phys_lengthconstraint";
	if(session.type == "Elastic") then
		search_entity = "phys_spring";
	end
	local constraint = VMFCG.tools.FindEntity(
	{
		class=search_entity,
		origin = search_pos1,
		radius = 30,
		checkadded = true,
	})
	if(constraint > 0) then
		local rope_width = 1; -- Default values for the rope - Local needs be set in here
		local rope_material = 0; -- Default values for the rope - Local needs be set in here
		local rope_attach_end = session.pos2;
		if(rope_attach2 ~= 0) then
			rope_attach_end = _EntGetPos(rope_attach2);
		end
		local rope_length = vecLength(vecSub(_EntGetPos(constraint),rope_attach_end));
		-- ############## Phys Entity part
		if(session.type == "Elastic") then
			-- ##############  Elastic
			local forcelimit = tonumber(_GetClientConVar_String(userid,"gm_weld_spr_forcelimit"));
			local constant = tonumber(_GetClientConVar_String(userid,"gm_weld_spr_springy"));
			local relativedamping = tonumber(_GetClientConVar_String(userid,"gm_weld_spr_damping"));
			rope_width = tonumber(_GetClientConVar_String(userid,"gm_weld_spr_width"));
			rope_material = tonumber(_GetClientConVar_String(userid,"gm_weld_spr_type"));
			if(session.ent2 == 0) then
				VMFCG.Entities[constraint]:SetKeyValue("springaxis",vecString(session.pos2));
			else
				local springaxis_pos = _EntGetPos(rope_attach2);
				VMFCG.Entities[constraint]:SetKeyValue("springaxis",vecString(springaxis_pos));
				VMFCG.Entities[constraint]:SetKeyValue("_attachentity",rope_attach2);
			end
			VMFCG.Entities[constraint]:SetKeyValue("length",rope_length); -- Elastic doesnt have length by default, but i need it to recalculate new lengths, when it's stretched!!
			if(constant ~= 0) then
				VMFCG.Entities[constraint]:SetKeyValue("constant",constant);
			end
			if(relativedamping ~= 0) then
				VMFCG.Entities[constraint]:SetKeyValue("relativedamping",relativedamping);
			end
			if(forcelimit ~= 0) then
				VMFCG.Entities[constraint]:SetKeyValue("breaklength",forcelimit);
			end
		else
			-- ##############  Rope
			local length = tonumber(_GetClientConVar_String(userid,"gm_weld_rope_length"));
			local forcelimit = tonumber(_GetClientConVar_String(userid,"gm_weld_rope_forcelimit"));
			local rigid = tonumber(_GetClientConVar_String(userid,"gm_weld_rope_rigid"));
			rope_width = tonumber(_GetClientConVar_String(userid,"gm_weld_rope_width"));
			rope_material = tonumber(_GetClientConVar_String(userid,"gm_weld_rope_type"));
			if(session.ent2 == 0) then
				VMFCG.Entities[constraint]:SetKeyValue("attachpoint",vecString(session.pos2)); -- Its attached on the the ground
			else
				local attachpoint = _EntGetPos(rope_attach2);
				VMFCG.Entities[constraint]:SetKeyValue("attachpoint",vecString(attachpoint)); -- its attached on the bugbait
				VMFCG.Entities[constraint]:SetKeyValue("_attachentity",rope_attach2);
			end
			VMFCG.Entities[constraint]:SetKeyValue("addlength",length);
			if(forcelimit ~= 0) then
				VMFCG.Entities[constraint]:SetKeyValue("forcelimit",forcelimit);
			end
			if(rigid == 1) then
				VMFCG.Entities[constraint]:SetKeyValue("spawnflags",2);
			end
		end
		
		-- ############## Attach bugbaits
		if(session.ent2 ~= 0) then -- Only add the bugbait, when it's "really" a bugbait. Otherwise, it's an env_spritel, attached to the ground
			-- And add this bugbait as an attachpoint (gets saved) - It's the end of the rope
			VMFCG.Entities[rope_attach2]:SetClass("prop_dynamic_override"); -- Needed, so it doesn't get saved as prop_physics and crash the game
			VMFCG.Entities[rope_attach2]:SetKeyValue("solid",0);
			VMFCG.Entities[rope_attach2]:SetKeyValue("rendermode",3);
			VMFCG.Entities[rope_attach2]:SetKeyValue("renderamt",0);
			VMFCG.Entities[rope_attach2]:SetParent(session.ent2);
			--VMFCG.Entities[rope_attach2]:SetKeyValue("_killhierarchy",constraint); -- Kilhierarchy to the phys_ entity = lesser spam and smaller VMFs
		end
		-- And additonal, add the first bugbait to entity cache - It's not essentiell but neccessry to avoid corrupt saves (Thanks to Jinto for announcing this problem)
		if(rope_attach1 ~= 0) then
			VMFCG.Entities[rope_attach1]:SetClass("prop_dynamic_override"); -- Needed, so it doesn't get saved as prop_physics and crash the game
			VMFCG.Entities[rope_attach1]:SetKeyValue("solid",0);
			VMFCG.Entities[rope_attach1]:SetKeyValue("rendermode",3);
			VMFCG.Entities[rope_attach1]:SetKeyValue("renderamt",0);
			VMFCG.Entities[rope_attach1]:SetParent(session.ent1);
		end
		
		VMFCG.Entities[constraint]:SetKeyValue("_length",rope_length); -- Saves length - used, to calculate the addlength (extralength) later (or it will fuck up)
		VMFCG.Entities[constraint]:SetKeyValue("attach1",session.ent1);
		VMFCG.Entities[constraint]:SetKeyValue("attach2",session.ent2);
		
		-- ############## Visible Rope Part (keyframe_rope)
		-- For a reason I dont understand, the keyframe-rope doesnt get recognized by _EntitiesFindInSphere - So do this way now.
		local phys_ent_pos = _EntGetPos(constraint);
		if(rope_attach2 ~= 0) then -- The Rope goes to the one bugbait
			local rope = VMFCG.tools.FindEntity(
			{
				class = "keyframe_rope",
				origin = phys_ent_pos,
				checkadded = true,
				distance = 0.2,
			})
			if(rope > 0) then
				-- I tested several values. They are either 0 (exact same position when shoot at ground) or e.g.  0.0001223084987021, so 0.1 mus work good ;)
				VMFCG.Entities[rope]:SetKeyValue("NextKey",rope_attach2);
				VMFCG.Entities[rope]:SetKeyValue("Slack",-rope_length); -- Extralength (0 for rope :P) - Other extralength is handles by the phys_lengthconstraint :D
				VMFCG.Entities[rope]:SetKeyValue("Width",rope_width);
				VMFCG.Entities[rope]:SetKeyValue("RopeMaterial",VMFCG.defines.RopeMaterial[rope_material]);
				VMFCG.Entities[rope]:SetParent(constraint); -- Attach it to the constraint, or it will be attached to the one "not important" bugbait and the dependencywalker would fuck up
				if(not VMFCG.Entities.Exists(rope_attach2)) then
					-- Add this bugbait or sprite
					VMFCG.Entities[rope_attach2]:SetKeyValue("renderamt",0);
					VMFCG.Entities[rope_attach2]:SetKeyValue("rendermode",3);
					if(_EntGetType(rope_attach2) == "env_sprite") then
						VMFCG.Entities[rope_attach2]:SetKeyValue("_killhierarchy",constraint);
					end
				end
			end
		end
		VMFCG.debug("VMFCG.tools.rope",session.type.." done");
		VMFCG.tools.ResetSession(userid,-1); -- Start new session
	end
end

-- ############## Weld @aVoN
function VMFCG.tools.weld ( userid, key )
	VMFCG.tools.users[userid].session.type = "Weld";
	VMFCG.tools.BasicSession(userid,key,VMFCG.tools.weld_callback);
	VMFCG.debug("VMFCG.tools.weld","Weld");
end

-- ############## Weld Action  for weld,easyweld,nailgun @aVoN
function VMFCG.tools.weld_callback(userid,session)
	local constraint_pos = vector3(0,0,0); -- When the ent1 id = 0, the constraint is spawned in the zero vector!
	if(session.ent1 ~= 0) then
		constraint_pos = _EntGetPos(session.ent1); -- Otherwise, it's in the entity, which got shot the first time
	end
	local constraint = VMFCG.tools.FindEntity(
	{
		class = "phys_constraint",
		origin = constraint_pos,
		radius = 10,
		checkadded = true,
	})
	if(constraint > 0) then
		local cons_parent = _EntGetParent(constraint);
		-- Welded two props or prop with world
		local two_props_or_prop_world = false;
		if(session.ent1 ~= 0 and cons_parent == session.ent1) then
			two_props_or_prop_world = true;
		end
		-- Welded "World" with prop
		local world_prop = false;
		if(session.ent1 == 0 and cons_parent == 0) then
			world_prop = true;
		end
		if(two_props_or_prop_world or world_prop) then
			local no_collide = 0;
			local force_limit = 0;
			if(session.type == "Weld") then -- For weld
				no_collide = tonumber(_GetClientConVar_String(userid,"gm_weld_weld_nocollide"));
				force_limit = tonumber(_GetClientConVar_String(userid,"gm_weld_weld_forcelimit"));
			end
			if(session.type == "EasyWeld") then
			-- Otherwise for EasyWeld
				no_collide = tonumber(_GetClientConVar_String(userid,"gm_weld_weldez_nocollide"));
				force_limit = tonumber(_GetClientConVar_String(userid,"gm_weld_weldez_forcelimit"));
			end
			if(session.type == "Nailgun") then
				no_collide = tonumber(_GetClientConVar_String(userid,"gm_weld_nail_nocollide"));
				force_limit = tonumber(_GetClientConVar_String(userid,"gm_weld_nail_forcelimit"));
			end
			if(no_collide == 1) then
				VMFCG.Entities[constraint]:SetKeyValue("spawnflags","1");
			end
			if(force_limit ~= 0) then
				VMFCG.Entities[constraint]:SetKeyValue("forcelimit",force_limit);
			end
			--[[
				-- Set Parenting (not needed but GMod does this by default - Whatever -was only for testing)
				if(two_props_or_prop_world) then
					VMFCG.Entities[constraint]:SetParent(session.ent1);
				else
					VMFCG.Entities[constraint]:SetParent(session.ent2);
				end
			--]]
			VMFCG.Entities[constraint]:SetKeyValue("attach1",session.ent1);
			VMFCG.Entities[constraint]:SetKeyValue("attach2",session.ent2);
			VMFCG.debug("VMFCG.tools.weld_callback",session.type.." done");
			VMFCG.tools.ResetSession(userid,-1); -- Start new session
		end
	end
end

-- ############## Ballsocket @aVoN
function VMFCG.tools.ballsocket ( userid, key )
	VMFCG.tools.users[userid].session.type = "BallSocket";
	VMFCG.tools.BasicSession(userid,key,VMFCG.tools.ballsocket_callback);
	VMFCG.debug("VMFCG.tools.ballsocket","Ballsocket");
end

-- ############## Ballsocket callback @aVoN
function VMFCG.tools.ballsocket_callback(userid,session)
	-- Getting the phys_ballsocket entity
	-- It's on a wall or something like this - Search for it right now on the position
	local vBSocket = session.pos2;
	if(session.ent2 ~= 0) then -- The entity isn't the world - so the position of the ballsucker has maybe changed due to prop movement - Find it now
		local vEnt_Change = vecSub(session.ent_pos2,_EntGetPos(session.ent2))
		vBSocket = vecAdd(session.pos2,vEnt_Change);
	end
	local constraint = VMFCG.tools.FindEntity(
	{
		class = "phys_ballsocket",
		origin = vBSocket,
		radius = 10,
		checkadded = true,
	})
	if(constraint > 0) then
		if(((session.type == "BallSocket" and _EntGetParent(constraint) == session.ent2) or (session.type == "EasyBallSocket" and _EntGetParent(constraint) == session.ent1))) then
			local forcelimit = 0;
			local no_collide = 0;
			if(session.type == "BallSocket") then
				forcelimit = tonumber(_GetClientConVar_String(userid,"gm_weld_ball_forcelimit"));
				no_collide = tonumber(_GetClientConVar_String(userid,"gm_weld_ball_nocollide"));
			else
				forcelimit = tonumber(_GetClientConVar_String(userid,"gm_weld_ballez_forcelimit"));
				no_collide = tonumber(_GetClientConVar_String(userid,"gm_weld_ballez_nocollide"));
			end
			if(no_collide ~= 0) then
				VMFCG.Entities[constraint]:SetKeyValue("spawnflags",1);
			end
			if(forcelimit ~= 0) then
				VMFCG.Entities[constraint]:SetKeyValue("forcelimit",forcelimit);
			end
			VMFCG.Entities[constraint]:SetKeyValue("attach1",session.ent1);
			VMFCG.Entities[constraintv]:SetKeyValue("attach2",session.ent2);
			VMFCG.Entities[constraint]:SetParent(_EntGetParent(constraint));
			VMFCG.debug("VMFCG.tools.ballsocket_callback",session.type.." done");
			VMFCG.tools.ResetSession(userid,-1); -- Start new session
		end
	end
end

-- ############## Pulley @aVoN
function VMFCG.tools.pulley ( userid, key )
	local session = VMFCG.tools.users[userid].session;
	VMFCG.tools.users[userid].session = session;
	VMFCG.tools.BasicSession(userid,key,VMFCG.tools.pulley_callback,3,true);
	VMFCG.debug("VMFCG.tools.pulley","Pulley");
end

-- ############## Pulley callback @aVoN
function VMFCG.tools.pulley_callback ( userid, session )
	local kill = false;
	if(session.ent1 == 0 or session.ent4 == 0) then
		kill = true; -- Prevent all these mingebags for spamming pulley on the map with no attachments (or better, only attachments to the world)
	end
	local search_pos1 = vecAdd(vecSub(session.pos1,session.ent_pos1),_EntGetPos(session.ent1));
	local search_pos2 = vecAdd(vecSub(session.pos4,session.ent_pos4),_EntGetPos(session.ent4));
	
	-- ############## Search for the Bugbait No.1 (rope endpoints)
	local rope_attach1 = VMFCG.tools.FindEntity(
	{
		model = "models/weapons/w_bugbait.mdl",
		parent = session.ent1,
		origin = search_pos1,
		radius = 80,
		checkadded = true,
	})
	-- ############## Search for the Bugbait No.2 (rope endpoints)
	local rope_attach2 = VMFCG.tools.FindEntity(
	{
		model = "models/weapons/w_bugbait.mdl",
		avoid = {rope_attach1},
		parent = session.ent4,
		origin = search_pos2,
		radius = 80,
		checkadded = true,
	})
	-- ############## Searches for the "middle" bugbaits, which are near the keyframe rope positions. I parent them to the pulleyconstraint later, so they will disappear on deletion of it (otherwise they stay forever, like its in normal GMod) - So, another enhancement of Gmod with Lua! :P
	local middle_bugbaits = {};
	-- Middle First one
	middle_bugbaits[1] = VMFCG.tools.FindEntity(
	{
		model = "models/weapons/w_bugbait.mdl",
		avoid = {rope_attach1,rope_attach2},
		origin = session.pos2,
		radius = 80,
		checkadded = true,
	})
	-- Middle Second one
	middle_bugbaits[2] = VMFCG.tools.FindEntity(
	{
		model = "models/weapons/w_bugbait.mdl",
		avoid = {rope_attach1,rope_attach2,middle_bugbaits[1]},
		origin = session.pos3,
		radius = 80,
		checkadded = true,
	})
	-- ############## Search for the pulley constraint
	local constraint = VMFCG.tools.FindEntity(
	{
		class = "phys_pulleyconstraint",
		origin = session.pos2,
		radius = 15,
		checkadded = true,
	})
	if(constraint > 0) then
		-- Old attach method, until i figured out, garry attaches the pulley force to the bugbaits - Bugbaitsm lovely bugbaits :P
		--VMFCG.Entities[constraint]:SetKeyValue("attach1",session.ent1);
		--VMFCG.Entities[constraint]:SetKeyValue("attach2",session.ent4);
		VMFCG.Entities[constraint]:SetKeyValue("attach1",rope_attach1); -- Pulley is attached to the bugbaits
		VMFCG.Entities[constraint]:SetKeyValue("attach2",rope_attach2);
		VMFCG.Entities[constraint]:SetKeyValue("position2",vecString(session.pos3));
		local forcelimit = tonumber(_GetClientConVar_String(userid,"gm_weld_pulley_forcelimit"));
		local rigid = tonumber(_GetClientConVar_String(userid,"gm_weld_pulley_rigid"));
		local addlength = vecLength(vecSub(_EntGetPos(rope_attach2),session.pos3));
		if(forcelimit ~= 0) then
			VMFCG.Entities[constraint]:SetKeyValue("forcelimit",forcelimit);
		end
		if(rigid == 1) then
			VMFCG.Entities[constraint]:SetKeyValue("spawnflags",2);
		end
		VMFCG.Entities[constraint]:SetParent(0);
		VMFCG.Entities[constraint]:SetKeyValue("addlength",addlength); -- The additional length, started from position2 till the attach entity
		VMFCG.Entities[constraint]:SetKeyValue("_length",addlength + vecLength(vecSub(_EntGetPos(constraint),session.pos1))); -- The complete length of the pulley constraint
		VMFCG.Entities[constraint]:SetKeyValue("_attachentity",rope_attach1) -- The attachentity, used for updated length calculation by the EntityClass
		
		
		-- ############## Find the ropes and attach them to the bugbaits
		local rope_width = tonumber(_GetClientConVar_String(userid,"gm_weld_pulley_width"));
		local rope_material = tonumber(_GetClientConVar_String(userid,"gm_weld_pulley_type"));
		local keyframe_rope_right = VMFCG.tools.FindEntity( -- This rope is attached to the last bugbait
		{
			class = "keyframe_rope",
			origin = session.pos3,
			checkadded = true,
		})
		if(keyframe_rope_right > 0) then
			-- ############## Apply the rope-effects
			local slack = vecLength(vecSub(_EntGetPos(keyframe_rope_right),session.pos4));
			VMFCG.Entities[keyframe_rope_right]:SetKeyValue("Slack",-slack); -- Need to be negative, so the rope has no extralength
			VMFCG.Entities[keyframe_rope_right]:SetKeyValue("Width",rope_width);
			VMFCG.Entities[keyframe_rope_right]:SetKeyValue("RopeMaterial",VMFCG.defines.RopeMaterial[rope_material]);
		end
		local keyframe_rope_left = {}; -- stores two keyframe ropes. One is attached to the bugbait, the another to the "right" keyframe_rope
		for _,vv in _EntitiesFindByClass("keyframe_rope") do
			if(not VMFCG.Entities.Exists(vv)) then
				local found = false;
				local distance = vecLength(vecSub(_EntGetPos(vv),session.pos2));
				local slack = 0; -- The rope length
				if(distance < 0.1) then
					table.insert(keyframe_rope_left,vv);
					slack = vecLength(vecSub(_EntGetPos(vv),session.pos1));
					found = true;
				end
				if(found) then
					-- ############## Apply the rope-effects
					VMFCG.Entities[vv]:SetKeyValue("Slack",-slack); -- Need to be negative, so the rope has no extralength
					VMFCG.Entities[vv]:SetKeyValue("Width",rope_width);
					VMFCG.Entities[vv]:SetKeyValue("RopeMaterial",VMFCG.defines.RopeMaterial[rope_material]);
				end
			end
		end
		if(table.getn(keyframe_rope_left) == 2 and keyframe_rope_right ~= 0) then -- Just add the ropes, when we definatly found them!
			-- ############## Attach ropes
			VMFCG.Entities[keyframe_rope_left[1]]:SetKeyValue("NextKey",rope_attach1); -- One rope is attached to the one bugbait
			VMFCG.Entities[keyframe_rope_left[2]]:SetKeyValue("NextKey",keyframe_rope_right); -- The other is attached to the next keyframe_rope...
			VMFCG.Entities[keyframe_rope_right]:SetKeyValue("NextKey",rope_attach2); -- ... which is attached to the last bugbait
			
			-- ############## Save the bugbaits (only the invisible one), for the rope endpoints
			VMFCG.Entities[rope_attach1]:SetClass("prop_physics_override");
			--VMFCG.Entities[rope_attach1]:SetClass("prop_physics_override"); -- Needed, so it doesn't get saved as prop_physics and crash the server
			VMFCG.Entities[rope_attach1]:SetKeyValue("solid",0);
			VMFCG.Entities[rope_attach1]:SetKeyValue("rendermode",3);
			VMFCG.Entities[rope_attach1]:SetKeyValue("renderamt",0);
			VMFCG.Entities[rope_attach1]:SetKeyValue("_collision","false");
			VMFCG.Entities[rope_attach1]:SetKeyValue("_killhierarchy",constraint);
			VMFCG.Entities[rope_attach1]:SetParent(session.ent1);
			local mass1 = VMFCG.Entities[session.ent1]:GetMass() or 1;
			VMFCG.Entities[rope_attach1]:SetMass(mass1/10); -- Small Hack - Needed, so this bugbait can apply force to the object - Otherwise, force is to less to move it by pulley
			
			VMFCG.Entities[rope_attach2]:SetClass("prop_physics_override");
			--VMFCG.Entities[rope_attach2]:SetClass("prop_physics_override"); -- Needed, so it doesn't get saved as prop_physics and crash the server
			VMFCG.Entities[rope_attach2]:SetKeyValue("solid",0);
			VMFCG.Entities[rope_attach2]:SetKeyValue("rendermode",3);
			VMFCG.Entities[rope_attach2]:SetKeyValue("renderamt",0);
			VMFCG.Entities[rope_attach2]:SetKeyValue("_collision","false");
			VMFCG.Entities[rope_attach2]:SetKeyValue("_killhierarchy",constraint);
			VMFCG.Entities[rope_attach2]:SetParent(session.ent4);
			local mass2 = VMFCG.Entities[session.ent4]:GetMass() or 1;
			VMFCG.Entities[rope_attach2]:SetMass(mass2/10); -- Small Hack - Needed, so this bugbait can apply force to the object - Otherwise, force is to less to move it by pulley
			
			-- ############## Ok, the bugbaits got added as a prop_physics_override - Now add constraints to them, as garry does [EXPERIMENTAL], so the pulley force is not done on the props itself but on the bugbaits - Otherwise, pulleys WONT WORK AFTER A SAVE anymore!
			local attach_constraints = {};
				attach_constraints[1] = {id=VMFCG.tools.FindEntity(
				{
					class = "phys_constraint",
					origin = _EntGetPos(rope_attach1),
					radius = 15,
					checkadded = true,
				}),
				a1 = rope_attach1,
				a2 = session.ent1,
			}
			attach_constraints[2] = {id=VMFCG.tools.FindEntity(
				{
					class = "phys_constraint",
					avoid = {attach_constraints[1]},
					origin = _EntGetPos(rope_attach2),
					radius = 15,
					checkadded = true,
				}),
				a1 = rope_attach2,
				a2 = session.ent4,
			}
			for _,v in attach_constraints do
				if(v.id ~= 0) then
					VMFCG.Entities[v.id]:SetKeyValue("attach1",v.a1);
					VMFCG.Entities[v.id]:SetKeyValue("attach2",v.a2);
					VMFCG.Entities[v.id]:SetKeyValue("spawnflags",1);
				end
			end
		end
		-- ############## Manage middle bugbaits
		for _,v in middle_bugbaits do
			VMFCG.Entities[v]:SetClass("prop_dynamic_override");
			VMFCG.Entities[v]:SetKeyValue("_killhierarchy",constraint);
			VMFCG.Entities[v]:SetKeyValue("solid",0);
		end
		-- ############## Kill the pulleyconstraint and so, all related entities too ( to prevent pulleys on world only)
		if(kill) then
			_EntRemove(constraint);
		end
		VMFCG.tools.ResetSession(userid,-1); -- Start new session
	end
end

-- ############## Easy Weld @aVoN
function VMFCG.tools.easyweld ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	-- Something which differes EasyWeld from anything else: The first shot HAS to be a valid prop
	if((t:GetEnt() ~= 0 and not IsPlayer(t:GetEnt())) or VMFCG.tools.users[userid].session.shot ~= nil) then
		VMFCG.tools.users[userid].session.type = "EasyWeld";
		VMFCG.tools.BasicSession(userid,key,VMFCG.tools.weld_callback,2);
		VMFCG.debug("VMFCG.tools.easyweld","Easy Weld");
	end
end

-- ############## Easy Ballsocket @aVoN
function VMFCG.tools.easyballsocket ( userid, key )
	VMFCG.tools.users[userid].session.type = "EasyBallSocket";
	VMFCG.tools.BasicSession(userid,key,VMFCG.tools.ballsocket_callback);
	VMFCG.debug("VMFCG.tools.easyballsocket","Easy Ball Socket");
end

-- ############## Axis @aVoN
function VMFCG.tools.axis ( userid, key )
	VMFCG.tools.users[userid].session.type = "Axis";
	VMFCG.tools.BasicSession(userid,key,VMFCG.tools.axis_callback);
	VMFCG.debug("VMFCG.tools.axis","Axis");
end

-- ############## Axis  callback@aVoN
function VMFCG.tools.axis_callback ( userid, session )
	local hinge_pos = session.pos2;
	-- When the prop is on another prop, this has maybe moved so lets changed even the position where we will search for the hinge
	if(session.ent2 ~= 0) then
		local vEnt_Change = vecSub(session.ent_pos2,_EntGetPos(session.ent2));
		hinge_pos = vecAdd(session.pos2,vEnt_Change);
	end
	local constraint = VMFCG.tools.FindEntity(
	{
		class = "phys_hinge",
		origin = hinge_pos,
		radius = 15,
		checkadded = true,
	})
	if(constraint > 0) then
		local forcelimit = 0;
		local hingefriction = 0;
		local no_collide = 0;
		local vHingeAxis = vecAdd(session.surface_normal2,_EntGetPos(constraint)); -- Calculates the current hinge axis
		local hingeaxis = vecString(vHingeAxis);
		if(session.type == "Axis") then
			forcelimit = tonumber(_GetClientConVar_String(userid,"gm_weld_axis_forcelimit"));
			hingefriction = tonumber(_GetClientConVar_String(userid,"gm_weld_axis_friction"));
			no_collide = tonumber(_GetClientConVar_String(userid,"gm_weld_axis_nocollide"));
		end
		if(session.type == "Wheels") then
			forcelimit = tonumber(_GetClientConVar_String(userid,"gm_wheel_forcelimit"));
			hingefriction = tonumber(_GetClientConVar_String(userid,"gm_wheel_friction"));
			no_collide = tonumber(_GetClientConVar_String(userid,"gm_wheel_nocollide"));
		end
		-- ############## -- Hingeaxis part
		VMFCG.Entities[constraint]:SetKeyValue("hingeaxis",hingeaxis); -- The hinge axis on spawn of the hinge - Get's handled specially in the Ent class to aquired the new rotation axis when the entities get moved
		-- ############## -- Keyvalues
		VMFCG.Entities[constraint]:SetParent(session.ent1);
		VMFCG.Entities[constraint]:SetKeyValue("attach1",session.ent1);
		VMFCG.Entities[constraint]:SetKeyValue("attach2",session.ent2);
		VMFCG.Entities[constraint]:SetKeyValue("SystemLoadScale","1");
		if(forcelimit ~= 0) then
			VMFCG.Entities[constraint]:SetKeyValue("forcelimit",forcelimit);
		end
		if(hingefriction ~= 0) then
			VMFCG.Entities[constraint]:SetKeyValue("hingefriction",hingefriction);
		end
		if(no_collide == 1) then
			VMFCG.Entities[constraint]:SetKeyValue("spawnflags","1");
		end
		VMFCG.debug("VMFCG.tools.axis_callback",session.type.." done");
		VMFCG.tools.ResetSession(userid,-1); -- Start new session
	end
end

-- ############## Slider @aVoN
function VMFCG.tools.slider ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	local session = VMFCG.tools.users[userid].session;
	if(session.pos1 ~= nil or t:GetEnt() ~= 0) then
		if(key == IN_ATTACK) then
			session.type = "Slider_normal";
			VMFCG.tools.BasicSession ( userid, key, VMFCG.tools.slider_callback);
		end
		if(key == IN_ATTACK2) then
			VMFCG.tools.ResetSession (userid,-1); -- Start new session
			session.type = "Slider_quick";
			session.surface_normal1 = t:GetSurfaceNormal();
			session.ent1 = t:GetEnt();
			session.pos1 = t:EndPos();
			VMFCG.AddTimerOnce("VMFCG.tools.slider_callback:"..userid..":"..tostring(t),0.1,1,VMFCG.tools.slider_callback,userid,session);
		end
		VMFCG.debug("VMFCG.tools.slider","Slider");
		VMFCG.tools.users[userid].session = session;
	end
end

-- ############## Slider callback timer @aVoN
function VMFCG.tools.slider_callback(userid,session)
	local constraint = VMFCG.tools.FindEntity(
	{
		class = "phys_slideconstraint",
		origin = _EntGetPos(session.ent1),
		radius = 15,
		checkadded = true,
	})
	if(constraint > 0) then
		local forcelimit = tonumber(_GetClientConVar_String(userid,"gm_weld_slider_forcelimit"));
		local slidefriction = tonumber(_GetClientConVar_String(userid,"gm_weld_slider_friction"));
		local rope_material = tonumber(_GetClientConVar_String(userid,"gm_weld_slider_type"));
		local rope_width = tonumber(_GetClientConVar_String(userid,"gm_weld_slider_width"));
		local slideaxis = vector3(0,0,0);
		local slack = 0; -- Enxtralength for the rope-effect
		-- For the rope...
		local search_pos1 = session.pos2;
		local search_pos2 = session.pos1;
		if(session.type == "Slider_normal") then
			slideaxis = vecAdd(session.pos2,vecSub(_EntGetPos(constraint),session.pos1));
			slack = vecLength(vecSub(session.pos2,_EntGetPos(constraint)));
		else
			-- Into one direction
			local t1 = VMFCG.TraceLine:New(session.pos1,session.surface_normal1,5000,session.ent1);
			-- And into the other (up)
			local t2 = VMFCG.TraceLine:New(session.pos1,vecMul(session.surface_normal1,-1),5000,session.ent1);
			slideaxis = vecAdd(_EntGetPos(constraint),session.surface_normal1);
			-- The search_pos for the rope in "quick" mode is different and uses tracelins
			search_pos1 = t1:EndPos();
			search_pos2 = t2:EndPos();
			slack = vecLength(vecSub(search_pos1,search_pos2));
		end
		-- ############## slideaxis part
		VMFCG.Entities[constraint]:SetKeyValue("slideaxis",slideaxis);
		-- ############## Key Value part
		VMFCG.Entities[constraint]:SetParent(session.ent1); -- Set slidenetity to the entity1
		VMFCG.Entities[constraint]:SetKeyValue("attach1",session.ent1);
		VMFCG.Entities[constraint]:SetKeyValue("attach2",0);
		if(forcelimit ~= 0) then
			VMFCG.Entities[constraint]:SetKeyValue("forcelimit",forcelimit);
		end
		if(slidefriction ~= 0) then
			VMFCG.Entities[constraint]:SetKeyValue("slidefriction", slidefriction);
		end
		VMFCG.Entities[constraint]:SetKeyValue("SystemLoadScale", 1,true);
		VMFCG.Entities[constraint]:SetKeyValue("spawnflags", 8,true);
		-- ############## Find the keyframe_rope
		local keyframe_rope = VMFCG.tools.FindEntity(
		{
			class = "keyframe_rope",
			origin = search_pos1,
			checkadded = true,
			distance = 0.2,
		})
		-- ############## Find the attach sprite (NextKey for the keyframe rope)
		local rope_attach1 = VMFCG.tools.FindEntity(
		{
			class = "env_sprite",
			origin = search_pos2,
			radius = 15,
			checkadded = true,
		})
		if(keyframe_rope ~= 0 and rope_attach1 ~= 0) then
			VMFCG.Entities[keyframe_rope]:SetKeyValue("NextKey",rope_attach1);
			VMFCG.Entities[keyframe_rope]:SetKeyValue("Slack",-slack); -- Extralength (needs to be negative for "no" extralength
			VMFCG.Entities[keyframe_rope]:SetKeyValue("Width",rope_width);
			VMFCG.Entities[keyframe_rope]:SetKeyValue("RopeMaterial",VMFCG.defines.RopeMaterial[rope_material]);
			VMFCG.Entities[keyframe_rope]:SetKeyValue("_killhierarchy",constraint);
			VMFCG.Entities[keyframe_rope]:SetParent(0); -- Unset the parentend keyframe_rope!
			
			VMFCG.Entities[rope_attach1]:SetKeyValue("renderamt",0);
			VMFCG.Entities[rope_attach1]:SetKeyValue("_killhierarchy",constraint);
			VMFCG.Entities[rope_attach1]:SetKeyValue("rendermode",3);
			if(session.type == "Slider_normal") then
				VMFCG.Entities[rope_attach1]:SetParent(session.ent1); -- Attach to the prop (looks much better)
			end
		end
		VMFCG.tools.ResetSession(userid,-1); -- Start new session
	end
end

-- ############## Nailgun @aVoN
function VMFCG.tools.nailgun ( userid, key ) -- Alias of the Weldgun. But adds nails too
	local t = VMFCG.TraceLine:NewUser(userid); -- First traceline.
	local t2 = VMFCG.TraceLine:New(t:EndPos(),_PlayerGetShootAng(userid),14,t:GetEnt()); -- Second
	local session = VMFCG.tools.users[userid].session;
	session.pos1 = t:EndPos();
	session.ent1 =t:GetEnt();
	session.pos2 = t2:EndPos();
	session.ent2 = t2:GetEnt();
	session.type = "Nailgun";
	VMFCG.tools.users[userid].session = session;
	VMFCG.AddTimerOnce("VMFCG.tools.nailgun:"..userid..":"..tostring(t),0.1,1,VMFCG.tools.weld_callback,userid,session);
	VMFCG.debug("VMFCG.tools.nailgun","Nailgun");
end

-- FacePoser not recognized

-- Eyeposer not recognized

-- Remover not recognized

-- Ignite not recognized

-- Paint not recognized

-- ############## Duplication @aVoN
function VMFCG.tools.duplicate ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	local session = VMFCG.tools.users[userid].session;
	local ent = t:GetEnt();
	local classname = string.lower(_EntGetType(ent));
	if(classname == "prop_physics" or classname == "phys_magnet" or classname == "prop_flashlight" or (ent == 0 and key == IN_ATTACK)) then
		if(session.last_classname ~= nil or (key == IN_ATTACK2 and ent ~= 0)) then -- Just do this on a copy or when a prop got selected
			-- Saves the information about, which entities just exist right now, so the game won't accidently apply the keyvalues on entities which are the same like the copied and near the copied
			session.last_classname = session.last_classname or classname;
		end
		if(key == IN_ATTACK2) then
			if(ent ~= 0) then
				session.last_ent = ent;
				session.last_mdl = _EntGetModel(ent);
				session.preview_pos = t:EndPos();
				-- Only works on listenserver and player 1 - otherwise the preview is rendered on the client.
				if(userid == 1 and not _IsDedicatedServer()) then
					VMFCG.AddTimerOnce("VMFCG.tools.duplicate_apply_preview:"..userid..":"..ent..":"..tostring(t),0.05,1,VMFCG.tools.duplicate_apply_preview,userid,session);
				end
				VMFCG.debug("VMFCG.tools.duplicate","Duplicator Selected Ent "..ent);
			end
		else
			-- Thanks to ShadowWolf, who discovered this bug. I added the if now
			if(session.last_ent) then
				session.pos1 = t:EndPos();
				session.cur_ent = ent;
				VMFCG.debug("VMFCG.tools.duplicate_timer","Duplication Started");
				-- The tostring(t) is added to give the timer a random ID or it gets overwritten
				VMFCG.AddTimerOnce("VMFCG.tools.duplicate_timer:"..userid..":"..tostring(session.last_ent)..":"..tostring(t),0.05,1,VMFCG.tools.duplicate_timer,session); -- The runs just to be 100% sure, that its created
			end
		end
	end
	VMFCG.tools.users[userid].session = session;
end

-- ############## Applys all keyvalues of the copy to the preview (little bugfix and enhancement for the game ;)) @aVoN
function VMFCG.tools.duplicate_apply_preview(userid,session)
	if(session.preview_pos ~= nil) then
		for _,v in _EntitiesFindInSphere(session.preview_pos,10*VMFCG.config.accuracy) do
			if(_EntGetMoveType(v) == 0) then -- It's the preview
				-- Unsetting old key/values so the preview changes
				VMFCG.Entities.CopyKeyValues(session.last_ent,v,"parentname","targetname","origin","solid","angles","_movetype","renderamt","rendermode");
				VMFCG.tools.users[userid].preview_pos = nil;
				break;
			end
		end
	end
end

-- ############## Timer, which checks for entities in a sphere after duplication @aVoN
function VMFCG.tools.duplicate_timer(session)
	if(_EntExists(session.last_ent)) then -- Ent still exists?
		for _,v in _EntitiesFindInSphere(session.pos1,10*VMFCG.config.accuracy) do
			if(_EntGetMoveType(v) ~= 0 and not VMFCG.Entities.Exists(v) and v ~= session.cur_ent) then -- Don't affect the preview
				if(_EntGetModel(v) == session.last_mdl) then -- Same model name
					if(not VMFCG.Entities.Exists(v)) then
						-- Remove unique values ("parentname","targetname","origin","angles")
						VMFCG.Entities.CopyKeyValues(session.last_ent,v,"parentname","targetname","origin","angles");
						VMFCG.debug("VMFCG.tools.duplicate_timer","Duplication applyed to "..v);
						break;
					end
				end
			end
		end
	end
end

-- ############## Color @aVoN
function VMFCG.tools.color ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	local ent = t:GetEnt();
	if(key == IN_ATTACK) then
		local r = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_colourset_r")));
		local g = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_colourset_g")));
		local b = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_colourset_b")));
		local a = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_colourset_a")));
		local rendermode = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_colourset_rm")));
		local renderfx = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_colourset_fx")));
		VMFCG.Entities[ent]:SetKeyValue("rendercolor",r.." "..g.." "..b);
		if(a < 255) then
			VMFCG.Entities[ent]:SetKeyValue("renderamt",a);
			VMFCG.Entities[ent]:SetKeyValue("rendermode","2");
		else
			VMFCG.Entities[ent]:SetKeyValue("renderamt",nil);
			VMFCG.Entities[ent]:SetKeyValue("rendermode",rendermode);
		end
		VMFCG.debug("VMFCG.tools.color","Color "..r.." "..g.." "..b.." "..a);
		VMFCG.Entities[ent]:SetKeyValue("renderfx",renderfx);
	else
		VMFCG.Entities[ent]:SetKeyValue("rendercolor","255 255 255"); -- Default values by Garry
		VMFCG.Entities[ent]:SetKeyValue("renderamt","255"); -- Default values by Garry
		VMFCG.Entities[ent]:SetKeyValue("rendermode","1"); -- Default values by Garry
		VMFCG.Entities[ent]:SetKeyValue("renderfx","0"); -- Default values by Garry
		--VMFCG.Entities[ent]:ApplyKeyValues();
		VMFCG.AddTimerOnce("VMFCG.tools.color_reset:"..userid..":"..ent,0.1,1,VMFCG.tools.color_reset,ent);
	end
end

-- ############## Reset color values @aVoN

function VMFCG.tools.color_reset(id)
	VMFCG.debug("VMFCG.tools.color_reset","Resetting color");
	VMFCG.Entities[id]:ApplyKeyValues();
end

-- ############## Magnetise @aVoN
function VMFCG.tools.magnetise ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	local ent = t:GetEnt();
	local classname = _EntGetType(ent);
	local session = VMFCG.tools.users[userid].session;
	if(classname == "prop_physics") then -- You can't magnetise anything else than prop_physics
		VMFCG.Entities.pause_check = true; -- Pause existant timer or it will probably delete the needed entity informations
		session.ent1 = ent;
		session.ent_pos1 = _EntGetPos(ent);
		session.ent_angangle1 = _EntGetAngAngle(ent);
		session.pos1 = t:EndPos();
		VMFCG.debug("VMFCG.tools.magnetise","Magnetise Start");
		VMFCG.AddTimerOnce("VMFCG.tools.magnetise_timer:"..userid..":"..ent..tostring(t),0.02,1,VMFCG.tools.magnetise_timer,userid,session);
		VMFCG.tools.users[userid].session = session;
	end
end

-- ############## Magnetise Timer - applys changes of old prop_physics on phys_magnet after toolgun usage @aVoN
function VMFCG.tools.magnetise_timer ( userid, session )
	local magnet = VMFCG.tools.FindEntity(
	{
		class = "phys_magnet",
		origin = session.pos1,
		radius = 10,
		checkadded = true,
	})
	if(magnet > 0) then
		_phys.EnableMotion(magnet,false); -- Freeze it
		local magnet_strength = tonumber(_GetClientConVar_String(userid,"gm_magnetstrength"));
		if(VMFCG.Entities.Exists(session.ent1)) then
			VMFCG.Entities.CopyKeyValues(session.ent1,magnet,"classname","solid","_movetype");
			VMFCG.Entities[magnet]:ApplyKeyValues();
		end
		-- Reset both, the pos and angle so they are exactly on the position, the old prop was!
		_EntSetPos(magnet,session.ent_pos1);
		_EntSetAngAngle(magnet,session.ent_angangle1);
		VMFCG.Entities[magnet]:SetKeyValue("forcelimit",magnet_strength); -- Magnet strength
		VMFCG.debug("VMFCG.tools.magnetise","Magnetise Done");
	end
	VMFCG.debug("VMFCG.tools.magnetise","Magnetise Finished");
	VMFCG.Entities.pause_check = nil; -- Reset the existant timer
end

-- Garry told me in the #gmod channel, in gm9, the no collide is managed by direct engine calls of a function with no entities.
-- So i need to use a heuristic and create a logic_collision_pair entity - The only toolmode which does not really search for entities but create an own :D
--[[
Chat Log
[15:18] aVoN`-: how is no collide managed in garrys mod? It's not done with a logic_collision_pair entity. But how then?
[15:18] garry: aVoN`- in 9 it calls a physics function to make them nocollide
--]]
-- ############## No Collide @aVoN
function VMFCG.tools.nocollide ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	if(t:GetEnt() ~= 0) then -- NoCollide only works on entitys - Don't allow the map
		VMFCG.tools.BasicSession ( userid, key, VMFCG.tools.nocollide_callback);
	end
	VMFCG.debug("VMFCG.tools.nocollide","No Collide");
end

-- ############## No Collide callback @aVoN
function VMFCG.tools.nocollide_callback ( userid, session )
	local logic_collision_pair = VMFCG.Ent:Create("logic_collision_pair"); -- Create the logic collision pair entity
	-- This part is needed to make the props immediately nocollide, even when the engine just has done it
	logic_collision_pair:SetKeyValue("attach1",session.ent1,true);
	logic_collision_pair:SetKeyValue("attach2",session.ent2,true);
	logic_collision_pair:SetKeyValue("startdisabled",1,true);
	-- End of this part
	logic_collision_pair:Spawn(); -- And spawn it
	-- This part only handles the key/value pairs
	local lcp_id = logic_collision_pair:GetId();
	VMFCG.Entities[lcp_id]:SetPos(_EntGetPos(session.ent1));
	VMFCG.Entities[lcp_id]:SetAng(_EntGetAng(session.ent1));
	VMFCG.Entities[lcp_id]:SetKeyValue("attach1",session.ent1);
	VMFCG.Entities[lcp_id]:SetKeyValue("attach2",session.ent2);
	VMFCG.Entities[lcp_id]:SetKeyValue("startdisabled",1); -- Enables no collison right now
	VMFCG.Entities[lcp_id]:ApplyKeyValues(); -- And apply the key/values
	VMFCG.Entities[lcp_id]:SetParent(session.ent1);
	VMFCG.tools.ResetSession(userid,-1); -- Start new session
end

-- ############## Dynamite callback @aVoN
function VMFCG.tools.dynamite ( userid, session )
	local t = VMFCG.TraceLine:NewUser(userid);
	local session = VMFCG.tools.users[userid].session;
	session.pos1 = t:EndPos();
	VMFCG.tools.users[userid].session = session;
	VMFCG.AddTimerOnce("VMFCG.tools.dynamite_callback:"..userid..":"..tostring(t),0.1,1,VMFCG.tools.dynamite_callback,userid,session);
	VMFCG.debug("VMFCG.tools.dynamite","Dynamite");
end

-- ############## Dynamite callback @aVoN
function VMFCG.tools.dynamite_callback ( userid, session )
	local dynamite = VMFCG.tools.FindEntity(
	{
		class = "prop_timedexplosion",
		origin = session.pos1,
		radius = 15,
		checkadded = true,
	})
	if(dynamite > 0) then
		local delay = tonumber(_GetClientConVar_String(userid,"gm_dynamite_delay"));
		local delay_add = tonumber(_GetClientConVar_String(userid,"gm_dynamite_delay_add"));
		VMFCG.Entities[dynamite]:SetKeyValue("delay",delay-delay_add);
		VMFCG.Entities[dynamite]:SetKeyValue("rendercolor","255 0 0"); -- A dynamite is normally red :P
	end
end

-- ############## Material @aVoN
function VMFCG.tools.material ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	local ent = t:GetEnt();
	if(ent ~= 0) then
		if(key == IN_ATTACK) then
			local matmode = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_matmode")));
			VMFCG.Entities[ent]:SetKeyValue("_material",VMFCG.defines.materials[matmode+1]); -- The pseudo material key/value, introduced in VMFLoader
			VMFCG.Entities[ent]:SetKeyValue("materialoverride",VMFCG.defines.materials[matmode+1]); -- Correct key/value
			VMFCG.debug("VMFCG.tools.material","Material applyed");
		else
			VMFCG.Entities[ent]:SetKeyValue("_material",nil);
			VMFCG.Entities[ent]:SetKeyValue("materialoverride",nil); -- Correct key/value
			VMFCG.debug("VMFCG.tools.material","Material removed");
		end
	end
end

-- Render Target Camera not recognized

-- EmptyToolmode 22 not recognized

-- ############## Thrusters @aVoN
function VMFCG.tools.thrusters ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	local session = VMFCG.tools.users[userid].session;
	session.pos1 = t:EndPos();
	session.ent1 = t:GetEnt();
	session.sfnormal = t:GetSurfaceNormal();
	session.ent_pos1 = _EntGetPos(session.ent1);
	VMFCG.tools.users[userid].session = session;
	VMFCG.AddTimerOnce("VMFCG.tools.thrusters_callback:"..userid..":"..tostring(t),0.1,1,VMFCG.tools.thrusters_callback,userid,session);
	VMFCG.debug("VMFCG.tools.thrusters","Thrusters");
end

-- ############## Thrusters @aVoN
function VMFCG.tools.thrusters_callback ( userid, session )
	local search_pos = session.pos1;
	if(session.ent1 ~= 0) then
		search_pos = vecAdd(vecSub(session.pos1,session.ent_pos1),_EntGetPos(session.ent1));
	end
	local thruster = VMFCG.tools.FindEntity(
	{
		class = "physics_thruster",
		origin = search_pos,
		radius = 15,
		checkadded = true,
	})
	if(thruster > 0) then
		local already_attached_thrusters_count_with_same_direction = 0;
		local attach_side = vecDotProduct(session.sfnormal,_EntGetAng(session.ent1));
		-- Avoiding Bug, where sometimes the dot product has a 1.000000001 as valuem which causes the acos to fail
		if(attach_side > 1) then
			attach_side = 1;
		end
		if(attach_side < -1) then
			attach_side = -1;
		end
		local multiplyer = 1;
		if(attach_side < 0) then
			multiplyer = -1;
		end
		local direction_angle = math.deg(math.acos(attach_side))*multiplyer;
		for _,v in _EntitiesFindByClass("physics_thruster") do
			if(VMFCG.Entities.Exists(v) and _EntGetParent(v) == session.ent1) then
				local t_dang = tonumber(VMFCG.Entities[v]:GetKeyValue("_directionangle"));
				if(t_dang) then
					if(t_dang < direction_angle + 50 and t_dang > direction_angle - 50) then
						already_attached_thrusters_count_with_same_direction = already_attached_thrusters_count_with_same_direction + 1;
					end
				end
			end
		end
		if(VMFCG.config.thruster_threshold ~= 0 and already_attached_thrusters_count_with_same_direction >= (VMFCG.config.thruster_threshold or 10)) then
			_EntRemove(thruster);
			return;
		end
		local thrust = tonumber(_GetClientConVar_String(userid,"gm_thrust_power"));
		VMFCG.Entities[thruster]:SetKeyValue("thrust",thrust);
		VMFCG.Entities[thruster]:SetKeyValue("_collision",false);
		VMFCG.Entities[thruster]:SetKeyValue("_directionangle",direction_angle);
		VMFCG.Entities[thruster]:SetParent(session.ent1);
		if(session.ent1 > 0 and _EntGetType(session.ent1) ~= "physics_thruster") then -- Don't allow thrusters on world and thrusters on thrusters!
			local constraint = VMFCG.tools.FindEntity(
			{
				class = "phys_constraint",
				origin = _EntGetPos(thruster),
				radius = 15,
				checkadded = true,
			})
			-- The weld!
			VMFCG.Entities[constraint]:SetKeyValue("attach1",thruster);
			VMFCG.Entities[constraint]:SetKeyValue("attach2",session.ent1);
			VMFCG.Entities[constraint]:SetParent(thruster);
		else
			_EntRemove(thruster);
		end
	end
end

--[[
-- It seems, physprops uses a direct engine access, garry coded, like no collide. No way, to save or better reset the values to props :(
-- ############## PhysProps @aVoN
function VMFCG.tools.physprops ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	VMFCG.debug("VMFCG.tools.physprops","Phys Properties");
end
--]]
-- Statue not recognized
-- ############## Balloons @aVoN
function VMFCG.tools.balloons ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	local session = VMFCG.tools.users[userid].session;
	session.pos1 = t:EndPos();
	session.ent1 = t:GetEnt();
	session.ent_pos1 = _EntGetPos(session.ent1);
	VMFCG.tools.users[userid].session = session;
	VMFCG.AddTimerOnce("VMFCG.tools.balloons:"..userid..":"..tostring(t),0.1,1,VMFCG.tools.balloons_callback,userid,session);
	VMFCG.debug("VMFCG.tools.balloons","Balloons");
end

-- ############## Balloons callback@aVoN
function VMFCG.tools.balloons_callback ( userid, session )
	local search_pos = session.pos1;
	local rope_attach1 = 0;
	if(session.ent1 ~= 0) then
		search_pos = vecAdd(vecSub(session.pos1,session.ent_pos1),_EntGetPos(session.ent1));
		rope_attach1 = VMFCG.tools.FindEntity(
		{
			model = "models/weapons/w_bugbait.mdl",
			parent = session.ent1,
			origin = search_pos,
			radius = 60,
			checkadded = true,
		})
	end
	-- ############## Find balloons
	local balloon = VMFCG.tools.FindEntity(
	{
		class = "physics_balloon",
		origin = search_pos,
		radius = 60,
		checkadded = true,
	})
	if(balloon > 0) then
		-- It's a simple ballon with no attachments
		local power = tonumber(_GetClientConVar_String(userid,"gm_balloon_power"));
		local reverse = tonumber(_GetClientConVar_String(userid,"gm_balloon_reverse"));
		--local bexplode = tonumber(_GetClientConVar_String(userid,"gm_balloon_explode")); -- Yeah, i know, I'm too lazy, right now to add the explosive setting
		if(reverse == 1) then
			power = power * -1;
		end
		VMFCG.Entities[balloon]:SetKeyValue("power",power);
		-- The actions below are made, so the selection engine wont uncolorize the ballon and undo it's material
		VMFCG.Entities[balloon]:SetKeyValue("rendercolor",VMFCG.defines.BalloonColor[math.random(1,table.getn(VMFCG.defines.BalloonColor))],true); -- Set a random color to this balloon.
		VMFCG.Entities[balloon]:SetKeyValue("_material","gmod/shiny"); -- And the default material
		if(session.ent1 ~= 0) then
			local constraint = VMFCG.tools.FindEntity(
			{
				class = "phys_lengthconstraint",
				origin = _EntGetPos(balloon),
				radius = 30,
				checkadded = true,
			})
			if(constraint > 0) then
				local addlength = tonumber(_GetClientConVar_String(userid,"gm_balloon_rope_length"));
				local forcelimit = tonumber(_GetClientConVar_String(userid,"gm_balloon_rope_forcelimit"));
				local attachpoint = _EntGetPos(rope_attach1);
				-- ############## The lengthconstraint
				VMFCG.Entities[constraint]:SetParent(balloon);
				VMFCG.Entities[constraint]:SetKeyValue("forcelimit",forcelimit);
				VMFCG.Entities[constraint]:SetKeyValue("addlength",addlength);
				VMFCG.Entities[constraint]:SetKeyValue("attach1",balloon);
				VMFCG.Entities[constraint]:SetKeyValue("attach2",session.ent1);
				VMFCG.Entities[constraint]:SetKeyValue("attachpoint",vecString(attachpoint));
				VMFCG.Entities[constraint]:SetKeyValue("_attachentity",rope_attach1);
				VMFCG.Entities[constraint]:SetKeyValue("_length",0); -- Saves length - used, to calculate the addlength (extralength) later (or it will fuck up)
				-- ############## The needed Bugbait, which indicates the position of the attachpoint for the rope/lengthconstraint
				-- Make it invisible and parent it (even when it's parented by default
				VMFCG.Entities[rope_attach1]:SetClass("prop_dynamic_override"); -- Needed, so it doesn't get saved as prop_physics and crash the server
				VMFCG.Entities[rope_attach1]:SetKeyValue("solid",0);
				VMFCG.Entities[rope_attach1]:SetKeyValue("rendermode",3);
				VMFCG.Entities[rope_attach1]:SetKeyValue("renderamt",0);
				-- Deactivated like in the normal rope mode, because of Fuck/Up :D
				--VMFCG.Entities[rope_attach1]:SetKeyValue("_killhierarchy",balloon); -- Kilhierarchy to the phys_ entity = lesser spam and smaller VMFs
				VMFCG.Entities[rope_attach1]:SetParent(session.ent1);
				local keyframe_rope = VMFCG.tools.FindEntity(
				{
					class = "keyframe_rope",
					origin = _EntGetPos(balloon),
					distance = 13.37*VMFCG.config.accuracy, -- Normaly, its around 8 or 9 (for me) on singleplayer, but i found out, on multiplayer, it needs to be higher
					checkadded = true,
				})
				if(keyframe_rope > 0) then
					local rope_width = tonumber(_GetClientConVar_String(userid,"gm_balloon_rope_width"));
					local rope_material = tonumber(_GetClientConVar_String(userid,"gm_balloon_rope_type"));
					VMFCG.Entities[keyframe_rope]:SetKeyValue("NextKey",rope_attach1);
					VMFCG.Entities[keyframe_rope]:SetKeyValue("Slack",0); -- Extralength (0 for rope :P) - Other extralength is handles by the phys_lengthconstraint :D
					VMFCG.Entities[keyframe_rope]:SetKeyValue("Width",rope_width);
					VMFCG.Entities[keyframe_rope]:SetKeyValue("RopeMaterial",VMFCG.defines.RopeMaterial[rope_material]);
					VMFCG.Entities[keyframe_rope]:SetParent(balloon); -- Parent it to the balloon
				end
			end
		end
		VMFCG.debug("VMFCG.tools.balloons","Balloons done");
	end
end
--[[
-- Currently, I really don't know, how the emitters work (gmod's own entity types... need to ask garry..)
-- ############## Emitter @aVoN
function VMFCG.tools.emitter ( userid, key )
	local t = VMFCG.TraceLine:NewUser(userid);
	VMFCG.debug("VMFCG.tools.emitter","Emitter");
end
--]]
-- ############## Sprites @aVoN
function VMFCG.tools.sprites ( userid, key )
	if(key == IN_ATTACK2) then
		local t = VMFCG.TraceLine:NewUser(userid);
		local session = VMFCG.tools.users[userid].session;
		session.pos1 = t:EndPos();
		VMFCG.tools.users[userid].session = session;
		VMFCG.debug("VMFCG.tools.sprites","Sprites");
		VMFCG.AddTimerOnce("VMFCG.tools.sprites_callback:"..userid..":"..tostring(t),0.1,1,VMFCG.tools.sprites_callback,userid,session);
	end
end

-- ############## Sprites callback @aVoN
function VMFCG.tools.sprites_callback ( userid, session )
	local placement = VMFCG.tools.FindEntity(
	{
		class = "prop_placement",
		origin = session.pos1,
		radius = 30,
		checkadded = true,
	})
	if(placement > 0) then
		VMFCG.Entities[placement]:SetKeyValue("renderfx",5); -- Slow fadeout
		local sprite = VMFCG.tools.FindEntity(
		{
			class = "env_sprite",
			origin = _EntGetPos(placement),
			radius = 10,
			checkadded = true,
		})
		if(sprite > 0) then
			session.sprite_entity = sprite;
			VMFCG.Entities[sprite]:SetKeyValue("spawnflags","1");
			VMFCG.tools.users[userid].session = session;
			-- Adds a timer, which get's called every 0.1 second to update the color/etc of the sprite, when added
			VMFCG.AddTimerOnce("VMFCG.tools.sprites_callback_timer:"..userid..":"..v,0.1,0,VMFCG.tools.sprites_callback_timer,userid,sprite);
		end
	end
end

-- ############## Sprites callback timer @aVoN
function VMFCG.tools.sprites_callback_timer(userid,entity)
	local session = VMFCG.tools.users[userid].session;
	if(not VMFCG.tools.isTool( userid ) or VMFCG.tools.ToolMode( userid ) ~= 28 or session.sprite_entity ~= entity or not _EntExists(entity)) then
		-- break this update time, when the person switched to another toolgun/weapon or the sprite-entity has changed or the entity doesn't exist anymore
		VMFCG.HaltTimerOnce("VMFCG.tools.sprites_callback_timer:"..userid..":"..entity);
	end
	local r = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_sprite_colour_r")));
	local g = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_sprite_colour_g")));
	local b = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_sprite_colour_b")));
	local a = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_sprite_colour_a")));
	local scale = tonumber(_GetClientConVar_String(userid,"gm_sprite_size"));
	local rendermode = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_sprite_rm")));
	local renderfx = math.ceil(tonumber(_GetClientConVar_String(userid,"gm_sprite_rfx")));
	VMFCG.Entities[entity]:SetKeyValue("rendercolor",r.." "..g.." "..b);
	VMFCG.Entities[entity]:SetKeyValue("renderamt",a);
	VMFCG.Entities[entity]:SetKeyValue("renderfx",renderfx);
	VMFCG.Entities[entity]:SetKeyValue("rendermode",rendermode);
	if(scale ~= 0) then
		VMFCG.Entities[entity]:SetKeyValue("scale",scale);
	end
end

-- ############## Wheels @aVoN
function VMFCG.tools.wheels ( userid, key ) -- Alias of axis
	local t = VMFCG.TraceLine:NewUser(userid);
	local ent = t:GetEnt();
	local session = VMFCG.tools.users[userid].session;
	session.type = "Wheels";
	-- For compatibility reasons, we need to put pos1 = pos2, so we can use the axis_callback for wheels too = lesser code
	session.surface_normal2 = t:GetSurfaceNormal();
	session.pos2 = t:EndPos();
	session.ent_pos2 = _EntGetPos(ent);
	session.ent2 = ent;
	VMFCG.AddTimerOnce("VMFCG.tools.wheels:"..userid..":"..tostring(t),0.01,1,VMFCG.tools.wheels_callback,userid,session);
	VMFCG.tools.users[userid].session = session;
	VMFCG.debug("VMFCG.tools.wheels","Wheels");
end

-- ############## Wheels Callback @aVoN
function VMFCG.tools.wheels_callback(userid,session)
	local search_pos = session.pos2;
	if(session.ent2 ~= 0) then
		search_pos = vecAdd(vecSub(session.pos2,session.ent_pos2),_EntGetPos(session.ent2));
	end
	local wheel = VMFCG.tools.FindEntity(
	{
		class = "prop_wheel",
		origin = search_pos,
		radius = 15,
		checkadded = true,
	})
	if(wheel > 0) then
		-- We don't really need the prop_wheel get added to the entity list, because it doesn't have any special keyvalues, we need - But we need it to make the check above work correctly
		VMFCG.Entities[wheel]:SetKeyValue("aVoN is to 1337 for you",nil);-- Nothing happens :D
		session.ent1 = wheel;
		-- Now add the phys hinge with the axis callback
		VMFCG.tools.axis_callback(userid,session);
	end
end

-- #############################################
-- ############### Physgun Freezer ####################
-- #############################################
-- Even, when it doesn't belong to the toolgun, its a type of tool. - It handles the _spawnfrozen tag in the VMFs

-- ##############
function VMFCG.tools.HandleFreeze(userid,ent,freeze)
	if(_EntGetType(ent) ~= "prop_vehicle_jeep") then -- Prevents the game from crashing -> You cant freeze a jeep
		if(VMFCG.PropProtector_AllowedToUseEntity(userid,ent)) then
			if(freeze) then
				VMFCG.Entities[ent]:SetKeyValue("_spawnfrozen","true");
				VMFCG.debug("VMFCG.tools.HandleFreeze:"..userid,"Frozen prop "..ent);
			else
				if(VMFCG.Entities.Exists(ent)) then
					VMFCG.Entities[ent]:SetKeyValue("_spawnfrozen",nil);
					VMFCG.debug("VMFCG.tools.HandleFreeze:"..userid,"UnFrozen prop "..ent);
				end
			end
		end
	end
end

-- ############## PhysgunAction Pickup @aVoN
function VMFCG.tools.PhysGunPickup(userid,ent)
	VMFCG.tools.HandleFreeze(userid,ent,false);
end

-- ############## PhysgunAction Freeze @aVoN
function VMFCG.tools.PhysGunFreeze(userid,ent)
	VMFCG.tools.HandleFreeze(userid,ent,true);
end

-- ############## GravgunAction Punt @aVoN
function VMFCG.tools.GravGunPunt(userid,ent)
	VMFCG.tools.HandleFreeze(userid,ent,false);
end

-- #############################################
-- ############### NPC Weapon fetcher #################
-- #############################################
-- Same like for the physgun. NPC belong to the toolsection

-- ############## Fetches NPCs, which newly get spawned and applys the weapon to them @aVoN
function VMFCG.tools.NPCWeaponFetcher()
	for _,v in _EntitiesFindByClass("npc_*") do
		if(not VMFCG.Entities.Exists(v) and _EntGetType(v) ~= "npc_heli_avoidsphere") then
			local weapon = nil;
			for _,w in _EntitiesFindInSphere(_EntGetPos(v),2) do 
				if(w ~= v and _EntGetParent(w) == v) then
					if(string.find(_EntGetType(w),"weapon_")) then
						weapon = string.gsub(_EntGetType(w),"ai$","");
						break;
					end
				end
			end
			if(weapon) then
				-- Either set the correct weapon (if existant), or don't set any weapon, but register the NPC in the Entity cache
				VMFCG.Entities[v]:SetKeyValue("additionalequipment",weapon);
				VMFCG.debug("VMFCG.tools.NPCWeaponFetcher","Set weapon '"..weapon.."' to NPC '"..v.."'");
			end
		end
	end
end

-- #############################################
-- ############### Effect Base fetcher ##################
-- #############################################

-- ############## Gets the base of an affect like porta funel etc and not only the prop_placement @aVoN
function VMFCG.tools.EffectSetter()
	for _,v in _EntitiesFindByClass("prop_placement") do
		if(not VMFCG.Entities.Exists(v)) then
			local effect = VMFCG.tools.FindEntity(
			{
				class = "prop_physics",
				origin = _EntGetPos(v),
				radius = 150,
				checkadded = true,
			})
			if(effect > 0) then
				VMFCG.Entities[effect]:SetParent(v);
				VMFCG.Entities[effect]:SetKeyValue("disableshadows",1);
				VMFCG.debug("VMFCG.tools.EffectSetter","Added effect "..effect);
			end
		end
	end
end

-- #############################################
-- ################### Init #######################
-- #############################################

-- Neccessary timers
VMFCG.AddTimerOnce("VMFCG.tools.CheckToolgunThink",0.05,0,VMFCG.tools.CheckToolgunThink);
VMFCG.AddTimerOnce("VMFCG.tools.NPCWeaponFetcher",5,0,VMFCG.tools.NPCWeaponFetcher);
VMFCG.AddTimerOnce("VMFCG.tools.NPCWeaponFetcher",5,0,VMFCG.tools.EffectSetter);

-- Supported constraints
VMFCG.tools.toolmodes[0] = VMFCG.tools.rope;
VMFCG.tools.toolmodes[1] = VMFCG.tools.elastic;
VMFCG.tools.toolmodes[2] = VMFCG.tools.weld;
VMFCG.tools.toolmodes[3] = VMFCG.tools.ballsocket;
VMFCG.tools.toolmodes[4] = VMFCG.tools.pulley;
VMFCG.tools.toolmodes[5] = VMFCG.tools.easyweld;
VMFCG.tools.toolmodes[6] = VMFCG.tools.easyballsocket;
VMFCG.tools.toolmodes[7] = VMFCG.tools.axis;
VMFCG.tools.toolmodes[8] = VMFCG.tools.slider;
VMFCG.tools.toolmodes[9] = VMFCG.tools.nailgun;
VMFCG.tools.toolmodes[15] = VMFCG.tools.duplicate;
VMFCG.tools.toolmodes[16] = VMFCG.tools.color;
VMFCG.tools.toolmodes[17] = VMFCG.tools.magnetise;
VMFCG.tools.toolmodes[18] = VMFCG.tools.nocollide;
VMFCG.tools.toolmodes[19] = VMFCG.tools.dynamite;
VMFCG.tools.toolmodes[20] = VMFCG.tools.material;
VMFCG.tools.toolmodes[23] = VMFCG.tools.thrusters;
--VMFCG.tools.toolmodes[24] = VMFCG.tools.physprops; -- Not supported
VMFCG.tools.toolmodes[26] = VMFCG.tools.balloons;
--VMFCG.tools.toolmodes[27] = VMFCG.tools.emitter; -- Not supported
VMFCG.tools.toolmodes[28] = VMFCG.tools.sprites;
VMFCG.tools.toolmodes[29] = VMFCG.tools.wheels;

--Events
VMFCG.HookOnce("eventKeyPressed" , VMFCG.tools.eventKeyPressed , "VMFCG.tools.eventKeyPressed" )
VMFCG.HookOnce("eventKeyReleased" , VMFCG.tools.eventKeyReleased , "VMFCG.tools.eventKeyReleased" )

VMFCG.HookOnce("onPhysPickup",VMFCG.tools.PhysGunPickup,"VMFCG.tools.PhysGunPickup");
VMFCG.HookOnce("onPhysFreeze",VMFCG.tools.PhysGunFreeze,"VMFCG.tools.PhysGunFreeze");
VMFCG.HookOnce("onGravGunPunt",VMFCG.tools.GravGunPunt,"VMFCG.tools.GravGunPunt");