--[[

	#############################################
	
		VMF CopyGun - Handles Chat and Console Commands
		
	#############################################
	
]]--

VMFCG.Commands = {};
VMFCG.Commands.triggers = {};

-- ############## Adds a command to the concommand list and the chatcommand triggers @aVoN
function VMFCG.Commands.Add(name,callback,...)
	CONCOMMAND(name,callback); -- Add the general console command
	local chatcommands = {unpack(arg)};
	for _,v in chatcommands do
		VMFCG.Commands.triggers[string.lower(v)] = callback;
	end
	VMFCG.debug("VMFCG.Commands.Add","Added VMFCG Command '"..tostring(name).."' (chat: '"..tostring(chatcommand).."')");
end

-- ############## Anytime, a player says something, this will get triggered for the commands @aVoN
function VMFCG.Commands.eventPlayerSay(userid,str,team)
	if(str) then
		if(userid == 0) then return end;
		local pos = string.find(str,": ");
		str = string.sub(str,pos+2);
		local expl = VMFCG.explode(VMFCG.trim(str)," ",1);
		for k,v in VMFCG.Commands.triggers do
			if(k == string.lower(expl[1])) then
				v(userid,(expl[2]) or "");
				VMFCG.debug("VMFCG.Commands.eventPlayerSay","Player "..userid.." triggered chatcommand '"..k.."'");
				break;
			end
		end
	end
end


-- #############################################
-- ################### Init #######################
-- #############################################

VMFCG.HookOnce( "eventPlayerSay" , VMFCG.Commands.eventPlayerSay , "VMFCG.Commands.eventPlayerSay");