--[[

	#############################################
	
		VMF CopyGun - Ent helper class.
		
	#############################################
	
]]--

VMFCG.Ent = {};
VMFCG.Ent.Precached = {};

-- #############################################
-- ############### Fetching Entitys ####################
-- #############################################

-- ############## Get Entity by ID (object)  @H-=NooB=- (modified by aVoN)

function VMFCG.Ent:GetById(entid)

	local obj = {};
	
	if(not _EntExists(entid)) then return nil end;
	
	setmetatable(obj,self);
	self.__index = self;
	
	obj.keys = {};
	obj.connections = {};
	obj.class = 	_EntGetType(entid);
	obj.keys["classname"] = obj.class;
	-- Vehicle addon, which handles some special default key/value pairs needed for them.
	obj.model = 	_EntGetModel(entid);
	if(obj.model ~= "") then
		obj.keys["model"] = obj.model;
	end
	if(obj.class == "prop_vehicle_jeep") then
		local script = VMFCG.defines.vehicles.scripts[obj.model] or "scripts/vehicles/jeep_test.txt";
		obj.keys["vehiclescript"] = script;
		obj.keys["solid"] = "6";
		obj.keys["fademindist"] = "-1";
		obj.keys["fadescale"] = "1";
		obj.keys["actionscale"] = "1";
	end
	if(obj.class == "prop_vehicle_airboat") then
		local script = "scripts/vehicles/airboat.txt";
		obj.keys["vehiclescript"] = script;
		obj.keys["solid"] = "6";
		obj.keys["fademindist"] = "-1";
		obj.keys["fadescale"] = "1";
		obj.keys["actionscale"] = "1";
	end
	if(obj.class == "prop_vehicle_prisoner_pod") then
		local script = "scripts/vehicles/prisoner_pod.txt";
		obj.keys["vehiclescript"] = script;
		obj.keys["solid"] = "6";
	end
	obj.mass = 	_phys.GetMass(entid);
	-- Only when it get's set by other scripts, add it. This reduces the size of the created VMFs later ;)
		--obj.keys["_mass"] = obj.mass;
	obj.ang = 	_EntGetAng(entid);
	obj.ang2 = 	_EntGetAngAngle(entid);
		obj.keys["angles"] = vecString(obj.ang2);
	obj.sleep = _phys.IsAsleep(entid);
	obj.parent = 	_EntGetParent(entid);
	if(obj.parent ~= 0) then
		local parent_name = _EntGetName(obj.parent);
		if(parent_name ~= "") then
			obj.keys["parentname"] = parent_name;
		else
			obj.keys["parentname"] = obj.parent;
		end
	end
	obj.name = 	_EntGetName(entid);
	if(obj.name ~= "") then
		obj.keys["targetname"] = obj.name;
	end
	obj.pos = 	_EntGetPos(entid);
		obj.keys["origin"] = vecString(obj.pos);
	--obj.maxhp = 	_EntGetMaxHealth(entid);
	--[[Not needed now - Functions need to get coded for these values
		obj.velocity = _EntGetVelocity(entid); 
		obj.forvec = 	_EntGetForwardVector(entid);
		obj.upvec = 	_EntGetUpVector(entid);
		obj.rightvec = _EntGetRightVector(entid);
		obj.physattack = _EntityGetPhysicsAttacker(entid);
		obj.groundent = _EntGetGroundEntity(entid);
	--]]
	obj.mtype = _EntGetMoveType(entid);
	if(obj.mtype ~= MOVETYPE_VPHYSICS) then
		obj.keys["_movetype"] = obj.mtype;
	end
	obj.solid = _EntGetSolid(entid);
		obj.keys["solid"] = obj.solid;
	--obj.mcoll = _EntGetMoveCollide(entid);
	--obj.collgrp = _EntGetCollisionGroup(entid);
	
	obj.id = entid;
	return obj;
end

-- ############## Gets an entitiy id (number)  @aVoN
function VMFCG.Ent:GetId()
	if(self.id ~= nil) then
		return self.id;
	else
		return 0; -- Means, it's not created right now
	end
end

-- ############## Does this entity exists? (boolean)  @aVoN
function VMFCG.Ent:Exists()
	if(not _EntExists(self.id) or self.pseudo) then
		return false;
	end
	return true;
end

-- ############## Create Entity (doesn't spawn it) (object)  @H-=NooB=-
function VMFCG.Ent:Create(class)
	local obj = {};
	obj.id = _EntCreate(class);
	obj = self:GetById(obj.id);
	return obj;
end

-- ############## Create pseudo entity (object)  @H-=NooB=-
function VMFCG.Ent:CreatePseudo(id,class)
	local obj = {};
	setmetatable(obj,self);
	self.__index = self;
	obj.class = class;
	obj.keys = {};
	obj.pseudo = true;
	obj.connections = {};
	obj.id = id;
	obj.keys["classname"] = class;
	return obj;
end


-- #############################################
-- ############### Key/Values #######################
-- #############################################


-- ############## Set key value (void)  @H-=NooB=- (modified by aVoN)
function VMFCG.Ent:SetKeyValue(key,value,setnow)
	if(self.pseudo) then
		if(key == "origin") then
			local vPos = VMFCG.explode(value," ");
			if(type(vPos) == "table") then
				if(table.getn(vPos) == 3) then
					self:SetPos(vector3(vPos[1],vPos[2],vPos[3]));
				end
			end
		end
		if(key == "angles") then
			local vAng = VMFCG.explode(value," ");
			if(type(vAng) == "table") then
				if(table.getn(vAng) == 3) then
					self:SetAngAngle(vector3(vAng[1],vAng[2],vAng[3]));
				end
			end
		end
		self.keys[key] = value;
		return;
	end
	-- Special for the hinge
	if(key == "hingeaxis" or key == "slideaxis") then
		local fixup_axis = function(self)
			local parent = self:GetParent(); -- Get old parent
			-- ############## Unparent this entity! - Neccessary, because the set Angle won't get apllyed!
			if(parent ~= 0) then
				self:SetParent(0);
			end
			local t = VMFCG.explode(value," "); -- Explode to a table
			local vAxis = vector3(t[1],t[2],t[3]);
			local vPos = self:GetPos(self.id);
			-- For some reason, the vector fucks up when i don't multiply it with -1
			local ang = vecNormalize(vecSub(vAxis,vPos)); -- Get normalized vector from entity start to hinge axis
			-- Now set the Ang with the hingeaxis value for the prop, so the Ang is represents the hingeaxis
			self:SetAng(ang);
			if(parent ~= 0) then
				self:SetParent(parent); -- Reset the parent
			end
		end
		-- Runs this check, after a certain timout, when the entity is spawned. Otherwise, some props, like VMFLoader spawned entity, which doesn't have an "origin" keyvalue produce wrong hingexis, when they arent spawned or the origin isn't set by now
		if(not _EntExists(self.id) or vecLength(_EntGetPos(self.id),vector3(0,0,0)) == 0) then
			VMFCG.AddTimerOnce("VMFCG.Ent:SetKeyValue:"..self.id,0.01,1,fixup_axis,self);
		else
			-- Otherwise set right now
			fixup_axis(self);
		end
	end
	if(setnow == true) then
		if(_EntExists(self.id)) then
			local new_value = value;
			local done = false;
			if(value == nil) then
				new_value = "";
			end
			-- Color and rendermodes
			if(value == nil or value == "") then
				if(key == "rendercolor") then
					new_value = "255 255 255";
				end
				if(key == "renderamt") then
					new_value = "255";
				end
				if(key == "renderfx") then
					new_value = "0";
				end
				if(key == "rendermode") then
					new_value = "1";
				end
			end
			-- Material
			if(key == "materialoverride") then
				self.keys["_material"] = new_value;
			end
			-- Some workaround - Otherwise, they will disappear for some reason
			if(string.find(key,"attach[12]")) then
				local id = VMFCG.Entities.getEntId(new_value);
				if(id ~= 0) then
					local name = _EntGetName(id);
					if(name == "") then
						-- He hasnt a target name - Apply one!
						new_value = "vmfcg_temp_"..id;
						VMFCG.core._EntSetName(id,new_value);
					else
						 -- The attached prop has a targetname, so leave it
						new_value = name;
					end
				end
			end
			if(key == "angles") then
				if(self:HasKey("hingeaxis") or self:HasKey("slideaxis")) then
					return false; -- Don't set any angles when hingeaxis or slideaxis is set
				end
			end
			if(string.sub(key,1,1) ~= "_" ) then
				if(not done) then
					VMFCG.core._EntSetKeyValue(self.id,key,new_value);
				end
			else
				if(key == "_gravity") then
					-- For a reason, i don't understand, you cant ungrav a prop on direct spawn.
					if(VMFCG.tobool(new_value) == false) then
						VMFCG.AddTimerOnce("VMFCG.core._PhysEnableGravity:"..self.id,0.01,1,VMFCG.core._PhysEnableGravity,self.id,false);
					else
						VMFCG.AddTimerOnce("VMFCG.core._PhysEnableGravity:"..self.id,0.01,1,VMFCG.core._PhysEnableGravity,self.id,true);
					end
				end
				if(key == "_collision") then
					-- For a reason, i don't understand, you cant set collision on a prop on direct spawn.
					if(VMFCG.tobool(new_value) == false) then
						VMFCG.AddTimerOnce("VMFCG.core._PhysEnableCollisions:"..self.id,0.01,1,VMFCG.core._PhysEnableCollisions,self.id,false);
					else
						VMFCG.AddTimerOnce("VMFCG.core._PhysEnableCollisions:"..self.id,0.01,1,VMFCG.core._PhysEnableCollisions,self.id,true);
					end
				end
				if(key == "_mass") then
					self:SetMass(new_value);
				end
				if(key == "_movetype") then
					if(new_value ~= "") then
						self:SetMoveType(new_value);
					end
				end
				if(key == "_material") then
					self.keys["materialoverride"] = new_value;
					VMFCG.core._EntSetMaterial(self.id,new_value);
				end
			end
		end
	end
	self.keys[key] = value;
	if(key == "model") then
		self:PrecacheModel();
	end
end

-- ############## Sets a table of keyvalues to the ent (void)  @aVoN
function VMFCG.Ent:SetAllKeyValues(t)
	for k,v in self:GetAllKeyValues() do
		-- First, unset all old key/values which are not recognized in the new table
		if(not t[k]) then
			self:SetKeyValue(k,nil,true);
		end
	end
	for k,v in t do
		self:SetKeyValue(k,v,true);
	end
end

-- ############## Apply Key Value changes  (void)  @H-=NooB=- (modified by aVoN)
function VMFCG.Ent:ApplyKeyValues()
	if(_EntExists(self.id) and not self.pseudo) then
		self:GetAllKeyValues(); -- First, fetch all keyvalues/update them
		-- This part is needed or it will cause an luaerror
		local temp_kv = {}
		for k,v in self.keys do
			temp_kv[k] = v;
		end
		for k,v in temp_kv do
			if(string.sub(k,1,1) ~= "_") then -- Don't apply the pseudo key/values - They are for the VMFLoader
				self:SetKeyValue(k,v,true);
			else
				if(k == "_gravity") then
					-- For a reason, i don't understand, you cant ungrav a prop on direct spawn.
					if(VMFCG.tobool(v) == false) then
						VMFCG.AddTimerOnce("VMFCG.core._PhysEnableGravity:"..self.id,0.01,1,VMFCG.core._PhysEnableGravity,self.id,false);
					else
						VMFCG.AddTimerOnce("VMFCG.core._PhysEnableGravity:"..self.id,0.01,1,VMFCG.core._PhysEnableGravity,self.id,true);
					end
				end
				if(k == "_collision") then
					-- For a reason, i don't understand, you cant set collision on a prop on direct spawn.
					if(VMFCG.tobool(v) == false) then
						VMFCG.AddTimerOnce("VMFCG.core._PhysEnableCollisions:"..self.id,0.01,1,VMFCG.core._PhysEnableCollisions,self.id,false);
					else
						VMFCG.AddTimerOnce("VMFCG.core._PhysEnableCollisions:"..self.id,0.01,1,VMFCG.core._PhysEnableCollisions,self.id,true);
					end
				end
				if(k == "_mass") then
					self:SetMass(v);
				end
				if(k == "_movetype") then
					self:SetMoveType(v);
				end
				if(k == "_material") then
					VMFCG.core._EntSetMaterial(self.id,v);
				end
			end
		end
		if(self:IsAsleep()) then
			self:Awake() -- Now, the changes got applied only!
		end
	end
end		

-- ############## Get a keyvalue (string)  @H-=NooB=- (modified by aVoN)
function VMFCG.Ent:GetKeyValue(key)
	if(self.pseudo) then
		if(self.keys[key] ~= nil) then
			return self.keys[key];
		end
		return "";
	end
	if(key == "origin") then
		self.pos = self:GetPos();
		self.keys[key] = vecString(self.pos);
	end
	if(key == "angles") then
		self.ang2 = self:GetAngAngle();
		self.keys[key] = vecString(self.ang2);
	end
	if(key == "model") then
		local model = self:GetModel();
		if(model ~= "") then
			self.keys[key] = self:GetModel();
		end
	end
	if(key == "parentname") then
		local parent_id = self:GetParent();
		local name = _EntGetName(parent_id);
		if(name ~= "") then
			self.keys[key] = name;
		else
			self.keys[key] = parent_id;
		end
	end
	if(key == "targetname") then
		if(_EntExists(self.id)) then
			self.name = _EntGetName(self.id);
			if(self.name ~= "" or (self.keys[key] ~= self.name and self.keys[key] ~= nil)) then
				self.keys[key] = self.name;
			end
		end
	end
	if(self.keys[key] ~= nil) then
		if(key == "hingeaxis" or key == "slideaxis") then
			-- Special for hingeaxis like in the SetKeyValue part
			local ang = self:GetAng();
			local Axis = vecAdd(self:GetPos(),ang);
			self.keys[key] = vecString(Axis);
		end
		if(string.lower(key) == "slack") then
			local attachentity = VMFCG.Entities.getEntId(self.keys["NextKey"]);
			if(attachentity ~= 0) then
				local new_slack = vecLength(self:GetPos(),_EntGetPos(attachentity));
				self.keys[key] = -new_slack;
			end
		end
		if(key == "addlength") then
			-- Special for pulley!
			local length = self.keys["_length"];
			if(length) then
				local attach1 = self:GetPos();
				local attach2 = VMFCG.Entities.getEntId(self.keys["_attachentity"]);
				if(attach2 == 0) then
					local search_point = self.keys["attachpoint"];
					local temp = VMFCG.explode(search_point," ");
					attach2 = vector3(temp[1],temp[2],temp[3]);
				else
					attach2 = _EntGetPos(attach2);
				end
				local add_length = self.keys["addlength"];
				if(self:GetClass() == "phys_pulleyconstraint") then
					add_length = 0;
				end
				local cur_length = vecLength(vecSub(attach1,attach2));
				local new_addlength = length - cur_length + add_length;
				return new_addlength;
			end
		end
		if(key == "_length") then
			local class = self:GetClass();
			-- Never change on phys_spring (constant) and for phys_pulleyconstraint (only neccessary for some calculation of addlength)
			if(class ~= "phys_spring" and class ~= "phys_pulleyconstraint") then
				local attach1 = _EntGetPos(self.id);
				local attach2 = VMFCG.Entities.getEntId(self.keys["_attachentity"]);
				if(attach2 == 0) then
					local search_point = "attachpoint";
					local temp = VMFCG.explode(self.keys[search_point]," ");
					attach2 = vector3(temp[1],temp[2],temp[3]);
				else
					attach2 = _EntGetPos(attach2);
				end
				local cur_length = vecLength(vecSub(attach1,attach2));
				return cur_length;
			end
		end
		-- For phys_lengthconstraint and phys_spring
		if(key == "attachpoint" or key == "springaxis") then
			local attach_entity = VMFCG.Entities.getEntId(self.keys["_attachentity"]);
			if(_EntExists(attach_entity)) then
				self.keys[key] = vecString(_EntGetPos(attach_entity));
			end
		end
		if(key == "_mass") then
			self.keys[key] = self:GetMass();
		end
		if(key == "solid") then
			if(_EntExists(self.id)) then
				self.solid = _EntGetSolid(self.id);
				self.keys[key] = self.solid;
			end
		end
		if(key == "_movetype" and self.keys[key] ~= nil) then
			self.mtype = self:GetMoveType();
			if(self.mtype ~= MOVETYPE_VPHYSICS or (self.mtype ~= self.keys[key] and self.keys[key] ~= nil)) then
				self.keys[key] = self.mtype;
			end
		end
		return self.keys[key];
	else
		return "";
	end
end

-- ############## Returns all key values (table)  @H-=NooB=- (modified by aVoN)
function VMFCG.Ent:GetAllKeyValues()
	-- Not neccessary anymore, because all k/v which are stored in self.keys get automaticly actualisated
	-- Update some changed keyvalues first
	--[[
		self:GetKeyValue("_movetype")
		self:GetKeyValue("_mass")
		self:GetKeyValue("addlength")
		self:GetKeyValue("attachpoint")
		self:GetKeyValue("model")
		self:GetKeyValue("hingeaxis")
	--]]
	self:GetKeyValue("origin")
	self:GetKeyValue("angles")
	self:GetKeyValue("solid")
	self:GetKeyValue("targetname")
	self:GetKeyValue("parentname")
	local keys = {}
	for k,v in self.keys do
		keys[k] = self:GetKeyValue(k);
	end
	return keys;
end

-- ############## Returns whether an ent has a key/value pair or not (boolean)  @aVoN
function VMFCG.Ent:HasKey(k)
	
	if(k == "origin" or k == "angles" or (k == "parentname" and self:GetParent() ~= 0)) then
		return true;
	end
	if(self.keys[k]) then
		return true;
	end
	return false;
end


-- #############################################
-- ############### Spawning ########################
-- #############################################


-- ############## Spawns an entity (void)  @H-=NooB=- (modified by aVoN)
function VMFCG.Ent:Spawn()
	if(not _EntExists(self.id) or self.pseudo) then
		--Someone trys to spawn an pseudo entity.
		self.id = _EntCreate(self.class);
		self.pseudo = nil;
	end
	self:ApplyKeyValues();
	_EntSpawn(self.id);
	_EntActivate(self.id);
end


-- #############################################
-- ############### Model ##########################
-- #############################################


-- ############## Sets an entitys model (void)  @H-=NooB=- 
function VMFCG.Ent:SetModel(model)
	self:PrecacheModel();
	if(_EntExists(self.id) and not self.pseudo) then
		_EntSetModel(self.id,model);
	end
	self.model = model;
	self.keys["model"] = model;
end

-- ############## Precaches a model (void) @aVoN
function VMFCG.Ent:PrecacheModel()
	if(self.keys["model"]) then
		if(not VMFCG.Ent.Precached[self.keys["model"]]) then
			_EntPrecacheModel(self.keys["model"]);
			VMFCG.Ent.Precached[self.keys["model"]] = true;
		end
	end
end

-- ############## Get an entitys model (string)  @H-=NooB=-
function VMFCG.Ent:GetModel()
	if(_EntExists(self.id) and not self.pseudo) then
		local model = _EntGetModel(self.id);
		if(model ~= "") then
			self.model = model;
			self.keys["model"] = model;
		end
		return self.model
	end
	return self.keys["model"];
end


-- #############################################
-- ############### Class ##########################
-- #############################################


-- ############## Returns an entitys classname (void)  @ aVoN
function VMFCG.Ent:GetClass()
	return self.class;
end

-- ############## Sets (overrides) an entitys classname - Doesn't have any effect on the real entity, only on this EntityObject class  (void) @ aVoN
function VMFCG.Ent:SetClass(new_class)
	self.class = new_class;
	self.keys["classname"] = self.class
end


-- #############################################
-- ############### Position #########################
-- #############################################


-- ############## Set an entitys position  (void)  @H-=NooB=- (modified by aVoN)
function VMFCG.Ent:SetPos(pos_vec)
	if(_EntExists(self.id) and not self.pseudo) then
		_EntSetPos(self.id,pos_vec);
	end
	--VMFCG.core._EntSetKeyValue(self.id,"origin",pos_vec.x .. " " .. pos_vec.y .. " " .. pos_vec.z);
	self.keys["origin"] = pos_vec.x .. " " .. pos_vec.y .. " " .. pos_vec.z;
	self.pos = pos_vec;
end

-- ############## Get an entitys position  (vector3)  @H-=NooB=- (modified by aVoN)
function VMFCG.Ent:GetPos()
	if(not _EntExists(self.id) or self.pseudo) then
		return self.pos;
	else
		return _EntGetPos(self.id);
	end
end


-- #############################################
-- ############### Parenting #########################
-- #############################################


-- ############## Set parent  (void)  @aVoN 
function VMFCG.Ent:SetParent(id)
	if(not _EntExists(id) and id ~= 0) then return false end;
	if(_EntExists(self.id) and not self.pseudo) then
		_EntSetParent(self.id,id);
	end
	self.parent = id;
	local parent_name = _EntGetName(id);
	if(parent_name == "") then
		self.keys["parentname"] = id;
	else
		self.keys["parentname"] = parent_name;
	end
	return true;
end

-- ############## Get parent  (number)  @aVoN
function VMFCG.Ent:GetParent()
	if(_EntExists(self.id) and not self.pseudo) then
		return _EntGetParent(self.id);
	else
		return self.parent 
	end
end


-- #############################################
-- ############### Angles #########################
-- #############################################


-- ############## Set an entitys angle vector (void)  @H-=NooB=-
function VMFCG.Ent:SetAng(ang_vec)
	-- Only allow setting of the angle, when the hingeaxis or slideaxis hasn't got set before
	if(not (self.keys["hingeaxis"] or self.keys["slideaxis"])) then
		if(_EntExists(self.id) and not self.pseudo) then
			_EntSetAng(self.id,ang_vec);
		end
		self.ang = ang_vec;
	end
end

-- ############## Get an entitys ang vector (vector3)  @H-=NooB=-
function VMFCG.Ent:GetAng()
	if(_EntExists(self.id) and not self.pseudo) then
		return _EntGetAng(self.id);
	else
		return self.ang;
	end
end

-- ############## Set an entitys angangle (void)  @H-=NooB=-
function VMFCG.Ent:SetAngAngle(ang2_vec)
	-- Only allow setting of the angle, when the hingeaxis or slideaxis hasn't got set before
	if(not (self.keys["hingeaxis"] or self.keys["slideaxis"])) then
		if(_EntExists(self.id) and not self.pseudo) then
			_EntSetAngAngle(self.id,ang2_vec);
		end
		--VMFCG.core._EntSetKeyValue(self.id,"angles",ang2_vec.x .. " " .. ang2_vec.y .. " " .. ang2_vec.z);
		self.keys["angles"] = ang2_vec.x .. " " .. ang2_vec.y .. " " .. ang2_vec.z;
		self.ang2 = ang2_vec;
	end
end

-- ############## Get an entitys ang angle (vector3)  @H-=NooB=-
function VMFCG.Ent:GetAngAngle()
	if(_EntExists(self.id) and not self.pseudo) then
		return _EntGetAngAngle(self.id);
	else
		return self.ang2;
	end
end


-- #############################################
-- ############### Movetype ########################
-- #############################################


-- ############## Set an entitys movetype (void)  @H-=NooB=-
function VMFCG.Ent:SetMoveType(mtype)
	if(_EntExists(self.id) and not self.pseudo) then
		_EntSetMoveType(self.id,mtype);
	end
	self.mtype = mtype;
end

-- ############## Get an entitys move type (number)  @H-=NooB=-
function VMFCG.Ent:GetMoveType()
	if(_EntExists(self.id) and not self.pseudo) then
		return _EntGetMoveType(self.id);
	else
		return self.mtype;
	end
end


-- #############################################
-- ############### Mass ##########################
-- #############################################


-- ##############  Set mass (void)  @H-=NooB=-
function VMFCG.Ent:SetMass(int)
	if(_EntExists(self.id) and not self.pseudo) then
		_phys.SetMass(self.id,int);
	end
	self.keys["_mass"] = int;
	self.mass = int;
end

-- ############## Get mass (number)  @H-=NooB=-
function VMFCG.Ent:GetMass()
	if(not _EntExists(self.id) and not self.pseudo) then
		return self.mass;
	else
		return _phys.GetMass(self.id);
	end
end


-- #############################################
-- ############### Connection Handling ##################
-- #############################################


-- ############## Adds a connection to this entity (handled by _EntFire) (void) @ aVoN
function VMFCG.Ent:AddConnection(input,value)
	local lower_input = string.lower(input);
	local special_inputs = {fademindist="fademindist",fademaxdist="fademaxdist", alpha="renderamt",color="rendercolor",setparent="parentname",clearparent="parentname",rendermode="rendermode",skin="skin"}; -- Inputs, which are set directly by ent_fire to the key values
	for k,v in special_inputs do
		if(lower_input == k) then
			self:SetKeyValue(v,string.gsub(value,"+"," "));
			return;
		end
	end
	if(lower_input == "addoutput") then
		local output = VMFCG.explode(value," ",1);
		if(string.find(output[2] or "",",")) then
			-- It's a connection
			table.insert(self.connections,{key=output[1],value=output[2]});
		else
			-- It's a key value
			self:SetKeyValue(output[1],output[2]);
		end
	end
end

-- ############## Gets all connections of this entity (table) @ aVoN
function VMFCG.Ent:GetConnections()
	return VMFCG.copy(self.connections);
end

-- ############## Sets all connections (coid) @ aVoN
function VMFCG.Ent:SetAllConnections(con)
	self.connections = VMFCG.copy(con);
end


-- #############################################
-- ############### Physics #########################
-- #############################################


-- ############## Is Asleep ? (boolean)  @aVoN
function VMFCG.Ent:IsAsleep()
	if(not _EntExists(self.id) or self.pseudo) then
		return self.sleep;
	else
		return _phys.IsAsleep(self.id);
	end
end

-- ############## Sleep (void)  @aVoN
function VMFCG.Ent:Sleep()
	self.sleep = true;
	if(_EntExists(self.id) and not self.pseudo) then
		_phys.Sleep(self.id)
	end
end

-- ############## Awake buddy, it's System! Heureka! (void)  @aVoN
function VMFCG.Ent:Awake()
	self.sleep = false;
	if(_EntExists(self.id) and not self.pseudo) then
		_phys.Wake(self.id)
	end
end


-- #############################################
-- ############### Remove #########################
-- #############################################


-- ############## Kills an entity and the ent object (void) @H-=NooB=-
function VMFCG.Ent:Kill()
	if(_EntExists(self.id) and not self.pseudo) then
		_EntRemove(self.id);
	end
	self = nil;
end
