--[[

	#############################################
	
		VMF CopyGun - Fix for Stupid People
		
	#############################################
	
]]--

--[[
Fixes several problems caused by many worms. Some worms overwrite the init.lua or modify the include 
scripts, so these neccessary functions are not available in Game and make ANY script which relys on these functions to fail
Next time, guys: Simply put cl_downloadfilter to "none", so you don't download lua worms!
--]]
VMFCG.Fix = {};
VMFCG.Fix.Check = {};
VMFCG.Fix.FixedScripts = {};


table.insert(VMFCG.Fix.Check,{func=_PhysConstraintSetEnts,file="backcompat"});
table.insert(VMFCG.Fix.Check,{func=CONCOMMAND,file="concommands"});
table.insert(VMFCG.Fix.Check,{var=TRGTID_TEAMONLY,value=3,file="defines"});
table.insert(VMFCG.Fix.Check,{func=HookEvent,file="eventhook"});
table.insert(VMFCG.Fix.Check,{func=eventPlayerActive,file="events"});
table.insert(VMFCG.Fix.Check,{func=AddThinkFunction,file="luathink"});
table.insert(VMFCG.Fix.Check,{func=tprint,file="misc"});
table.insert(VMFCG.Fix.Check,{func=AllPlayers,file="player"});
table.insert(VMFCG.Fix.Check,{func=AddTimer,file="timers"});
table.insert(VMFCG.Fix.Check,{func=vecString,file="vector3"});

-- ############## Checks the table above, if a function or value exists. If not, it opens the neccessary file (void) @ aVoN
function VMFCG.Fix.CheckNow()
	for _,v in VMFCG.Fix.Check do
		if(v.value) then
			-- It's a check of a variable!
			if(v.var ~= v.value) then
				_OpenScript("VMFCopyGun/extensions/includes/"..v.file..".lua");
				table.insert(VMFCG.Fix.FixedScripts,v.file);
			end
		else
			-- It's an existance check of a function
			if(type(v.func) ~= "function") then
				_OpenScript("VMFCopyGun/extensions/includes/"..v.file..".lua");
				table.insert(VMFCG.Fix.FixedScripts,v.file);
			end
		end
	end
end

-- ############## Warns a serverowner, when he is infected (void) @ aVoN
function VMFCG.Fix.Warn()
	local files = "";
	for _,v in VMFCG.Fix.FixedScripts do
		files = files..v..",";
	end
	VMFCG.Hud.Message(0,"This server is either infected with a Lua worm or lua scripts are missing\nNot loaded files:"..files,10);
end

-- #############################################
-- ################### Init #######################
-- #############################################

VMFCG.Fix.CheckNow()