--[[

	#############################################
	
		VMF CopyGun - Remover Part/Entity handling
		
	#############################################
	
]]--

VMFCG.Remover = VMFCG.Remover or {};

-- ##############  Gets called by the SWEP and removes an entity, if found (void) @aVoN
function VMFCG.Remover.remove(userid)
	local t = VMFCG.TraceLine:NewUser(userid);
	local ent = t:GetEnt();
	local index = {}
	if(ent ~= 0 and ent > _MaxPlayers() and VMFCG.PropProtector_AllowedToUseEntity(userid,ent)) then
		_EntEmitSound(userid,"Airboat.FireGunRevDown");
		VMFCG.selection.SetHitEffect(t);
		for player,v in VMFLoader.Players do
			for contraption,entities in v.last_vmf_spawned do
				for _,entity in entities do
					if(entity == ent) then
						VMFCG.Remover.killnow(player,contraption);
						return;
					end
				end
			end
		end
		VMFCG.Remover.kill_effect(ent);
		_EntRemove(ent);
	end
end

-- ##############  Kills all entitys in an undolist (void) @aVoN
function VMFCG.Remover.killnow(player,contraption)
	local count = table.getn(VMFLoader.Players[player].last_vmf_spawned[contraption]);
	local i = 0;
	local effects = 0;
	for k,v in VMFLoader.Players[player].last_vmf_spawned[contraption] do
		i = i + 1;
		if((i/count)*40 >= effects) then -- Limit the effects to 40, or the game may crash!
			effects = effects + 1;
			VMFCG.Remover.kill_effect(v);
		end
		_EntRemove(v);
	end
	VMFLoader.Players[player].last_vmf_spawned[contraption] = nil;
end

function VMFCG.Remover.kill_effect(v)
	_EffectInit();
		_EffectSetOrigin(_EntGetPos(v));
		_EffectSetScale(0.5);
		_EffectSetMagnitude(2);
		_EffectSetRadius(1);
	_EffectDispatch("cball_explode");
end

-- ##############  Checks, if an entity of the VMFLoader undolist still exists or not and removes it from the list (void) @aVoN
function VMFCG.Remover.EntityExistsChecker()
	for player,v in VMFLoader.Players do
		for contraption,entities in v.last_vmf_spawned do
			for k,entity in entities do
				if(not _EntExists(entity)) then
					entities[k] = nil;
				end
			end
			if(table.getn(entities) == 0) then
				v.last_vmf_spawned[contraption] = nil;
			end
		end
	end
end

VMFCG.AddTimerOnce("VMFCG.Remover.EntityExistsChecker",1,0,VMFCG.Remover.EntityExistsChecker);