--[[
Original Synth Spawner by zeroti
Cleaned up by bdpq

Primary fire - Spawn a Synth at your position in the direction you are facing
Secondary fire - Remove ALL Synths
]]--

function onInit()
	_SWEPSetSound(MyIndex, "single_shot", "Bounce.flesh")
	_EntPrecacheModel("models/synth.mdl")
end
 
function onThink()
end
 
function onPrimaryAttack()
    local prop = _EntCreate("monster_generic")
	local plypos = _PlayerGetShootPos(Owner)
	local plyang = _PlayerGetShootAng(Owner)
    _EntSetModel(prop, "models/synth.mdl")
    _EntSetPos(prop, plypos)
	plyang.z = 0.00
    _EntSetAng(prop, plyang)
    _EntSpawn(prop)
end
 
function onSecondaryAttack()
	for i = 1, 4096 do
		if _EntGetType(i) == "monster_generic" then
			_EntRemove(i)
		end
	end
end


function onReload( ) return true; end
function onDrop( ) _EntRemove(MyIndex); end
function getWeaponSwapHands() return true; end
function getWeaponFOV() return 1; end
function getWeaponSlot() return 5; end
function getWeaponSlotPos() return 7; end
function getFiresUnderwater() return true; end
function getReloadsSingly() return false; end
function getDamage() return 0; end
function getPrimaryShotDelay() return 0.50; end
function getSecondaryShotDelay() return 0; end
function getPrimaryIsAutomatic() return false; end
function getSecondaryIsAutomatic() return false; end
function getPrimaryAmmoType() return "none"; end
function getSecondaryAmmoType() return "none"; end
function getMaxClipPrimary() return 1; end
function getMaxClipSecondary() return 1; end
function getDefClipPrimary() return 1; end
function getDefClipSecondary() return 1; end
function getPrimaryScriptOverride() return 1; end
function getSecondaryScriptOverride() return 3; end
function getBulletSpread() return vector3( 0.0, 0.0, 0.0 ); end
function getViewKick() return vector3( -0.0, 0.0, 0.0); end
function getViewKickRandom() return vector3( -0.0, 0.0, 0.0 ); end
function getViewModel( ) return "models/weapons/shell.mdl"; end
function getWorldModel( ) return "models/weapons/shell.mdl"; end
function getClassName() return "weapon_synth"; end
function getAnimPrefix() return "slam"; end
function getPrintName() return "Synth Spawner"; end 