

-- This is the base SWEP (Scripted Weapon).

-- DO NOT change this file.

-- When making a new weapon you only need to override what you need.




_OpenScript( "includes/defines.lua" );
_OpenScript( "includes/vector3.lua" );





-- These variables are passed by the engine



MyIndex			=	0; -- Weapon's entity index.

Owner			= 	0; -- The player that owns this weapon

CurrentTime		=	0; -- The current game time


iStage = 1;
select1 = nil;
select2 = nil;






-- Called when the weapon is created.

	function onInit( )
		_SWEPSetSound(MyIndex, "single_shot", "Weapon_357.Single")
	end



	

-- Called every frame

	function onThink( )

	end

	

	

-- When the player presses left mouse button

	function onPrimaryAttack( )	
		_TraceLine(_PlayerGetShootPos(Owner), _PlayerGetShootAng(Owner), 32768, Owner);
		if _TraceHitNonWorld() then
			local vHit = _TraceEndPos();
			_EffectInit();
			_EffectSetOrigin(vHit);
			_EffectSetRadius(2);
			_EffectDispatch("AirboatGunImpact");
			local selEnt = _TraceGetEnt();
			if iStage == 1 then
				select1 = selEnt;
				iStage = 2;
			elseif iStage == 2 then
				select2 = selEnt;
				iStage = 1;
				_RunString("CallAddWeld("..select1..", "..select2..", ".._EntGetParent(MyIndex)..")");
				--_Msg("Welder Gun dispatched "..select1.." "..select2.." ".._EntGetParent(MyIndex).."\n");
				select1 = nil;
				select2 = nil;
			end
		end
	end

	

-- When the player presses right mouse button

	function onSecondaryAttack( )		
		return false;
	end



	function Deploy( )
	end
	
	function Holster( )
		iStage = 1;
		select1 = nil;
		select2 = nil;
	end
	

-- When player presses reload. Returning false means DONT RELOAD. Although this will hitch on the client.

	function onReload( )

		return true;

	end

	



-- These are only accessed once when setting up the weapon

	

	function getWeaponSwapHands()

		return false;	

	end

	

	function getWeaponFOV()

		return 70;	

	end

	

	function getWeaponSlot()

		return 5;	

	end

	

	function getWeaponSlotPos()

		return 3;	

	end

	

	function getFiresUnderwater()

		return true;

	end

	

	function getReloadsSingly()

		return false;

	end

	



	

	-- Primary Attack

	

	function getDamage()

		return 00;

	end

	

	function getPrimaryShotDelay()

		return 0.2;

	end

		

	function getPrimaryIsAutomatic()

		return true;

	end

			

	function getBulletSpread()

		return vector3( 0.01, 0.01, 0.01 );

	end

	

	function getViewKick()

		return vector3( 0, 0.0, 0.0);

	end

	

	function getViewKickRandom()

		return vector3( 0, 0, 0 );

	end

		

	function getNumShotsPrimary()

		return 1;

	end

	

	function getPrimaryAmmoType()

		return "pistol";

	end

	

	-- Secondary attack

	

	function getDamageSecondary()

		return 10;

	end

	

	function getSecondaryShotDelay()

		return 0.2;

	end

	

	function getSecondaryIsAutomatic()

		return false;

	end

	

	function getBulletSpreadSecondary()

		return vector3( 0.001, 0.001, 0.001 );

	end

	

	function getViewKickSecondary()

		return vector3( 0.5, 0.0, 0.0);

	end

	

	function getViewKickRandomSecondary()

		return vector3( 0.5, 0.5, 0.2 );

	end

	

	function getNumShotsSecondary()

		return 1;

	end

	

	function getSecondaryAmmoType()

		return "pistol";

	end

	

	



	function getViewModel( )

		return "models/weapons/v_crossbow.mdl";

	end

	

	function getWorldModel( )

		return "models/weapons/w_crossbow.mdl";

	end

	

	function getClassName() 

		return "tool_lua_groupcopy_welder";

	end



	function getHUDMaterial( )

		return "gmod/SWEP/default";

	end





		



	

	function getMaxClipPrimary() -- return -1 if it doesn't use clips

		return 25;

	end

	

	function getMaxClipSecondary() -- return -1 if it doesn't use clips

		return -1;

	end

	

	function getDefClipPrimary() -- ammo in gun by default

		return 25;

	end

	

	function getDefClipSecondary()

		return 0;

	end



	

	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade

		return "crossbow";

	end



	function getPrintName()

		return "Group Copy Welder";

	end

	

	

	-- 0 = Don't override, shoot bullets, make sound and flash

	-- 1 = Don't shoot bullets but do make flash/sounds

	-- 2 = Only play animations

	-- 3 = Don't do anything

	

	function getPrimaryScriptOverride()

		return 1;

	end



	function getSecondaryScriptOverride()

		return 3;

	end



