-- This script is isolated from all other scripts
-- If you need to include other scripts you should do it manually below

_OpenScript( "includes/vector3.lua" );

-- These variables are passed by the engine

MyIndex			=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time

	function onInit( )
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_M3.Single" );
	end

	function onThink( )
			
	end
	
	function onPrimaryAttack( )
		local numberOfPellets = 10
		local force = 500	--force really means velocity here, a simple mistake.
		local firecone = 8
		local barrelLength = 32
		local initialSpread = 12
		--Only edit the above vars unless you know what you're doing
		local maxinaccuracy = math.tan(math.rad(firecone / 2)) * force
		local inaccuracy_x 
		local inaccuracy_y 
		local inaccuracy_z
		local vecInaccuracy
		local iCount
		local vecInitSpread		
		for iCount = 1, numberOfPellets, 1 do
            	vecInitSpread = vector3(math.random(initialSpread * -1, initialSpread), math.random(initialSpread * -1, initialSpread), math.random(initialSpread * -1, initialSpread))

			inaccuracy_x = math.random(maxinaccuracy * -1, maxinaccuracy)
			inaccuracy_y = math.random(maxinaccuracy * -1, maxinaccuracy)
			inaccuracy_z = math.random(maxinaccuracy * -1, maxinaccuracy)
			vecInaccuracy = vector3(inaccuracy_x, inaccuracy_y, inaccuracy_z)

			local curProjectile = _EntCreate("crossbow_bolt");
			_EntPrecacheModel("models/props_junk/CinderBlock01a.mdl");
			--_EntSetModel(curProjectile, "models/props_junk/harpoon002a.mdl");
			_EntSetOwner(curProjectile, Owner);
			_EntSetKeyValue(curProjectile, "targetname", "zerogun_projectile");
			_EntSetKeyValue(curProjectile, "damage", "15");
			
			_EntSetPos(curProjectile, vecAdd(vecAdd(_PlayerGetShootPos(Owner), vecMul(vector3(barrelLength,barrelLength,barrelLength),_PlayerGetShootAng(Owner))), vecInitSpread));
			--Above line keeps the projectile from spawning inside the player
			_EntSetAng(curProjectile, _PlayerGetShootAng(Owner))
			_EntSetVelocity(curProjectile, vecAdd(vecMul(_PlayerGetShootAng(Owner), vector3(force, force, force)), vecInaccuracy));		
			_EntSpawn(curProjectile);
		
		end
		_SWEPUseAmmo(MyIndex, 0 , 1);		
	end
	
	function onSecondaryAttack( )		
		return false;
	end
	
      function onReload( )
		return true;
	end

-- Weapon settings.
-- These are only accessed once when setting the weapon up
	
	function getWeaponSwapHands()  --If true, switch hands.
		return true;	
	end
	
	function getWeaponFOV()  --Field of view when using this weapon. If ya wanna be ghetto, set to 10 for a sniper rifle
		return 60;	
	end
	
	function getWeaponSlot() --This is the "slot" on the inventory where your weapon will be. (Crowbar is 1, pistol is 2, smg is 3)
		return 4;	
	end
	
	function getWeaponSlotPos() --This is the position in the slot. (Crowbar is 1, stunstick is 2, smg is 1, rpg is 2.)
		return 1;	
	end
	
	function getFiresUnderwater()
		return true;   
	end
	
	function getReloadsSingly()
		return true;
	end
	
	function getDamage() 
		return 50;
	end
	
	function getPrimaryShotDelay()
		return 1.50;
	end
	
	function getSecondaryShotDelay()
		return 1;
	end
	
	function getPrimaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic() 
		return false;
	end
		function getBulletSpread() -- Spread is handled in OnPrimaryFire, this is obsolete.
		return vector3( 0.02, 0.02, 0.02 );
	end
	
	function getViewKick()
		return vector3( -6, -6, -2);
	end
	
	function getViewKickRandom() 
		return vector3( 3, 3, 3 );
	end

	function getViewModel( )
		return "models/weapons/v_shot_m3super90.mdl";
	end
	
	function getWorldModel( ) 
		return "models/weapons/w_shot_m3super90.mdl";
	end
	
	function getClassName() --Name it after this script. Don't duplicate classnames. Make them all unique.
		return "weapon_shotgun";
	end

	function getPrimaryAmmoType() --Sadly... I don't know what this does? I guess it is how the bullet interacts with the world?
		return "XBowBolt";
	end
		
	function getSecondaryAmmoType()
		return "XBowBolt";
	end
	-- return -1 if it doesn't use clips
	function getMaxClipPrimary() --How many primary fire bullets you can hold.
		return 5;
	end
	
	function getMaxClipSecondary()
		return -1;
	end
	
	-- ammo in gun by default
	function getDefClipPrimary() --Default Ammo
		return 500;
	end
	
	function getDefClipSecondary()
		return 0;
	end

	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix() --How to animate
		return "shotgun";
	end

	function getPrintName() --Name in inventory
		return "Shotgun";
	end
	
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	
	function getPrimaryScriptOverride()
		return 1;
	end

	function getSecondaryScriptOverride() --all explained
		return 3;
	end