
-- This script is isolated from all other scripts
-- If you need to include other scripts you should do it manually below


_OpenScript( "functions_vector.lua" );



-- These variables are passed by the engine

MyIndex			=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time


-- Called when the weapon is created.
	
	function onInit( )
		
		_SWEPSetSound( MyIndex, "single_shot", "Weapon_glock.Single" );
		
	end

	
-- Called every frame

	function onThink( )
			
	end
	
	
-- 

	function onPrimaryAttack( )
		
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
			
		local iBolt = _EntCreate( "crossbow_bolt" );
		
		if (iBolt > 0) then
			
			_EntSetKeyValue( iBolt, "damage", "40");
			_EntSetPos( iBolt, _PlayerGetShootPos( Owner ) );
			_EntSetAng( iBolt, _PlayerGetShootAng( Owner ) );
			_EntSetOwner( iBolt, Owner );
			
			local vVelocity = vecMul( _PlayerGetShootAng( Owner ), vector3(500, 500, 500) );
			_EntSetVelocity( iBolt, vVelocity );
				
			_EntSpawn( iBolt );
			
		end
		
		
		_SWEPUseAmmo( MyIndex, 0, 1 );
			
	end
	
	
	function onSecondaryAttack( )		
		
		-- No sec attack
					
	end
	
	
	function onReload( )
			
		return true;
			
	end
	
	
	
-- Weapon settings.
-- These are only accessed once when setting the weapon up
	
	function getWeaponSwapHands()
		return true;	
	end
			function getNumShotsprimary()	return 3;	end	
	function getWeaponFOV()
		return 80;	
	end
	
	function getWeaponSlot()
		return 2;	
	end
	
	function getWeaponSlotPos()
		return 1;	
	end
	
	function getFiresUnderwater()
		return true;
	end
	
	function getReloadsSingly()
		return false;
	end
	
	function getDamage()
		return 200;
	end
	
	function getPrimaryShotDelay()
		return 0.75;
	end
	
	function getSecondaryShotDelay()
		return 0.01;
	end
	
	function getPrimaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getSecondaryIsAutomatic()
		return false;
	end
	
	function getBulletSpread()
		return vector3( 50.001, 50.001, 50.001 );
	end
	
	function getViewKick()
		return vector3( 0.5, 0.0, 0.0);
	end
	
	function getViewKickRandom()
		return vector3( 0.5, 0.5, 0.2 );
	end

	function getViewModel( )
		return "models/weapons/v_pist_glock18.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_pist_glock18.mdl";
	end
	
	function getClassName()
		return "weapon_glock";
	end

	function getPrimaryAmmoType()
		return "XBowBolt";
	end
		
	function getSecondaryAmmoType()
		return "XBowBolt";
	end
	
	-- return -1 if it doesn't use clips
	function getMaxClipPrimary()
		return 15;
	end
	
	function getMaxClipSecondary()
		return -1;
	end
	
	-- ammo in gun by default
	function getDefClipPrimary()
		return 5000;
	end
	
	function getDefClipSecondary()
		return 0;
	end

	-- pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
	function getAnimPrefix()
		return "pistol";
	end

	function getPrintName()
		return "Glock";
	end
	
	
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything
	
	function getPrimaryScriptOverride()
		return 1;
	end

	function getSecondaryScriptOverride()
		return 3;
	end

