--[[
The Physics Gun: Lua Edition
by Jeff Griffin (GeoGriffin)

Name: The Physics Gun: Lua Edition
Type: Scripted Weapon
Script Version: 1.0
GM Version: 9.0.3
Short Description: A LUA emulated physics gun
Long Description: This LUA emulated physics gun is capable of lifting objects, npcs,
players, and any other kind of entity.

TODO::
	Fix bobbing problem.
	Add torque when 9.0.4 comes out.
	
]]

MyIndex = 0;
Owner = 0;
init = false;

function weapon_physgun_le_init()
_RunString([[

if (geogriffin == nil) then geogriffin = {}; end

function geogriffin.vecAdd(v1, p2, p3, p4)
	if (tonumber(p2) ~= nil or tonumber(p3) ~= nil or tonumber(p4) ~= nil) then
	    if (tonumber(p2) ~= nil) then
	    	v1.x = v1.x + p2;
		end
	    if (tonumber(p3) ~= nil) then
	    	v1.y = v1.y + p3;
		end
		if (tonumber(p4) ~= nil) then
		    v1.z = v1.z + p4;
		end
	else
		v1.x = v1.x + p2.x;
		v1.y = v1.y + p2.y;
		v1.z = v1.z + p2.z;
	end
	return v1;
end
function geogriffin.vecSub(v1, p2, p3, p4)
	if (tonumber(p2) ~= nil or tonumber(p3) ~= nil or tonumber(p4) ~= nil) then
	    if (tonumber(p2) ~= nil) then
	    	v1.x = v1.x - p2;
		end
	    if (tonumber(p3) ~= nil) then
	    	v1.y = v1.y - p3;
		end
		if (tonumber(p4) ~= nil) then
		    v1.z = v1.z - p4;
		end
	else
		v1.x = v1.x - p2.x;
		v1.y = v1.y - p2.y;
		v1.z = v1.z - p2.z;
	end
	return v1;
end
function geogriffin.vecMul(v1, p2, p3, p4)
	if (tonumber(p2) ~= nil or tonumber(p3) ~= nil or tonumber(p4) ~= nil) then
	    if (tonumber(p2) ~= nil) then
	    	v1.x = v1.x * p2;
		end
	    if (tonumber(p3) ~= nil) then
	    	v1.y = v1.y * p3;
		end
		if (tonumber(p4) ~= nil) then
		    v1.z = v1.z * p4;
		end
	else
		v1.x = v1.x * p2.x;
		v1.y = v1.y * p2.y;
		v1.z = v1.z * p2.z;
	end
	return v1;
end
function geogriffin.vecNormalize(v1)
	local length = vecLength(v1);

	if (length ~= 0) then
		v1.x = v1.x / length;
		v1.y = v1.y / length;
		v1.z = v1.z / length;
	end

	return v1;
end

function geogriffin.vecLinMul(vector, multiplier)
    vector.x = vector.x * multiplier;
	vector.y = vector.y * multiplier;
	vector.z = vector.z * multiplier;
	return vector;
end

function geogriffin.vecCopy(vector)
	return vector3(vector.x, vector.y, vector.z);
end

function geogriffin.vecEqu(v1, v2)
	if (v1.x ~= v2.x) then return false; end
	if (v1.y ~= v2.y) then return false; end
	if (v1.z ~= v2.z) then return false; end
	return true;
end

function geogriffin.getAngFromPos(from, to)
	if ((to.x - from.x) + (to.y - from.y) == 0) then
		if (to.z - from.z > 0) then return vector3(0, 0, 1);
		elseif (to.z - from.z < 0) then return vector3(0, 0, -1);
		else return vector3(0, 0, 0); end
	end
	local elevAngle = math.atan((to.z - from.z) / math.sqrt((to.x - from.x)^2 + (to.y - from.y)^2));
	local dirAngle = math.atan((to.y - from.y) / (to.x - from.x));
	if ((to.y - from.y) < 0 and (to.x - from.x) < 0) then
		dirAngle = dirAngle - math.pi;
	elseif ((to.y - from.y) > 0 and (to.x - from.x) < 0) then
		dirAngle = dirAngle + math.pi;
	end
	return vector3(math.cos(dirAngle) * math.cos(elevAngle), math.sin(dirAngle) * math.cos(elevAngle), math.sin(elevAngle)), elevAngle, dirAngle;
end

function geogriffin.vecToAngle(unitVec)
	local elevAngle = math.asin(unitVec.z);
	local dirAngle = math.acos(unitVec.x / math.cos(elevAngle));
	if (unitVec.y < 0) then
		dirAngle = -(dirAngle);
	end
	return vector3(math.deg(dirAngle), math.deg(elevAngle), 0);
end

function geogriffin.angleToVec(angleVec)
	return vector3(math.cos(math.rad(angleVec.x)) * math.cos(math.rad(angleVec.y)), math.sin(math.rad(angleVec.x)) * math.cos(math.rad(angleVec.y)), math.sin(math.rad(angleVec.y)));
end

if (geogriffin.weapon_physgun_le == nil) then
	geogriffin.weapon_physgun_le = {
	physguns = {},
	targets = {},
	};
end

-- User Variables --
	geogriffin.weapon_physgun_le.range = 2000;
-- End User Variables --

-- Don't touch anything below (if you have no idea what you are doing) --

if (geogriffin.weapon_physgun_le.physguns[]] .. MyIndex .. [[] == nil) then
--if (geogriffin.weapon_physgun_le.physguns[MyIndex] == nil) then
geogriffin.weapon_physgun_le.physguns[]] .. MyIndex .. [[] = {
--geogriffin.weapon_physgun_le.physguns[MyIndex] = {


	owner = ]] .. Owner .. [[,
	oldOwner = ]] .. Owner .. [[,
	myIndex = ]] .. MyIndex .. [[,
	id = ]] .. MyIndex .. [[,
	--owner = Owner,
	--oldOwner = Owner,
	--myIndex = MyIndex,

	wepFrame = false,
	lastWepFrame = 0,
	repeatTime = 0,
	target = nil,
	buttons = {
		primary = {
			time = 0,
			wait = 0,
			single = false,
		    pressed = false
		},
		secondary = {
		    time = 0,
		    wait = 0,
		    single = false,
		    pressed = false
		},
		reload = {
		    time = 0,
		    wait = 0,
		    single = true,
		    pressed = false
		}
	},
	aimCoords = nil,
	curSeq = nil,
	seqQueue = {},
};

end

function geogriffin.weapon_physgun_le.pyth_func(x, y)
	x = math.pow(x, 2);
	y = math.pow(y, 2);
	return math.pow(x+y, .5);
end

function geogriffin.weapon_physgun_le.updateHud(physgun)
	local index = physgun.firstGunPlacement;
	if (index ~= nil and physgun.gunPlacements[index].curCalcs.enabled == true) then
		_GModRect_Start("gmod/white");
		_GModRect_SetPos(.77, .725, .09, .16);
		_GModRect_SetColor(0, 0, 0, 100);
		_GModRect_SetTime(99999, 0, 0);
		_GModRect_SetDelay(0);
		_GModRect_Send(physgun.owner, 60);

		_GModText_Start("DefaultShadow");
		_GModText_SetPos(.774, .73);
		_GModText_SetColor(200, 200, 0, 175);
		_GModText_SetTime(99999, 0, 0);
		_GModText_SetDelay(0);
		_GModText_SetText(string.sub(string.format("Ang %f", math.deg(physgun.gunPlacements[index].curCalcs.elevAng)), 1, 9));
		_GModText_Send(physgun.owner, 61);

		_GModText_Start("DefaultShadow");
		_GModText_SetPos(.774, .75);
		_GModText_SetColor(200, 200, 0, 175);
		_GModText_SetTime(99999, 0, 0);
		_GModText_SetDelay(0);
		_GModText_SetText(string.format("Vel %d", physgun.gunPlacements[index].curCalcs.accel));
		_GModText_Send(physgun.owner, 62);

		_GModText_Start("DefaultShadow");
		_GModText_SetPos(.774, .77);
		_GModText_SetColor(200, 200, 0, 175);
		_GModText_SetTime(99999, 0, 0);
		_GModText_SetDelay(0);
		_GModText_SetText(string.format("Height %d", physgun.gunPlacements[index].curCalcs.height));
		_GModText_Send(physgun.owner, 63);

		_GModText_Start("DefaultShadow");
		_GModText_SetPos(.774, .79);
		_GModText_SetColor(200, 200, 0, 175);
		_GModText_SetTime(99999, 0, 0);
		_GModText_SetDelay(0);
		_GModText_SetText(string.format("Dist %d", physgun.gunPlacements[index].curCalcs.dist));
		_GModText_Send(physgun.owner, 64);

		_GModText_Start("DefaultShadow");
		_GModText_SetPos(.774, .81);
		_GModText_SetColor(200, 200, 0, 175);
		_GModText_SetTime(99999, 0, 0);
		_GModText_SetDelay(0);
   		 if (physgun.gunPlacements[index].curCalcs.inRange == true) then
    			_GModText_SetText("RANGE OK");
			_GModText_SetColor(0, 255, 0, 175);
		else
			_GModText_SetText("OUT OF RANGE!");
			_GModText_SetColor(255, 0, 0, 175);
		end
		_GModText_Send(physgun.owner, 65);

		_GModText_Start("DefaultShadow");
		_GModText_SetPos(.774, .83);
		_GModText_SetTime(99999, 0, 0);
		_GModText_SetDelay(0);
   		if (physgun.gunPlacements[index].curCalcs.hitCeil == false) then
    			_GModText_SetText("HEIGHT OK");
			_GModText_SetColor(0, 255, 0, 175);
		else
			_GModText_SetText("TOO HIGH!");
			_GModText_SetColor(255, 0, 0, 175);
		end
		_GModText_Send(physgun.owner, 66);

		_GModText_Start("DefaultShadow");
		_GModText_SetPos(.774, .85);
		_GModText_SetColor(200, 200, 0, 175);
		_GModText_SetTime(99999, 0, 0);
		_GModText_SetDelay(0);
		_GModText_SetText(string.sub(string.format("Time %f", physgun.gunPlacements[index].curCalcs.time), 1, 10));
		_GModText_Send(physgun.owner, 67);
		physgun.hudDrawn = true;
	end

	_GModText_Start("DefaultShadow");

	_GModText_SetColor(255, 255, 0, 255);
	_GModText_SetTime(99999, 0, 0);
	_GModText_SetDelay(0);
	if (physgun.manualSet == true) then
		_GModText_SetPos(.488, .465);
		if (physgun.curSet.elevAng == nil) then
   			_GModText_SetText("NIL");
		else
			_GModText_SetText(string.format("%d", math.deg(physgun.curSet.elevAng)));
		end
	else
		_GModText_SetPos(.495, .465);
		if (physgun.curSetMode == 1) then
   			_GModText_SetText("H");
		elseif (physgun.curSetMode == 2) then
			_GModText_SetText("V");
		end
	end
	_GModText_Send(physgun.owner, 70);
	_GModText_Start("DefaultShadow");
	_GModText_SetPos(.488, .515);
	_GModText_SetColor(255, 255, 0, 255);
	_GModText_SetTime(99999, 0, 0);
	_GModText_SetDelay(0);
	if (physgun.manualSet == true or physgun.curSetMode == 2) then
  		if (physgun.curSet.accel == nil) then
   			_GModText_SetText("NIL");
		else
			_GModText_SetText(string.format("%d", physgun.curSet.accel));
		end
	elseif (physgun.curSetMode == 1) then
		if (physgun.curSet.heightPercent == nil) then
   			_GModText_SetText("NIL");
		else
			_GModText_SetText(string.format("%d", physgun.curSet.heightPercent));
		end
	end
	_GModText_Send(physgun.owner, 71);
	physgun.curSetHudDrawn = true;
end

function geogriffin.weapon_physgun_le.clearHud(physgun)
	if (physgun.hudDrawn == true) then
		_GModRect_Hide(physgun.owner, 60, 0);
		_GModText_Hide(physgun.owner, 61, 0);
		_GModText_Hide(physgun.owner, 62, 0);
		_GModText_Hide(physgun.owner, 63, 0);
		_GModText_Hide(physgun.owner, 64, 0);
		_GModText_Hide(physgun.owner, 65, 0);
		_GModText_Hide(physgun.owner, 66, 0);
		_GModText_Hide(physgun.owner, 67, 0);
		_GModText_Hide(physgun.owner, 70, 0);
		_GModText_Hide(physgun.owner, 71, 0);
		physgun.hudDrawn = false;
	end
end
function geogriffin.weapon_physgun_le.clearCurSetHud(physgun)
	if (physgun.curSetHudDrawn == true) then
		_GModText_Hide(physgun.owner, 70, 0);
		_GModText_Hide(physgun.owner, 71, 0);
		physgun.curSetHudDrawn = false;
	end
end

function geogriffin.weapon_physgun_le.checkInput(physgun)
	if (_PlayerIsKeyDown(physgun.owner, 8192) == true) then --Reload
	    if (physgun.buttons.reload.pressed == false or physgun.buttons.reload.single == false) then
		    physgun.buttons.reload.pressed = true;
		    if (_CurTime() - physgun.buttons.reload.time > physgun.buttons.reload.wait) then
		        physgun.buttons.reload.time = _CurTime();
		    	geogriffin.weapon_physgun_le.onReloadPressed(physgun);
			end
		end
	else
	    if (physgun.buttons.reload.pressed == true) then
	        geogriffin.weapon_physgun_le.onReloadReleased(physgun);
		end
	   	physgun.buttons.reload.pressed = false;
	end
	if (_PlayerIsKeyDown(physgun.owner, 2048) == true) then --Secondary fire
	    if (physgun.buttons.secondary.pressed == false or physgun.buttons.secondary.single == false) then
			physgun.buttons.secondary.pressed = true;
			if (_CurTime() - physgun.buttons.secondary.time > physgun.buttons.secondary.wait) then
				physgun.buttons.secondary.time = _CurTime();
				geogriffin.weapon_physgun_le.onSecAttackPressed(physgun);
			end
		end
	else
	    if (physgun.buttons.secondary.pressed == true) then
	        geogriffin.weapon_physgun_le.onSecAttackReleased(physgun);
		end
	    physgun.buttons.secondary.pressed = false;
	end
	if (_PlayerIsKeyDown(physgun.owner, 1) == true) then --Primary fire
	    if (physgun.buttons.primary.pressed == false or physgun.buttons.primary.single == false) then
			physgun.buttons.primary.pressed = true;
			if (_CurTime() - physgun.buttons.primary.time > physgun.buttons.primary.wait) then
			    physgun.buttons.primary.time = _CurTime();
				geogriffin.weapon_physgun_le.onAttackPressed(physgun);
			end
		end
	else
	    if (physgun.buttons.primary.pressed == true) then
	        geogriffin.weapon_physgun_le.onAttackReleased(physgun);
		end
	    physgun.buttons.primary.pressed = false;
	end
end

function geogriffin.weapon_physgun_le.doSeq(physgun, id)
	physgun.seqQueue = {};
	physgun.curSeq = {id = id, startTime = nil, length = nil};
	--_Msg(string.format("do %d\n", id));
end

function geogriffin.weapon_physgun_le.addSeq(physgun, id, length)
	table.insert(physgun.seqQueue, {id = id, startTime = nil, length = length});
end

function geogriffin.weapon_physgun_le.removeSeq(physgun)
	if (table.getn(physgun.seqQueue) > 0) then
		local seq = physgun.seqQueue[1];
		table.remove(physgun.seqQueue, 1);
		return seq;
	else
	    return nil;
	end
end

function geogriffin.weapon_physgun_le.checkSeq(physgun)
	if (physgun.curSeq == nil) then
	    geogriffin.weapon_physgun_le.addSeq(physgun, ACT_SLAM_TRIPMINE_DRAW);
		physgun.curSeq = geogriffin.weapon_physgun_le.removeSeq(physgun);
		--_Msg(string.format("initial %d\n", physgun.curSeq.id));
	end

	if (physgun.curSeq.length ~= nil and physgun.curSeq.startTime ~= nil and _CurTime() - physgun.curSeq.startTime > physgun.curSeq.length) then
	    local seq = geogriffin.weapon_physgun_le.removeSeq(physgun);
	    if (seq ~= nil) then
	        physgun.curSeq = seq;
	    	--_Msg(string.format("getting %d\n", seq.id));
		end
	end

	if (physgun.curSeq.startTime == nil) then physgun.curSeq.startTime = _CurTime(); end
    if (physgun.curSeq.length == nil) then physgun.curSeq.length = _PlayerViewModelSequence(physgun.owner, physgun.curSeq.id);
    else _PlayerViewModelSequence(physgun.owner, physgun.curSeq.id); end
	--_Msg("%f", physgun.curSeq.length);
end

function geogriffin.weapon_physgun_le.cleanUp(physgun)
	if (physgun.target ~= nil) then
	    physgun.target.aimCoords[physgun.id] = nil;
		physgun.target = nil;
		_EntRemove(physgun.beamId);
		physgun.beamId = nil;
		_EntRemove(physgun.beamEndpointId);
		physgun.beamEndpointId = nil;
	end
	geogriffin.weapon_physgun_le.physguns[physgun.myIndex] = nil;
end

function geogriffin.weapon_physgun_le.globalThink()
	for targetKey, target in pairs(geogriffin.weapon_physgun_le.targets) do
	    if (_EntExists(target.id) == false) then
            geogriffin.weapon_physgun_le.targets[targetKey] = nil;
		else
			local changed = false;
		    if (target.physics == true) then
		    	local targetPos = _EntGetPos(target.id);
				local curTime = _CurTime();
				if (target.curFrame >= 10) then target.curFrame = 0; target.lastFrames = {}; end
				target.curFrame = target.curFrame + 1;
				target.lastFrames[target.curFrame] = {time = curTime - target.lastFrame, dist = vecSub(targetPos, target.lastPos)};

				if (target.curFrame == 10) then
					local changed = false;
					local pushForce = vector3(0, 0, 0);
					for key, value in pairs(target.aimCoords) do
					    changed = true;
					    local targetDist = vecLength(vecSub(targetPos, value));
					    if (targetDist > 80) then
					        geogriffin.vecAdd(pushForce, geogriffin.vecLinMul(geogriffin.getAngFromPos(targetPos, value), 1000));
					    elseif (targetDist > 15) then
							geogriffin.vecAdd(pushForce, geogriffin.vecLinMul(geogriffin.getAngFromPos(targetPos, value), 400));
						elseif (targetDist > 5) then
						    geogriffin.vecAdd(pushForce, geogriffin.vecLinMul(geogriffin.getAngFromPos(targetPos, value), 100));
						end
						--_Msg("%f", targetDist);
					end
		            local averageTime = 0;
		            local averageDist = vector3(0, 0, 0);
		            local numFrames = 0;
		            for frameKey, frameValue in pairs(target.lastFrames) do
		                numFrames = numFrames + 1;
		                geogriffin.vecAdd(averageDist, frameValue.dist);
		                averageTime = averageTime + frameValue.time;
		            end
		            averageTime = averageTime / numFrames;
		            if (averageTime > 0) then
		            	geogriffin.vecLinMul(averageDist, -(1 / (averageTime * numFrames)));
					else
					    averageDist = vector3(0, 0, 0);
					end
					_phys.ApplyForceCenter(target.id, geogriffin.vecLinMul(geogriffin.vecAdd(pushForce, averageDist), target.mass));
					--_EntSetAngAngle(target.id, target.curAngle);
					target.lastFrame = curTime;
					target.lastPos = targetPos;
					if (changed == false) then
						geogriffin.weapon_physgun_le.targets[targetKey] = nil;
						_phys.EnableGravity(target.id, true);
						_phys.EnableDrag(target.id, true);
					end
				end
			else
				if (target.curFrame >= 10) then target.curFrame = 0; end
				target.curFrame = target.curFrame + 1;
				if (target.curFrame == 10) then
					local targetPos = _EntGetPos(target.id);
					local changed = false;
					local pushForce = vector3(0, 0, 0);
					for key, value in pairs(target.aimCoords) do
					    changed = true;
					    local targetDist = vecLength(vecSub(targetPos, value));
					    if (targetDist > 80) then
					        geogriffin.vecAdd(pushForce, geogriffin.vecLinMul(geogriffin.getAngFromPos(targetPos, value), 1000));
					    elseif (targetDist > 30) then
							geogriffin.vecAdd(pushForce, geogriffin.vecLinMul(geogriffin.getAngFromPos(targetPos, value), 400));
						elseif (targetDist > 15) then
						    geogriffin.vecAdd(pushForce, geogriffin.vecLinMul(geogriffin.getAngFromPos(targetPos, value), 100));
						end
						--_Msg("%f", targetDist);
					end
					_EntSetVelocity(target.id, pushForce);
					--_EntSetAngAngle(target.id, target.curAngle);
					if (changed == false) then
						geogriffin.weapon_physgun_le.targets[targetKey] = nil;
						--_phys.EnableGravity(target.id, true);
						--_EntSetGravity(target.id, 1);
					end
				end
			end
		end
	end
end

function geogriffin.weapon_physgun_le.onThink(physgun)
	if (_EntExists(physgun.id) == false) then
		geogriffin.weapon_physgun_le.cleanUp(physgun);
	end

	if (physgun.wepFrame == true) then
		geogriffin.weapon_physgun_le.checkSeq(physgun);
		geogriffin.weapon_physgun_le.checkInput(physgun);
		--geogriffin.weapon_physgun_le.updateHud(physgun);
		physgun.wepFrame = false;
	end
		

	if (_CurTime() - physgun.repeatTime > .1) then
		physgun.repeatTime = _CurTime();
	end

	if (_CurTime() - physgun.lastWepFrame > .5) then
		--geogriffin.weapon_physgun_le.clearHud(physgun);
		--geogriffin.weapon_physgun_le.clearCurSetHud(physgun);
	end

	physgun.oldOwner = physgun.owner;
end

function geogriffin.weapon_physgun_le.onAttackPressed(physgun)
	if (_PlayerInfo(physgun.owner, "alive") == false) then return; end
	
	if (physgun.target == nil) then
	    _TraceLine(_PlayerGetShootPos(physgun.owner), _PlayerGetShootAng(physgun.owner), geogriffin.weapon_physgun_le.range, physgun.owner);
		if (_TraceHitNonWorld() == true) then
		    local targetId = _TraceGetEnt();
		    if (geogriffin.weapon_physgun_le.targets[targetId] ~= nil) then
		        physgun.target = geogriffin.weapon_physgun_le.targets[targetId];
		  	else
		    	local newTarget = {
					id = targetId,
					lastPos = _TraceEndPos(),
					lastFrames = {},
					lastFrame = _CurTime(),
					curFrame = 0,
					aimCoords = {},
					physics = _phys.HasPhysics(targetId),
					curAngle = _EntGetAngAngle(targetId),
					mass = _phys.GetMass(targetId),
				};
				
				if (IsPlayer(targetId) == true or string.find(_EntGetType(targetId), "^npc_.*") ~= nil) then
					newTarget.physics = false;
				end
				
				if (newTarget.physics == true) then
					_phys.EnableGravity(targetId, false);
					_phys.EnableDrag(targetId, false);
					_phys.EnableMotion(targetId, true);
				else
					_phys.EnableGravity(targetId, false);
				    _EntSetGravity(targetId, 0);
				end
				newTarget.aimCoords[physgun.id] = _TraceEndPos();
				physgun.target = newTarget;
				geogriffin.weapon_physgun_le.targets[targetId] = newTarget;
			end
			physgun.curRadius = vecLength(vecSub(_EntGetPos(targetId), _EntGetPos(physgun.owner)));
		end
	else
	    _TraceSetCollisionGroup(COLLISION_GROUP_NONE);
	    _TraceLine(_PlayerGetShootPos(physgun.owner), _PlayerGetShootAng(physgun.owner), physgun.curRadius, physgun.target.id);
	    --if (_TraceHitWorld() == false) then
			physgun.target.aimCoords[physgun.id] = _TraceEndPos();
		--end
	end
end

function geogriffin.weapon_physgun_le.onAttackReleased(physgun)
	if (_PlayerInfo(physgun.owner, "alive") == false) then return; end
	if (physgun.target ~= nil) then
	    physgun.target.aimCoords[physgun.id] = nil;
		physgun.target = nil;
		_EntRemove(physgun.beamId);
		physgun.beamId = nil;
		_EntRemove(physgun.beamEndpointId);
		physgun.beamEndpointId = nil;
	end
end

function geogriffin.weapon_physgun_le.onReloadPressed(physgun)
    if (_PlayerInfo(physgun.owner, "alive") == false) then return; end
	if (physgun.target ~= nil) then
	    _TraceSetCollisionGroup(COLLISION_GROUP_NONE);
	    _TraceLine(_PlayerGetShootPos(physgun.owner), _PlayerGetShootAng(physgun.owner), physgun.curRadius, physgun.target.id);
		if (physgun.target.physics == true) then
			_phys.EnableMotion(physgun.target.id, false);
		else
			physgun.target.aimCoords[physgun.id] = _EntGetPos(physgun.target.id);
		end
		_EntRemove(physgun.beamId);
		physgun.beamId = nil;
		_EntRemove(physgun.beamEndpointId);
		physgun.beamEndpointId = nil;
    	physgun.target = nil;
	else
	    _TraceLine(_PlayerGetShootPos(physgun.owner), _PlayerGetShootAng(physgun.owner), geogriffin.weapon_physgun_le.range, physgun.owner);
		if (_TraceHitNonWorld() == true) then
      		local targetId = _TraceGetEnt();
		    if (geogriffin.weapon_physgun_le.targets[targetId] ~= nil) then
		        physgun.target.aimCoords[physgun.id] = _EntGetPos(physgun.target.id);
		  	else
		    	local newTarget = {
					id = targetId,
					lastPos = _TraceEndPos(),
					lastFrames = {},
					lastFrame = _CurTime(),
					curFrame = 0,
					aimCoords = {},
					physics = _phys.HasPhysics(targetId),
					curAngle = _EntGetAngAngle(targetId),
					mass = _phys.GetMass(targetId),
				};
				
				if (IsPlayer(targetId) == true or string.find(_EntGetType(targetId), "^npc_.*") ~= nil) then
					newTarget.physics = false;
				end
				
				if (newTarget.physics == true) then
					_phys.EnableMotion(targetId, false);
				else
					_phys.EnableGravity(targetId, false);
				    --_EntSetGravity(targetId, 0);
					newTarget.aimCoords[physgun.id] = _EntGetPos(targetId);
					geogriffin.weapon_physgun_le.targets[targetId] = newTarget;
				end
			end
		end
	end
end

function geogriffin.weapon_physgun_le.onReloadReleased(physgun)
    if (_PlayerInfo(physgun.owner, "alive") == false) then return; end
end

function geogriffin.weapon_physgun_le.onSecAttackPressed(physgun)
	if (_PlayerInfo(physgun.owner, "alive") == false) then return; end
	if (physgun.target ~= nil) then
	    _TraceSetCollisionGroup(COLLISION_GROUP_NONE);
	    _TraceLine(_PlayerGetShootPos(physgun.owner), _PlayerGetShootAng(physgun.owner), physgun.curRadius, physgun.target.id);
		if (false) then
			_phys.EnableMotion(physgun.target.id, false);
		else
			physgun.target.aimCoords[physgun.id] = _EntGetPos(physgun.target.id);
		end
		_EntRemove(physgun.beamId);
		physgun.beamId = nil;
		_EntRemove(physgun.beamEndpointId);
		physgun.beamEndpointId = nil;
    	physgun.target = nil;
	else
	    _TraceLine(_PlayerGetShootPos(physgun.owner), _PlayerGetShootAng(physgun.owner), geogriffin.weapon_physgun_le.range, physgun.owner);
		if (_TraceHitNonWorld() == true) then
      		local targetId = _TraceGetEnt();
		    if (geogriffin.weapon_physgun_le.targets[targetId] ~= nil) then
		        physgun.target.aimCoords[physgun.id] = _EntGetPos(physgun.target.id);
		  	else
				if (false) then
					_phys.EnableMotion(targetId, false);
				else
			    	local newTarget = {
						id = targetId,
						lastPos = _TraceEndPos(),
						lastFrames = {},
						lastFrame = _CurTime(),
						curFrame = 0,
						aimCoords = {},
						physics = _phys.HasPhysics(targetId),
						curAngle = _EntGetAngAngle(targetId),
						mass = _phys.GetMass(targetId),
					};
					
					if (IsPlayer(targetId) == true or string.find(_EntGetType(targetId), "^npc_.*") ~= nil) then
						newTarget.physics = false;
					end
					
					if (newTarget.physics == true) then
						_phys.EnableGravity(targetId, false);
						_phys.EnableDrag(targetId, false);
						_phys.EnableMotion(targetId, true);
					else
						_phys.EnableGravity(targetId, false);
					    --_EntSetGravity(targetId, 0);
					end
					newTarget.aimCoords[physgun.id] = _EntGetPos(targetId);
					geogriffin.weapon_physgun_le.targets[targetId] = newTarget;
				end
			end
		end
	end
end

function geogriffin.weapon_physgun_le.onSecAttackReleased(physgun)
    if (_PlayerInfo(physgun.owner, "alive") == false) then return; end
end


function geogriffin_weapon_physgun_le_thinkFunc()
	if (geogriffin.weapon_physgun_le == nil) then return; end
	for key, value in pairs(geogriffin.weapon_physgun_le.physguns) do
	    if (value ~= nil) then
	    		geogriffin.weapon_physgun_le.onThink(value);
		end
	end
	geogriffin.weapon_physgun_le.globalThink();
end

AddThinkFunction(geogriffin_weapon_physgun_le_thinkFunc);
--]]);
end

-- Gun code --

function onInit()
end

function onThink()
	if (init == false) then
    		weapon_physgun_le_init();
			--_Msg(string.format("%d\n", MyIndex));
    		init = true;
	end
	_RunString("if (geogriffin.weapon_physgun_le ~= nil and geogriffin.weapon_physgun_le.physguns[" .. MyIndex .. "] ~= nil) then geogriffin.weapon_physgun_le.physguns[" .. MyIndex .. "].owner = " .. Owner .. "; end");
	_RunString("if (geogriffin.weapon_physgun_le ~= nil and geogriffin.weapon_physgun_le.physguns[" .. MyIndex .. "] ~= nil) then geogriffin.weapon_physgun_le.physguns[" .. MyIndex .. "].lastWepFrame = " .. _CurTime() .. "; end");
	_RunString("if (geogriffin.weapon_physgun_le ~= nil and geogriffin.weapon_physgun_le.physguns[" .. MyIndex .. "] ~= nil) then geogriffin.weapon_physgun_le.physguns[" .. MyIndex .. "].wepFrame = true; end");

	--geogriffin.weapon_physgun_le_onThink();
end

function onPrimaryAttack()
end


function onSecondaryAttack()
end

function onReload()
	return false;
end

function getPrintName() return "The Physics Gun Lua Edition"; end
function getClassName() return "weapon_physgun_le"; end

function getViewModel() return "models/weapons/v_superphyscannon.mdl"; end
function getWorldModel() return "models/weapons/w_physics.mdl"; end
function getAnimPrefix() return "rpg"; end
function getHUDMaterial() return "gmod/SWEP/default"; end

function getWeaponSwapHands() return false; end

function getWeaponFOV() return 57; end

function getWeaponSlot() return 5; end
function getWeaponSlotPos() return 5; end

function getFiresUnderwater() return false; end

function getReloadsSingly() return false; end

function getDamage() return 0; end
function getDamageSecondary() return 10; end

function getPrimaryShotDelay() return 0.4; end
function getSecondaryShotDelay() return 0.4; end

function getPrimaryIsAutomatic() return false; end
function getSecondaryIsAutomatic() return false; end

function getMaxClipPrimary() return 1; end
function getMaxClipSecondary() return 0; end

function getDefClipPrimary() return 1; end
function getDefClipSecondary() return 0; end

function getNumShotsPrimary() return 0; end
function getNumShotsSecondary() return 0; end

function getPrimaryScriptOverride() return 3; end
function getSecondaryScriptOverride() return 3; end

function getBulletSpread() return vector3(0, 0, 0); end
function getViewKick() return vector3(0, 0, 0); end
function getViewKickRandom() return vector3(0, 0, 0); end

function getBulletSpreadSecondary() return vector3(0, 0, 0); end
function getViewKickSecondary() return vector3(0, 0, 0); end
function getViewKickRandomSecondary() return vector3(0, 0, 0); end

function getPrimaryAmmoType() return "pistol"; end
function getSecondaryAmmoType() return "pistol"; end

-- Unused Code Fragments --