

-- This is the base SWEP (Scripted Weapon).

-- DO NOT change this file.

-- When making a new weapon you only need to override what you need.





_OpenScript( "includes/vector3.lua" )






-- These variables are passed by the engine



MyIndex			=	0; -- Weapon's entity index.
Owner			= 	0; -- The player that owns this weapon
CurrentTime		=	0; -- The current game time


-- Called when the weapon is created.
tornadoforce=1600000000
tornadoradius=2000000

function pointgrav(centervec,zerooffset,radius,force)
    for key,found in _EntitiesFindInSphere(centervec,radius) do -- Get the enities in the radius
        if _phys.HasPhysics(found) or ( _EntGetType(found) == "player")then
            local entpos = _EntGetPos(found)
            if ( centervec.x == entpos.x and centervec.y == entpos.y and centervec.z == entpos.z ) then return end -- Zero distance, vecNormalize would crash the game
            local gravforce = force * _phys.GetMass(found) / (vecLength(vecSub(centervec,entpos)) + (zerooffset)) ^ 2
            local entvec = vecNormalize(vecSub(centervec,entpos))
            local gravforcevec = vecMul(entvec,vector3(gravforce,gravforce,gravforce))
        
            -- Apply force to objects
            if _phys.HasPhysics(found)then
                _phys.ApplyForceCenter(found,gravforcevec)
            -- Apply force to players
            end
            if _EntGetType(found) == "player" then
                local velocity = vecMul( gravforcevec, vector3( 1/85, 1/85, 1/85 ) )
                _EntSetVelocity( found, vecAdd( _EntGetVelocity( found ), velocity ) )
            end
        end
    end
end




   function onInit( )
      
   end

-- Called every frame

   function onThink( )
      if( _EntExists( SmokeCloud ))then
         pointgrav( tornadocenter, 8000,tornadoradius,tornadoforce);
      end
   end
-- When the player presses left mouse button

	function onPrimaryAttack( )	
      if( _EntExists( SmokeCloud )==false)then
		if ( _PlayerInfo( Owner, "alive" ) == false ) then return; end
	   local vecpos = _PlayerGetShootPos( Owner );
	   local plyang = _PlayerGetShootAng( Owner );
	   _TraceLine( vecpos, plyang, 9000, Owner );
	    local hitpos = _TraceEndPos();
	   if ( _TraceHit() == false )  then
	     hitpos = vecAdd( vecpos, vecMul( plyang, vector3(8000,8000,8000) ) )
	   end

		_EffectInit();
		
			_EffectSetEnt( Owner );
			_EffectSetOrigin( hitpos );
			_EffectSetStart( vecpos);
			_EffectSetScale( 10);
			_EffectSetMagnitude( 5);
		_EffectDispatch( "TeslaZap" );
		_EffectSetMagnitude( 5 );
		_EffectSetScale( 10 );
		_EffectDispatch( "TeslaZap" );
		_EffectSetMagnitude( 5 );
		_EffectSetScale( 10 );
		_EffectDispatch( "TeslaZap" );
   _EntEmitSound(Owner,"ambient/energy/spark5.wav")


	SmokeCloud = _EntCreate( "env_smokestack" )
   _EntSetKeyValue( SmokeCloud, "BaseSpread", "300" )
   _EntSetKeyValue( SmokeCloud, "SpreadSpeed", "2000" )
   _EntSetKeyValue( SmokeCloud, "Speed", "2000" )
   _EntSetKeyValue( SmokeCloud, "StartSize", "400" )
   _EntSetKeyValue( SmokeCloud, "EndSize", "500" )
   _EntSetKeyValue( SmokeCloud, "Rate", "100" )
   _EntSetKeyValue( SmokeCloud, "JetLength", "10000" )
   _EntSetKeyValue( SmokeCloud, "twist", "900" )
   _EntSetKeyValue( SmokeCloud, "SmokeMaterial", "particle/SmokeStack.vmt" )
   _EntSetKeyValue( SmokeCloud, "renderamt", "100" )
   _EntSpawn( SmokeCloud )
   _EntSetPos( SmokeCloud, hitpos)
   _EntFire( SmokeCloud, "turnon", "", 1 )
   _EntFire( SmokeCloud, "kill", "", 20 )
   tornadocenter=_EntGetPos( SmokeCloud );
   tornadocenter=vecAdd(tornadocenter, vector3(0,0,5000));
	SmokeCloud2 = _EntCreate( "env_smokestack" )
   _EntSetKeyValue( SmokeCloud2, "BaseSpread", "2000" )
   _EntSetKeyValue( SmokeCloud2, "SpreadSpeed", "50" )
   _EntSetKeyValue( SmokeCloud2, "Speed", "1000" )
   _EntSetKeyValue( SmokeCloud2, "StartSize", "2000" )
   _EntSetKeyValue( SmokeCloud2, "EndSize", "3000" )
   _EntSetKeyValue( SmokeCloud2, "Rate", "20" )
   _EntSetKeyValue( SmokeCloud2, "JetLength", "1000" )
   _EntSetKeyValue( SmokeCloud2, "twist", "500" )
   _EntSetKeyValue( SmokeCloud2, "SmokeMaterial", "particle/SmokeStack.vmt" )
   _EntSetKeyValue( SmokeCloud2, "renderamt", "50" )
   _EntSpawn( SmokeCloud2 )
   _EntSetPos( SmokeCloud2, hitpos)
   _EntFire( SmokeCloud2, "turnon", "", 2 )
   _EntFire( SmokeCloud2, "kill", "", 21 )
  end
end

-- When the player presses right mouse button



	function onSecondaryAttack( )		
   _EntRemove(SmokeCloud2)
   _EntRemove(SmokeCloud)
	end


   function Holster()
   _EntRemove(SmokeCloud2)
   _EntRemove(SmokeCloud)
   end
-- When player presses reload. Returning false means DONT RELOAD. Although this will hitch on the client.

	function onReload( )

		return false;

	end

-- These are only accessed once when setting up the weapon


	function getWeaponSwapHands()
		return false;	
	end
	
	function getWeaponFOV()
		return 30;	
	end

	function getWeaponSlot()
		return 5;	
	end

	function getWeaponSlotPos()
		return 5;	
	end

	function getFiresUnderwater()
		return true;
	end

	

	function getReloadsSingly()
		return false;
	end

	-- Primary Attack

	function getDamage()
		return 0;
	end
	
	function getPrimaryShotDelay()
		return 0.1;
	end

	function getPrimaryIsAutomatic()
		return false;
	end

	function getBulletSpread()
		return vector3( 0.01, 0.01, 0.01 );
	end
	
	function getViewKick()
		return vector3( 0.5, 0.0, 0.0);
	end
	
	function getViewKickRandom()
		return vector3( 0.5, 0.5, 0.2 );
	end

	function getNumShotsPrimary()
		return 1;
	end
	
	function getPrimaryAmmoType()
		return "357";
	end

	function getViewModel( )
		return "models/weapons/v_crowbar.mdl";
	end
	
	function getWorldModel( )
		return "models/weapons/w_physics.mdl";
	end
	
	function getClassName() 
		return "weapon_tornado";
	end

	function getHUDMaterial( )
		return "gmod/SWEP/default";
	end

	function getMaxClipPrimary() -- return -1 if it doesn't use clips
		return -1;
	end
	
	function getMaxClipSecondary() -- return -1 if it doesn't use clips
		return -1;
	end
	
	function getDefClipPrimary() -- ammo in gun by default
		return 1;
	end

	function getAnimPrefix() -- How the player holds the weapon: pistol, smg, ar2, shotgun, rpg, phys, crossbow, melee, slam, grenade
		return "phys";
	end

	function getPrintName()
		return "Tornado";
	end
	-- 0 = Don't override, shoot bullets, make sound and flash
	-- 1 = Don't shoot bullets but do make flash/sounds
	-- 2 = Only play animations
	-- 3 = Don't do anything

	function getPrimaryScriptOverride()
		return 3;
	end

	function getSecondaryScriptOverride()
		return 3;
	end





	function getDamageSecondary()

		return 0;

	end

	

	function getSecondaryShotDelay()

		return 0.2;

	end

	

	function getSecondaryIsAutomatic()

		return false;

	end

	

	function getBulletSpreadSecondary()

		return vector3( 0.001, 0.001, 0.001 );

	end

	

	function getViewKickSecondary()

		return vector3( 0.5, 0.0, 0.0);

	end

	

	function getViewKickRandomSecondary()

		return vector3( 0.5, 0.5, 0.2 );

	end

	

	function getNumShotsSecondary()

		return 1;

	end

	

	function getSecondaryAmmoType()

		return "357";

	end


	