function onInit()
	_EntPrecacheModel("models/kubb_klubba/klubb.mdl");
	_SWEPSetSound( MyIndex, "single_shot", "Weapon_XM1014.Single" );
	mode = 1
	
	autoremove = false	-- If the harpoons shall get autoremoved. true/false. Default: false
	delay = 20			-- How long before the harpoons get removed. Default: 20
	shotdelay = 2.0		-- Shots/second. Default: 3
end

function onThink()
	local harpoons = _EntitiesFindByName("harpoon"..Owner);
	if (_EntExists(harpoon) == true) then
		for harpoon in harpoons do
		_TraceLine( _EntGetPos(harpoons[harpoon]) , _EntGetAng(harpoons[harpoon]), 60, harpoons[harpoon] );
			if (string.find(_EntGetType(_TraceGetEnt()), "player" )) then
			_TraceAttack( _TraceGetEnt(), Owner, Owner, 100);
			end
			
			if (string.find(_EntGetType(_TraceGetEnt()), "npc_rollermine" )) or (string.find(_EntGetType(_TraceGetEnt()), "npc_turret_floor" )) then
			_EntRemove(harpoons[harpoon])
			end
		end
	end
end


function onPrimaryAttack()
	harpoon = _EntCreate( "prop_physics" );
	
	local pos = _PlayerGetShootPos( Owner );
	local ang = _PlayerGetShootAng( Owner );
	local vel = vecMul( ang, 10000000 ); 
	
	local fvec = _EntGetForwardVector( Owner );
	local fvec = vecAdd( fvec, vector3( 0, 0, 0 ) );
	local fowardpos =  vecAdd( pos, vecMul( fvec, vector3(80,80,80)))
	
	_EntSetModel(harpoon, "models/kubb_klubba/klubb.mdl");	
	--_EntSetPos(harpoon, fowardpos);
	_EntSetPos(harpoon, pos);
	_EntSetAng(harpoon, ang);
	_EntSetOwner( harpoon, Owner )
	_EntitySetPhysicsAttacker(harpoon, Owner);
	_EntSetName( harpoon, "harpoon"..Owner );
	_EntSpawn(harpoon);
	if autoremove then
	_EntFire(harpoon,"kill","",delay)
	end
	if mode == 1 then
	_PhysEnableDrag( harpoon, false );
	_PhysEnableGravity( harpoon, false );
	elseif mode == 0 then
	_PhysEnableDrag( harpoon, true );
	_PhysEnableGravity( harpoon, true );
	end
	_EntitySetPhysicsAttacker(harpoon, Owner)
	_phys.ApplyForceCenter(harpoon, vel);
end

function onSecondaryAttack()
	

end

function text(text)
	_GModText_Start("CloseCaption_Normal");
	_GModText_SetPos(0.60, 0.5);
	_GModText_SetColor( 100, 30, 200, 200 );
	_GModText_SetTime( 1, 0, 0.5 );
	_GModText_SetText( text);
	_GModText_SetDelay( 0 );
	_GModText_Send( Owner, 999 );
end

function onReload()
	local harpoons = _EntitiesFindByName("harpoon"..Owner);
	if _EntExists(harpoon) == true then
		_EntEmitSound(Owner, "weapons/mac10/mac10_boltpull.wav");
		for harpoon in harpoons do
		_EntRemove(harpoons[harpoon])
		end
	end
end

function getPrintName() return "kubb shotgun"; end
function getClassName() return "weapon_kubbshotgun"; end
function getPrimaryAmmoType() return "none"; end
function getSecondaryAmmoType() return "none"; end
function getViewModel() return "models/weapons/v_shot_xm1014.mdl"; end
function getWorldModel() return "models/weapons/w_shot_xm1014.mdl"; end
function getAnimPrefix() return "pistol"; end
function getWeaponSwapHands() return true; end
function getWeaponFOV() return 90; end
function getWeaponSlot() return 1; end
function getWeaponSlotPos() return 5; end
function getFiresUnderwater() return true; end
function getReloadsSingly() return false; end
function getDamage() return 10; end
function getPrimaryShotDelay() return shotdelay; end
function getSecondaryShotDelay() return 0.01; end
function getPrimaryIsAutomatic() return true; end
function getSecondaryIsAutomatic() return false; end
function getMaxClipPrimary() return 1; end
function getMaxClipSecondary() return 1; end
function getDefClipPrimary() return 1; end
function getDefClipSecondary() return 1; end
function getPrimaryScriptOverride() return 1; end
function getSecondaryScriptOverride() return 3; end
function getBulletSpread() return vector3(0.0, 0.0, 0.0); end
function getViewKick() return vector3(0, 0.0, 0.0); end
function getViewKickRandom() return vector3(0.0, 0.0, 0.0); end 